/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.quota;

import it.grid.storm.space.ExitCode;
import it.grid.storm.space.quota.GPFSQuotaInfo;
import java.util.ArrayList;
import java.util.List;

public class GPFSQuotaCommandResult
implements Cloneable {
    private List<GPFSQuotaInfo> quotaResults;
    private long durationTime;
    private long startTime;
    private ExitCode cmdResult;

    public GPFSQuotaCommandResult() {
        this.startTime = System.currentTimeMillis();
        this.quotaResults = new ArrayList<GPFSQuotaInfo>();
        this.cmdResult = ExitCode.UNDEFINED;
    }

    public GPFSQuotaCommandResult(List<GPFSQuotaInfo> quotaRes, long startTime, long durTime, ExitCode cmdRes) {
        this.quotaResults = quotaRes;
        this.startTime = startTime;
        this.durationTime = durTime;
        this.cmdResult = cmdRes;
    }

    public void setQuotaInfos(List<GPFSQuotaInfo> quotaRes) {
        this.quotaResults = quotaRes;
        this.cmdResult = ExitCode.UNDEFINED;
        int nrFailure = 0;
        int nrNotProcessed = 0;
        int totalQuotas = this.quotaResults.size();
        for (GPFSQuotaInfo gpfsQuotaInfo : quotaRes) {
            if (gpfsQuotaInfo.isFailure()) {
                ++nrFailure;
                continue;
            }
            if (gpfsQuotaInfo.isInitializated()) continue;
            ++nrNotProcessed;
        }
        if (nrFailure > 0 && nrFailure + nrNotProcessed < totalQuotas) {
            this.cmdResult = ExitCode.PARTIAL_SUCCESS;
        } else if (nrFailure + nrNotProcessed >= totalQuotas) {
            this.cmdResult = ExitCode.FAILURE;
        }
    }

    public final long getDurationTime() {
        return this.durationTime;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final ExitCode getCmdResult() {
        return this.cmdResult;
    }

    public final void endOfExecution() {
        this.durationTime = System.currentTimeMillis() - this.startTime;
    }

    public final void setCmdResult(ExitCode cmdResult) {
        this.cmdResult = cmdResult;
    }

    public final List<GPFSQuotaInfo> getQuotaResults() {
        return this.quotaResults;
    }

    public final void setQuotaResults(List<GPFSQuotaInfo> quotaResults) {
        this.quotaResults = quotaResults;
    }

    public final void addQuotaResult(GPFSQuotaInfo quotaResult) {
        this.quotaResults.add(quotaResult);
    }

    public Object clone() throws CloneNotSupportedException {
        return new GPFSQuotaCommandResult(this.getQuotaResults(), this.startTime, this.durationTime, this.cmdResult);
    }
}

