/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.init;

import it.grid.storm.config.IniReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsedSpaceFile {
    private static Logger log = LoggerFactory.getLogger(UsedSpaceFile.class);
    public static final String INI_FILENAME = "used-space.ini";
    private static final String PATTERN_RFC2822 = "EEE, dd MMM yyyy HH:mm:ss Z";
    private static final String PATTERN_DEFAULT = "EEE MMM dd HH:mm:ss z yyyy";
    private final List<String> saNames = new ArrayList<String>();
    private final Ini iniFile;

    public UsedSpaceFile(List<String> saNames) {
        this.saNames.addAll(saNames);
        this.iniFile = this.retrieveUsedSpaceIniFile();
    }

    private Ini retrieveUsedSpaceIniFile() {
        Ini iniFile = null;
        try {
            iniFile = new IniReader().getIniFile(INI_FILENAME);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to get the Ini file handle for file used-space.ini in the default ini folder " + IniReader.DEFAULT_CONF_PATH);
        }
        return iniFile;
    }

    public List<SaUsedSize> getDefinedSizes() {
        LinkedList<SaUsedSize> saUsedSizeList = new LinkedList<SaUsedSize>();
        log.debug("Initializing '" + this.saNames.size() + "' not initializated storage areas");
        if (this.iniFile != null) {
            ArrayList<String> storageAreas = this.getSAdefined(this.iniFile);
            for (String saName : storageAreas) {
                Profile.Section section = (Profile.Section)this.iniFile.get((Object)saName);
                if (section != null) {
                    Long usedSpace = null;
                    Date updateTime = null;
                    block9: for (String optionKey : section.keySet()) {
                        switch (Key.getKey(optionKey)) {
                            case USED_SIZE: {
                                if (section.length((Object)optionKey) > 1) {
                                    log.warn("Unable to get " + Key.USED_SIZE.getName() + " value from section [" + saName + "] . Check for repeated declarations of this " + "Section or repeated declarations of " + Key.USED_SIZE.getName() + " in this section");
                                    continue block9;
                                }
                                try {
                                    usedSpace = Long.parseLong((String)section.get((Object)optionKey));
                                }
                                catch (NumberFormatException e) {
                                    log.warn(Key.USED_SIZE.getName() + " from section [" + saName + "] doesn't contain a valid Long value. NumberFormatException: " + e.getMessage());
                                }
                                continue block9;
                            }
                            case CHECK_TIME: {
                                if (section.length((Object)optionKey) > 1) {
                                    log.warn("Unable to get " + Key.CHECK_TIME.getName() + " value from section [" + saName + "] . Check for repeated declarations of this " + "Section or repeated declarations of " + Key.CHECK_TIME.getName() + " in this section");
                                    continue block9;
                                }
                                try {
                                    updateTime = this.parseDate((String)section.get((Object)optionKey));
                                }
                                catch (ParseException e) {
                                    log.warn(Key.CHECK_TIME.getName() + " from section [" + saName + "] doesn't contain a valid Date value. ParseException: " + e.getMessage());
                                }
                                continue block9;
                            }
                        }
                        log.warn("Key: '" + optionKey + "' from section [" + saName + "] is not recognized as a valid key.");
                    }
                    if (usedSpace == null) continue;
                    saUsedSizeList.add(new SaUsedSize(saName, usedSpace, updateTime));
                    continue;
                }
                log.warn("Unable to find section named " + saName + " in the ini file");
            }
        } else {
            log.info("Unable to get a valid Ini file handle, no storage areas can be initialized");
        }
        return saUsedSizeList;
    }

    private ArrayList<String> getSAdefined(Ini iniFile) throws IllegalArgumentException {
        if (iniFile == null) {
            log.error("Received null iniFile argument");
            throw new IllegalArgumentException("Received null iniFile argument");
        }
        ArrayList<String> storageAreas = new ArrayList<String>();
        log.debug("Number of ini file sections: " + iniFile.size());
        for (String sectionName : iniFile.keySet()) {
            log.debug("SA candidate from ini file is [" + sectionName + "]");
            if (this.saNames.contains(sectionName)) {
                storageAreas.add(sectionName);
                continue;
            }
            log.info("SA defined in the ini file is [" + sectionName + "] is not going to be updated");
        }
        if (storageAreas.size() > 0) {
            log.info("Found '" + storageAreas.size() + "' valid storage area defined in used-space.ini");
        } else {
            log.info("Found no defined Storage Area to initialize using used-size.ini file.");
        }
        return storageAreas;
    }

    private Date parseDate(String dateStr) throws ParseException {
        SimpleDateFormat formatRFC2822 = new SimpleDateFormat(PATTERN_RFC2822);
        SimpleDateFormat formatDefault = new SimpleDateFormat(PATTERN_DEFAULT);
        Date dateUpdate = new Date();
        try {
            dateUpdate = formatRFC2822.parse(dateStr);
            return dateUpdate;
        }
        catch (ParseException e) {
            log.debug("Unable to parse date " + dateStr + " using RFC2822 formatter.ParseException: " + e.getMessage() + " Attempting with default formatter");
            ParseException moreSignificantException = e;
            try {
                dateUpdate = formatDefault.parse(dateStr);
            }
            catch (ParseException e2) {
                log.warn("Unable to parse the date '" + dateStr + "' with default formatter. ParseException: " + e2.getMessage());
                throw moreSignificantException;
            }
            return dateUpdate;
        }
    }

    public class SaUsedSize {
        private final String saName;
        private final Long usedSize;
        private final Date updateTime;

        public SaUsedSize(String saName, Long usedSize, Date updateTime) {
            this.saName = saName;
            this.usedSize = usedSize;
            this.updateTime = updateTime;
        }

        public String getSaName() {
            return this.saName;
        }

        public Long getUsedSize() {
            return this.usedSize;
        }

        public Date getUpdateTime() {
            return this.updateTime;
        }

        public boolean hasUpdateTime() {
            return this.updateTime != null;
        }
    }

    private static enum Key {
        USED_SIZE("usedsize"),
        CHECK_TIME("checktime"),
        FAKE_KEY(null);

        private final String name;

        private Key(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        private static Key getKey(String keyName) throws IllegalArgumentException {
            if (keyName == null) {
                log.error("Received null keyName parameter");
                throw new IllegalArgumentException("Received null keyName parameter");
            }
            Key key = FAKE_KEY;
            for (Key keyElement : Key.values()) {
                if (keyElement.equals((Object)FAKE_KEY) || !keyElement.getName().equals(keyName.trim())) continue;
                key = keyElement;
                break;
            }
            return key;
        }
    }
}

