/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space;

import it.grid.storm.catalogs.InvalidSpaceDataAttributesException;
import it.grid.storm.common.GUID;
import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.common.types.VO;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.persistence.model.StorageSpaceTO;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.InvalidTUserIDAttributeException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TSpaceType;
import it.grid.storm.srm.types.TStorageSystemInfo;
import it.grid.storm.srm.types.TUserID;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageSpaceData {
    private GridUserInterface owner = null;
    private TSpaceType spaceType = null;
    private TSpaceToken spaceToken = null;
    private PFN spaceFileName = null;
    private String spaceTokenAlias = null;
    private TLifeTimeInSeconds spaceLifetime = null;
    private TStorageSystemInfo storageInfo = null;
    private Date creationDate = null;
    private TSizeInBytes totalSpaceSize = null;
    private TSizeInBytes totalGuaranteedSize = null;
    private TSizeInBytes availableSpaceSize = null;
    private boolean availableSpaceSizeForced = false;
    private TSizeInBytes usedSpaceSize = null;
    private TSizeInBytes freeSpaceSize = null;
    private boolean freeSpaceSizeForced = false;
    private TSizeInBytes unavailableSpaceSize = null;
    private TSizeInBytes reservedSpaceSize = null;
    private TSizeInBytes busySpaceSize = null;
    private boolean busySpaceSizeForced = false;
    private static final Logger log = LoggerFactory.getLogger(StorageSpaceData.class);

    public StorageSpaceData() {
    }

    public StorageSpaceData(GridUserInterface guOwner, TSpaceType spaceType, String spaceTokenAlias, TSizeInBytes totalDesiredSize, TSizeInBytes guaranteedSize, TLifeTimeInSeconds spaceLifetime, TStorageSystemInfo storageInfo, Date date, PFN spaceFileName) throws InvalidSpaceDataAttributesException {
        boolean ok = spaceType != null && (guOwner != null || spaceType == TSpaceType.VOSPACE) && spaceTokenAlias != null;
        log.debug("Storage Space Data - User identity : " + guOwner);
        log.debug("Storage Space Data - Space Type : " + spaceType);
        log.debug("Storage Space Data - Space Token Alias : " + spaceTokenAlias);
        if (!ok) {
            throw new InvalidSpaceDataAttributesException(guOwner);
        }
        this.owner = guOwner;
        this.spaceType = spaceType;
        try {
            this.spaceToken = TSpaceToken.make(new GUID().toString());
        }
        catch (InvalidTSpaceTokenAttributesException ex) {
            log.error("Exception occurred while trying to generate a Token with GUID", (Throwable)ex);
        }
        this.spaceTokenAlias = spaceTokenAlias;
        this.totalSpaceSize = totalDesiredSize;
        this.totalGuaranteedSize = guaranteedSize;
        this.spaceLifetime = spaceLifetime;
        this.storageInfo = storageInfo;
        this.creationDate = date;
        this.spaceFileName = spaceFileName;
        this.usedSpaceSize = TSizeInBytes.makeEmpty();
        this.reservedSpaceSize = TSizeInBytes.makeEmpty();
        this.unavailableSpaceSize = TSizeInBytes.makeEmpty();
    }

    public StorageSpaceData(StorageSpaceTO ssTO) throws IllegalArgumentException {
        if (ssTO == null) {
            log.error("Unable to create StorageSpaceData object, provided StorageSpaceTO parameter is null");
            throw new IllegalArgumentException("Received null argument");
        }
        if (ssTO.getOwnerName() != null && ssTO.getVoName() != null && !ssTO.getVoName().equals(VO.NO_VO.getValue())) {
            try {
                this.owner = GridUserManager.makeVOMSGridUser(ssTO.getOwnerName(), ssTO.getVoName());
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
                throw e;
            }
        } else {
            this.owner = GridUserManager.makeGridUser(ssTO.getOwnerName());
        }
        if (this.owner != null) {
            log.trace("StorageSpaceData - Owner: " + this.owner.toString());
        } else {
            log.trace("StorageSpaceData - Owner: NULL");
        }
        this.spaceType = TSpaceType.getTSpaceType(ssTO.getSpaceType());
        if (this.spaceType != null) {
            log.trace("StorageSpaceData - spaceType: " + this.spaceType);
        } else {
            log.trace("StorageSpaceData - spaceType: NULL");
        }
        this.spaceTokenAlias = ssTO.getAlias();
        if (this.spaceTokenAlias != null) {
            log.trace("StorageSpaceData - spaceTokenAlias: " + this.spaceTokenAlias);
        } else {
            log.trace("StorageSpaceData - spaceTokenAlias: NULL");
        }
        try {
            this.spaceToken = TSpaceToken.make(ssTO.getSpaceToken());
        }
        catch (InvalidTSpaceTokenAttributesException ex) {
            log.error("Error while constructing TSpaceToken", (Throwable)ex);
        }
        if (this.spaceToken != null) {
            log.trace("StorageSpaceData - spaceToken: " + this.spaceToken);
        }
        try {
            this.spaceFileName = PFN.make(ssTO.getSpaceFile());
        }
        catch (InvalidPFNAttributeException e) {
            log.error("Error while constructing Storage Space File Name", (Throwable)e);
        }
        if (this.spaceFileName != null) {
            log.trace("StorageSpaceData - spaceFileName: " + this.spaceFileName);
        }
        try {
            this.spaceLifetime = TLifeTimeInSeconds.make(ssTO.getLifetime(), TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            log.error("Error while constructing Space Life Time", (Throwable)e);
        }
        if (this.spaceLifetime != null) {
            log.trace("StorageSpaceData - spaceLifetime: " + this.spaceLifetime);
        }
        this.storageInfo = TStorageSystemInfo.make(ssTO.getStorageInfo());
        if (this.storageInfo.getValue() != null) {
            log.trace("StorageSpaceData - storageInfo: " + this.storageInfo);
        } else {
            log.trace("StorageSpaceData - storageInfo: NULL");
        }
        this.creationDate = ssTO.getCreated();
        if (this.creationDate != null) {
            log.trace("StorageSpaceData - date: " + this.creationDate);
        } else {
            log.trace("StorageSpaceData - date: NULL");
        }
        log.debug("StorageSpaceData - TOTAL (Desired) size:" + ssTO.getTotalSize());
        this.totalSpaceSize = TSizeInBytes.makeEmpty();
        if (ssTO.getTotalSize() >= 0L) {
            try {
                this.totalSpaceSize = TSizeInBytes.make(ssTO.getTotalSize(), SizeUnit.BYTES);
                log.trace("StorageSpaceData - TotalSize (desired): " + this.totalSpaceSize);
            }
            catch (InvalidTSizeAttributesException ex1) {
                log.error("Error while constructing TotalSize (desired)", (Throwable)ex1);
            }
        } else {
            log.trace("StorageSpaceData - TotalSize (desired): EMPTY " + this.totalSpaceSize);
        }
        log.debug("StorageSpaceData - TOTAL (Guaranteed) size:" + ssTO.getGuaranteedSize());
        this.setTotalGuaranteedSize(TSizeInBytes.makeEmpty());
        if (ssTO.getGuaranteedSize() >= 0L) {
            try {
                this.totalGuaranteedSize = TSizeInBytes.make(ssTO.getGuaranteedSize(), SizeUnit.BYTES);
                log.trace("StorageSpaceData - TotalSize (guaranteed): " + this.totalGuaranteedSize);
            }
            catch (InvalidTSizeAttributesException ex2) {
                log.error("Error while constructing SpaceGuaranteed", (Throwable)ex2);
            }
        } else {
            log.trace("StorageSpaceData - TotalSize (guaranteed): EMPTY " + this.totalGuaranteedSize);
        }
        log.trace("StorageSpaceData - AVAILABLE size:" + ssTO.getAvailableSize());
        this.forceAvailableSpaceSize(TSizeInBytes.makeEmpty());
        if (ssTO.getAvailableSize() >= 0L) {
            try {
                this.forceAvailableSpaceSize(TSizeInBytes.make(ssTO.getAvailableSize(), SizeUnit.BYTES));
                log.trace("StorageSpaceData - AVAILABLE size : " + this.getAvailableSpaceSize());
            }
            catch (InvalidTSizeAttributesException ex3) {
                log.error("Error while constructing AvailableSpaceSize", (Throwable)ex3);
            }
        } else {
            log.trace("StorageSpaceData - AVAILABLE size : EMPTY " + this.getAvailableSpaceSize());
        }
        log.trace("StorageSpaceData - FREE (= available + unavailable) size :" + ssTO.getFreeSize());
        this.forceFreeSpaceSize(TSizeInBytes.makeEmpty());
        if (ssTO.getFreeSize() >= 0L) {
            try {
                this.forceFreeSpaceSize(TSizeInBytes.make(ssTO.getFreeSize(), SizeUnit.BYTES));
                log.trace("StorageSpaceData - FREE (= available + unavailable) size : " + this.getFreeSpaceSize());
            }
            catch (InvalidTSizeAttributesException ex3) {
                log.error("Error while constructing FreeSpaceSize", (Throwable)ex3);
            }
        } else {
            log.trace("StorageSpaceData - FREE (= available + unavailable) size : EMPTY " + this.getFreeSpaceSize());
        }
        log.debug("StorageSpaceData - USED size:" + ssTO.getUsedSize());
        this.usedSpaceSize = TSizeInBytes.makeEmpty();
        if (ssTO.getUsedSize() >= 0L) {
            try {
                this.usedSpaceSize = TSizeInBytes.make(ssTO.getUsedSize(), SizeUnit.BYTES);
                log.trace("StorageSpaceData - USED size: " + this.usedSpaceSize);
            }
            catch (InvalidTSizeAttributesException ex3) {
                log.error("Error while constructing UsedSpaceSize", (Throwable)ex3);
            }
        } else {
            log.trace("StorageSpaceData - USED size: EMPTY " + this.usedSpaceSize);
        }
        log.debug("StorageSpaceData - BUSY (= used + reserved + unavailable) size:" + ssTO.getBusySize());
        this.forceBusySpaceSize(TSizeInBytes.makeEmpty());
        if (ssTO.getBusySize() >= 0L) {
            try {
                this.forceBusySpaceSize(TSizeInBytes.make(ssTO.getBusySize(), SizeUnit.BYTES));
                log.trace("StorageSpaceData - BUSY (= used + reserved + unavailable) size:" + this.getBusySpaceSize());
            }
            catch (InvalidTSizeAttributesException ex3) {
                log.error("Error while constructing BusySpaceSize", (Throwable)ex3);
            }
        } else {
            log.trace("StorageSpaceData - BUSY (= used + reserved + unavailable) size: EMPTY " + this.getBusySpaceSize());
        }
        log.trace("StorageSpaceData - UNAVAILABLE size:" + ssTO.getUnavailableSize());
        this.unavailableSpaceSize = TSizeInBytes.makeEmpty();
        if (ssTO.getUnavailableSize() >= 0L) {
            try {
                this.unavailableSpaceSize = TSizeInBytes.make(ssTO.getUnavailableSize(), SizeUnit.BYTES);
                log.trace("StorageSpaceData - UNAVAILABLE size: " + this.unavailableSpaceSize);
            }
            catch (InvalidTSizeAttributesException ex3) {
                log.error("Error while constructing UnavailableSpaceSize", (Throwable)ex3);
            }
        } else {
            log.trace("StorageSpaceData - UNAVAILABLE size: EMPTY " + this.unavailableSpaceSize);
        }
        log.trace("StorageSpaceData - TOTAL (Reserved) size:" + ssTO.getReservedSize());
        this.reservedSpaceSize = TSizeInBytes.makeEmpty();
        if (ssTO.getReservedSize() >= 0L) {
            try {
                this.reservedSpaceSize = TSizeInBytes.make(ssTO.getReservedSize(), SizeUnit.BYTES);
                log.trace("StorageSpaceData - TotalSize (reserved): " + this.reservedSpaceSize);
            }
            catch (InvalidTSizeAttributesException ex2) {
                log.error("Error while constructing SpaceReserved", (Throwable)ex2);
            }
        } else {
            log.trace("StorageSpaceData - Reserved : EMPTY " + this.reservedSpaceSize);
        }
    }

    public boolean isInitialized() {
        return !this.usedSpaceSize.isEmpty() && !this.unavailableSpaceSize.isEmpty();
    }

    public TSpaceType getSpaceType() {
        return this.spaceType;
    }

    public void setSpaceType(TSpaceType spaceType) {
        this.spaceType = spaceType;
    }

    public String getSpaceTokenAlias() {
        return this.spaceTokenAlias;
    }

    public void setSpaceTokenAlias(String alias) {
        this.spaceTokenAlias = alias;
    }

    public TLifeTimeInSeconds getLifeTime() {
        return this.spaceLifetime;
    }

    public void getLifeTime(TLifeTimeInSeconds time) {
        this.spaceLifetime = time;
    }

    public TSpaceToken getSpaceToken() {
        return this.spaceToken;
    }

    public void setSpaceToken(TSpaceToken token) {
        this.spaceToken = token;
    }

    public TUserID getUserID() {
        TUserID userID = null;
        try {
            userID = this.owner != null ? new TUserID(this.owner.getDn()) : new TUserID("EMTPY");
        }
        catch (InvalidTUserIDAttributeException e) {
            log.error("StorageSpaceData: Invalid UserID.", (Throwable)e);
        }
        return userID;
    }

    public String getSpaceFileNameString() {
        return this.spaceFileName.getValue();
    }

    public void setSpaceFileName(PFN spaceFN) {
        this.spaceFileName = spaceFN;
    }

    public PFN getSpaceFileName() {
        return this.spaceFileName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public final GridUserInterface getOwner() {
        return this.owner;
    }

    public final void setOwner(GridUserInterface owner) {
        this.owner = owner;
    }

    public final TLifeTimeInSeconds getSpaceLifetime() {
        return this.spaceLifetime;
    }

    public final void setSpaceLifetime(TLifeTimeInSeconds spaceLifetime) {
        this.spaceLifetime = spaceLifetime;
    }

    public final TStorageSystemInfo getStorageInfo() {
        return this.storageInfo;
    }

    public final void setStorageInfo(TStorageSystemInfo storageInfo) {
        this.storageInfo = storageInfo;
    }

    public final TSizeInBytes getTotalSpaceSize() {
        return this.totalSpaceSize;
    }

    public final void setTotalSpaceSize(TSizeInBytes spaceDesired) {
        this.totalSpaceSize = spaceDesired;
        this.unforceFreeSpaceSize();
        this.unforceAvailableSpaceSize();
    }

    public final TSizeInBytes getReservedSpaceSize() {
        return this.reservedSpaceSize;
    }

    public final void setReservedSpaceSize(TSizeInBytes spaceGuaranteed) {
        this.reservedSpaceSize = spaceGuaranteed;
        this.unforceBusySpaceSize();
    }

    public final TSizeInBytes getFreeSpaceSize() {
        if (!this.freeSpaceSizeForced) {
            if (this.totalSpaceSize == null || this.totalSpaceSize.isEmpty() || this.usedSpaceSize == null || this.usedSpaceSize.isEmpty()) {
                this.freeSpaceSize = TSizeInBytes.makeEmpty();
            } else {
                long size = this.totalSpaceSize.value() - this.usedSpaceSize.value();
                if (size >= 0L) {
                    try {
                        this.freeSpaceSize = TSizeInBytes.make(size, SizeUnit.BYTES);
                    }
                    catch (InvalidTSizeAttributesException e) {
                        log.warn("Unable to create a valid Free Size, used empty one");
                        this.freeSpaceSize = TSizeInBytes.makeEmpty();
                    }
                } else {
                    log.warn("Unable to create a valid Free Space Size, computed free space is lower than zero");
                    this.freeSpaceSize = TSizeInBytes.makeEmpty();
                }
            }
        }
        return this.freeSpaceSize;
    }

    private final void forceFreeSpaceSize(TSizeInBytes freeSpaceSize) {
        this.freeSpaceSizeForced = true;
        this.freeSpaceSize = freeSpaceSize;
    }

    private final void unforceFreeSpaceSize() {
        this.freeSpaceSizeForced = false;
    }

    public final TSizeInBytes getUsedSpaceSize() {
        return this.usedSpaceSize;
    }

    public final void setUsedSpaceSize(TSizeInBytes usedSpaceSize) {
        this.usedSpaceSize = usedSpaceSize;
        this.unforceBusySpaceSize();
        this.unforceFreeSpaceSize();
        this.updateFreeSize();
        this.updateBusySize();
        this.updateAvailableSize();
    }

    private final void updateFreeSize() {
        long freeSizeValue = this.totalSpaceSize.value() - this.getUsedSpaceSize().value();
        if (freeSizeValue < this.totalSpaceSize.value() && freeSizeValue >= 0L) {
            try {
                this.freeSpaceSize = TSizeInBytes.make(freeSizeValue, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException invalidTSizeAttributesException) {
                // empty catch block
            }
        }
    }

    private final void updateBusySize() {
        long usedSizeValue = this.getUsedSpaceSize().value();
        long unavailableSizeValue = this.getUnavailableSpaceSize().value();
        long reservedSizeValue = this.getReservedSpaceSize().value();
        long busySize = usedSizeValue + reservedSizeValue + unavailableSizeValue;
        if (busySize < this.totalSpaceSize.value() && busySize >= 0L) {
            try {
                this.busySpaceSize = TSizeInBytes.make(busySize, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e) {
                // empty catch block
            }
        }
    }

    private final void updateAvailableSize() {
        long busySizeValue = this.getBusySpaceSize().value();
        long availableSizeValue = this.getTotalSpaceSize().value() - busySizeValue;
        if (availableSizeValue < this.totalSpaceSize.value() && availableSizeValue >= 0L) {
            try {
                this.availableSpaceSize = TSizeInBytes.make(availableSizeValue, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e) {
                // empty catch block
            }
        }
    }

    public final TSizeInBytes getUnavailableSpaceSize() {
        return this.unavailableSpaceSize;
    }

    public final void setUnavailableSpaceSize(TSizeInBytes unavailableSpaceSize) {
        this.unavailableSpaceSize = unavailableSpaceSize;
        this.unforceBusySpaceSize();
    }

    public final TSizeInBytes getBusySpaceSize() {
        if (!this.busySpaceSizeForced) {
            if (this.usedSpaceSize == null || this.usedSpaceSize.isEmpty() || this.unavailableSpaceSize == null || this.unavailableSpaceSize.isEmpty() || this.reservedSpaceSize == null || this.reservedSpaceSize.isEmpty()) {
                this.busySpaceSize = TSizeInBytes.makeEmpty();
            } else {
                try {
                    this.busySpaceSize = TSizeInBytes.make(this.usedSpaceSize.value() + this.unavailableSpaceSize.value() + this.reservedSpaceSize.value(), SizeUnit.BYTES);
                }
                catch (InvalidTSizeAttributesException e) {
                    log.warn("Unable to create a valid Busy Size, used empty one");
                    this.busySpaceSize = TSizeInBytes.makeEmpty();
                }
            }
        }
        return this.busySpaceSize;
    }

    public final TSizeInBytes getAvailableSpaceSize() {
        if (!this.availableSpaceSizeForced) {
            if (this.totalSpaceSize == null || this.totalSpaceSize.isEmpty() || this.getBusySpaceSize().isEmpty()) {
                this.availableSpaceSize = TSizeInBytes.makeEmpty();
            } else {
                try {
                    this.availableSpaceSize = TSizeInBytes.make(this.totalSpaceSize.value() - this.getBusySpaceSize().value(), SizeUnit.BYTES);
                }
                catch (InvalidTSizeAttributesException e) {
                    log.warn("Unable to produce the TSizeInBytes object from '" + (this.totalSpaceSize.value() - this.getBusySpaceSize().value()) + "' and '" + SizeUnit.BYTES + "'");
                    this.availableSpaceSize = TSizeInBytes.makeEmpty();
                }
            }
        }
        return this.availableSpaceSize;
    }

    public final void forceAvailableSpaceSize(TSizeInBytes availableSpaceSize) {
        this.availableSpaceSizeForced = true;
        this.availableSpaceSize = availableSpaceSize;
    }

    private final void unforceAvailableSpaceSize() {
        this.availableSpaceSizeForced = false;
    }

    public void setTotalGuaranteedSize(TSizeInBytes totalGuaranteedSize) {
        this.totalGuaranteedSize = totalGuaranteedSize;
    }

    public TSizeInBytes getTotalGuaranteedSize() {
        return this.totalGuaranteedSize;
    }

    private final void forceBusySpaceSize(TSizeInBytes busySpaceSize) {
        this.busySpaceSizeForced = true;
        this.busySpaceSize = busySpaceSize;
    }

    private final void unforceBusySpaceSize() {
        this.busySpaceSizeForced = false;
        this.unforceAvailableSpaceSize();
    }

    public final void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isExpired() {
        if (this.spaceLifetime != null && this.spaceLifetime.isInfinite()) {
            return false;
        }
        Date currentTime = new Date();
        long expirationTimeInMillisec = this.creationDate.getTime() + this.spaceLifetime.value() * 1000L;
        Date expirationTime = new Date(expirationTimeInMillisec);
        return expirationTime.before(currentTime);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n-- StorageSpaceData -- ");
        builder.append("  owner              = ");
        builder.append(this.owner);
        builder.append("\n");
        builder.append("  spaceType          = ");
        builder.append(this.spaceType);
        builder.append("\n");
        builder.append("  spaceToken         = ");
        builder.append(this.spaceToken);
        builder.append("\n");
        builder.append("  spaceFileName      = ");
        builder.append(this.spaceFileName);
        builder.append("\n");
        builder.append("  spaceTokenAlias    = ");
        builder.append(this.spaceTokenAlias);
        builder.append("\n");
        builder.append("  spaceLifetime      = ");
        builder.append(this.spaceLifetime);
        builder.append("\n");
        builder.append("  storageInfo        = ");
        builder.append(this.storageInfo);
        builder.append("\n");
        builder.append("  creationDate       = ");
        builder.append(this.creationDate);
        builder.append("\n");
        builder.append("  totalSpaceSize     = ");
        builder.append(this.totalSpaceSize);
        builder.append("\n");
        builder.append("  totalGuaranteedSize= ");
        builder.append(this.totalGuaranteedSize);
        builder.append("\n");
        builder.append("  availableSpaceSize = ");
        builder.append(this.availableSpaceSize);
        builder.append("\n");
        builder.append("  availableSpaceSizeForced=");
        builder.append(this.availableSpaceSizeForced);
        builder.append("\n");
        builder.append("  usedSpaceSize      = ");
        builder.append(this.usedSpaceSize);
        builder.append("\n");
        builder.append("  freeSpaceSize      = ");
        builder.append(this.freeSpaceSize);
        builder.append("\n");
        builder.append("  freeSpaceSizeForced= ");
        builder.append(this.freeSpaceSizeForced);
        builder.append("\n");
        builder.append("  unavailableSpaceSize= ");
        builder.append(this.unavailableSpaceSize);
        builder.append("\n");
        builder.append("  reservedSpaceSize   = ");
        builder.append(this.reservedSpaceSize);
        builder.append("\n");
        builder.append("  busySpaceSize       = ");
        builder.append(this.busySpaceSize);
        builder.append("\n");
        builder.append("  busySpaceSizeForced = ");
        builder.append(this.busySpaceSizeForced);
        builder.append("\n");
        builder.append("-- ^^^^^^^^^^^^^^^^ -- ");
        return builder.toString();
    }
}

