/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space;

import it.grid.storm.catalogs.InvalidRetrievedDataException;
import it.grid.storm.catalogs.InvalidSpaceDataAttributesException;
import it.grid.storm.catalogs.MultipleDataEntriesException;
import it.grid.storm.catalogs.NoDataFoundException;
import it.grid.storm.catalogs.ReducedPtPChunkData;
import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.ArrayOfTSpaceToken;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TSpaceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceHelper {
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private Configuration config = Configuration.getInstance();
    private static final Logger log = LoggerFactory.getLogger(SpaceHelper.class);
    public static GridUserInterface storageAreaOwner = GridUserManager.makeSAGridUser();

    private void updateSpaceUsageForSA(Logger log, String funcName, GridUserInterface user, TSURL surl, int operation, long filesize) {
        TSizeInBytes newUsedSize;
        log.debug(funcName + " Updating Storage Area free size on db");
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        StoRI stori = null;
        if (user == null) {
            try {
                stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl);
            }
            catch (UnapprochableSurlException e) {
                log.warn("Unable to build a stori for requested surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                return;
            }
        }
        try {
            stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl, user);
        }
        catch (IllegalArgumentException e) {
            log.error(funcName + " Unable to build StoRI by SURL and user: " + surl, (Throwable)e);
            return;
        }
        catch (UnapprochableSurlException e) {
            log.warn("Unable to build a stori for surl " + surl + " for user " + user + " UnapprochableSurlException: " + e.getMessage());
            return;
        }
        VirtualFSInterface fs = stori.getVirtualFileSystem();
        StorageSpaceData spaceData = null;
        try {
            spaceData = catalog.getStorageSpaceByAlias(fs.getSpaceTokenDescription());
        }
        catch (NamespaceException e1) {
            log.error("Unable to create storage space data", (Throwable)e1);
            return;
        }
        LocalFile localElement = stori.getLocalFile();
        if (spaceData != null && (localElement.exists() || operation == 0)) {
            if (operation == 1) {
                filesize = localElement.getExactSize();
            }
            TSizeInBytes availableSize = spaceData.getAvailableSpaceSize();
            long usedSize = -1L;
            if (operation == 1) {
                usedSize = spaceData.getUsedSpaceSize().value() + filesize;
            } else if (operation == 0) {
                long totalSize;
                long newAvailableSize = availableSize.value() + filesize;
                newAvailableSize = newAvailableSize > (totalSize = spaceData.getTotalSpaceSize().value()) ? totalSize : newAvailableSize;
                long reservedSize = spaceData.getReservedSpaceSize().isEmpty() ? 0L : spaceData.getReservedSpaceSize().value();
                long unavailableSize = spaceData.getUnavailableSpaceSize().isEmpty() ? 0L : spaceData.getUnavailableSpaceSize().value();
                usedSize = totalSize - newAvailableSize - reservedSize - unavailableSize;
            }
            if (usedSize < 0L) {
                usedSize = 0L;
            }
            newUsedSize = spaceData.getTotalSpaceSize();
            try {
                newUsedSize = TSizeInBytes.make(usedSize, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex) {
                log.error(funcName + " Unexpected InvalidTSizeAttributesException , Unable to create  new used size, so the previous one is used", (Throwable)ex);
            }
            spaceData.setUsedSpaceSize(newUsedSize);
            try {
                fs.storeSpaceByToken(spaceData);
            }
            catch (NamespaceException e) {
                log.error(funcName + " Unable to update the new free size.", (Throwable)e);
            }
        } else {
            log.error(funcName + " Unable to update the DB used size!");
            return;
        }
        log.debug(funcName + " Storage Area used size updated to: " + newUsedSize.value());
    }

    public void consumeSpaceForSA(Logger log, String funcName, GridUserInterface user, ArrayList spaceAvailableSURLs) {
        for (int i = 0; i < spaceAvailableSURLs.size(); ++i) {
            log.debug("srmPutDone: Updating Storage Area free size on db");
            ReducedPtPChunkData chunkData = (ReducedPtPChunkData)spaceAvailableSURLs.get(i);
            TSURL surl = chunkData.toSURL();
            this.updateSpaceUsageForSA(log, funcName, user, surl, 1, 0L);
        }
    }

    public void decreaseFreeSpaceForSA(Logger log, String funcName, GridUserInterface user, TSURL surl) {
        this.updateSpaceUsageForSA(log, funcName, user, surl, 1, 0L);
    }

    public void increaseFreeSpaceForSA(Logger log, String funcName, GridUserInterface user, TSURL surl, long fileSize) {
        this.updateSpaceUsageForSA(log, funcName, user, surl, 0, fileSize);
    }

    public void increaseFreeSpaceForSA(Logger log, String funcName, TSURL surl, long fileSize) {
        this.updateSpaceUsageForSA(log, funcName, null, surl, 0, fileSize);
    }

    public boolean isSAFull(Logger log, StoRI stori) {
        log.debug("Checking if the Storage Area is full");
        VirtualFSInterface fs = stori.getVirtualFileSystem();
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        StorageSpaceData spaceData = null;
        try {
            String SSDesc = fs.getSpaceTokenDescription();
            spaceData = catalog.getStorageSpaceByAlias(SSDesc);
        }
        catch (NamespaceException e1) {
            log.error("Unable to create storage space data", (Throwable)e1);
            return false;
        }
        if (spaceData != null && spaceData.getAvailableSpaceSize().value() == 0L) {
            log.debug("AvailableSize=" + spaceData.getAvailableSpaceSize().value());
            return true;
        }
        return false;
    }

    public long getSAFreeSpace(Logger log, StoRI stori) {
        log.debug("Checking if the Storage Area is full");
        VirtualFSInterface fs = stori.getVirtualFileSystem();
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        StorageSpaceData spaceData = null;
        try {
            String SSDesc = fs.getSpaceTokenDescription();
            spaceData = catalog.getStorageSpaceByAlias(SSDesc);
        }
        catch (NamespaceException e1) {
            log.error("Unable to create storage space data", (Throwable)e1);
            return -1L;
        }
        if (spaceData != null) {
            return spaceData.getAvailableSpaceSize().value();
        }
        return -1L;
    }

    public boolean isSAInitialized(Logger log, StoRI stori) throws IllegalArgumentException {
        String SSDesc;
        log.debug("Checking if the Storage Area is initialized");
        if (stori == null || log == null) {
            throw new IllegalArgumentException("Unable to perform the SA initialization check, provided null parameters: log : " + log + " , stori : " + stori);
        }
        boolean response = false;
        VirtualFSInterface fs = stori.getVirtualFileSystem();
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        try {
            SSDesc = fs.getSpaceTokenDescription();
        }
        catch (NamespaceException e) {
            log.error("NamespaceException during VirtualFSInterface.getSpaceTokenDescription(). This is impossible, this exception is never thrown", (Throwable)e);
            return false;
        }
        StorageSpaceData spaceData = catalog.getStorageSpaceByAlias(SSDesc);
        if (spaceData != null && spaceData.getUsedSpaceSize() != null && !spaceData.getUsedSpaceSize().isEmpty() && spaceData.getUsedSpaceSize().value() >= 0L) {
            response = true;
        }
        log.debug("The storage area is initialized with token alias " + spaceData.getSpaceTokenAlias() + " is " + (response ? "" : "not") + "initialized");
        return response;
    }

    public TSpaceToken getTokenFromStoRI(Logger log, StoRI stori) {
        log.debug("SpaceHelper: getting space token from StoRI");
        TSpaceToken token = TSpaceToken.makeEmpty();
        VirtualFSInterface fs = stori.getVirtualFileSystem();
        try {
            token = fs.getSpaceToken();
        }
        catch (NamespaceException e) {
            log.warn("Unable to retrieve SpaceToken for stori:'" + stori + "'");
        }
        return token;
    }

    private Boolean isDefaultSpaceToken(TSpaceToken token) {
        Boolean found = false;
        this.config = Configuration.getInstance();
        List<String> tokens = this.config.getListOfDefaultSpaceToken();
        for (int i = 0; i < tokens.size(); ++i) {
            if (!tokens.get(i).toLowerCase().equals(token.getValue().toLowerCase())) continue;
            found = true;
        }
        return found;
    }

    public TSpaceToken createVOSA_Token(String spaceTokenAlias, TSizeInBytes totalOnLineSize, String spaceFileName) {
        TSpaceToken spaceToken = null;
        ReservedSpaceCatalog spaceCatalog = new ReservedSpaceCatalog();
        ArrayOfTSpaceToken tokenArray = spaceCatalog.getSpaceTokensByAlias(spaceTokenAlias);
        if (tokenArray == null || tokenArray.size() == 0) {
            log.debug("VoSpaceArea " + spaceTokenAlias + " still does not exists. Start creation process.");
            PFN sfname = null;
            try {
                sfname = PFN.make(spaceFileName);
            }
            catch (InvalidPFNAttributeException e1) {
                log.error("Error building PFN with " + spaceFileName + " : " + e1);
            }
            StorageSpaceData ssd = null;
            try {
                ssd = new StorageSpaceData(storageAreaOwner, TSpaceType.VOSPACE, spaceTokenAlias, totalOnLineSize, totalOnLineSize, TLifeTimeInSeconds.makeInfinite(), null, null, sfname);
                try {
                    ssd.setUnavailableSpaceSize(TSizeInBytes.make(0L, SizeUnit.BYTES));
                    ssd.setReservedSpaceSize(TSizeInBytes.make(0L, SizeUnit.BYTES));
                }
                catch (InvalidTSizeAttributesException e) {
                    log.error("Unexpected InvalidTSizeAttributesException: " + e.getMessage());
                }
                spaceToken = ssd.getSpaceToken();
            }
            catch (InvalidSpaceDataAttributesException e) {
                log.error("Error building StorageSpaceData: " + e);
            }
            try {
                spaceCatalog.addStorageSpace(ssd);
            }
            catch (DataAccessException e) {
                log.error("Error storing StorageSpaceData on the DB: " + e);
            }
            ReservedSpaceCatalog.addSpaceToken(spaceToken);
        } else {
            log.debug("VOSpaceArea for space token description " + spaceTokenAlias + " already present into  DB.");
            boolean equal = false;
            spaceToken = tokenArray.getTSpaceToken(0);
            StorageSpaceData catalog_ssd = null;
            try {
                catalog_ssd = spaceCatalog.getStorageSpace(spaceToken);
            }
            catch (TransferObjectDecodingException e) {
                log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            }
            catch (DataAccessException e) {
                log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
            }
            if (catalog_ssd != null && catalog_ssd.getOwner().getDn().equals(storageAreaOwner.getDn()) && catalog_ssd.getSpaceTokenAlias().equals(spaceTokenAlias) && catalog_ssd.getTotalSpaceSize().value() == totalOnLineSize.value() && catalog_ssd.getSpaceFileName().toString().equals(spaceFileName)) {
                equal = true;
            }
            if (equal) {
                log.debug("VOSpaceArea for space token description " + spaceTokenAlias + " is already up to date.");
                ReservedSpaceCatalog.addSpaceToken(spaceToken);
            } else {
                log.debug("VOSpaceArea for space token description " + spaceTokenAlias + " is different in some parameters. Updating the catalog.");
                try {
                    catalog_ssd.setOwner(storageAreaOwner);
                    catalog_ssd.setTotalSpaceSize(totalOnLineSize);
                    catalog_ssd.setTotalGuaranteedSize(totalOnLineSize);
                    PFN sfn = null;
                    try {
                        sfn = PFN.make(spaceFileName);
                    }
                    catch (InvalidPFNAttributeException e) {
                        e.printStackTrace();
                    }
                    catalog_ssd.setSpaceFileName(sfn);
                    spaceCatalog.updateAllStorageSpace(catalog_ssd);
                    ReservedSpaceCatalog.addSpaceToken(spaceToken);
                }
                catch (NoDataFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidRetrievedDataException e) {
                    e.printStackTrace();
                }
                catch (MultipleDataEntriesException e) {
                    e.printStackTrace();
                }
            }
            if (tokenArray.size() > 1) {
                log.error("Error: multiple Space Token found for the same space Alias: " + spaceTokenAlias + ". Only one has been evaluated!");
            }
        }
        return spaceToken;
    }

    public void purgeOldVOSA_token() {
        this.purgeOldVOSA_token(log);
    }

    public void purgeOldVOSA_token(Logger log) {
        int i;
        ReservedSpaceCatalog spacec = new ReservedSpaceCatalog();
        log.debug("VO SA: garbage collecting obsolete VOSA_token");
        Iterator<TSpaceToken> iter = ReservedSpaceCatalog.getTokenSet().iterator();
        while (iter.hasNext()) {
            log.debug("VO SA token REGISTRED:" + iter.next().getValue());
        }
        GridUserInterface stormServiceUser = GridUserManager.makeSAGridUser();
        ArrayOfTSpaceToken token_a = spacec.getSpaceTokens(stormServiceUser, null);
        for (i = 0; i < token_a.size(); ++i) {
            log.debug("VO SA token IN CATALOG:" + token_a.getTSpaceToken(i).getValue());
        }
        if (token_a != null && token_a.size() > 0) {
            for (i = 0; i < token_a.size(); ++i) {
                if (ReservedSpaceCatalog.getTokenSet().contains(token_a.getTSpaceToken(i))) continue;
                TSpaceToken tokenToRemove = token_a.getTSpaceToken(i);
                log.debug("VO SA token " + tokenToRemove + " is no more used, removing it from persistence.");
                spacec.release(stormServiceUser, tokenToRemove);
            }
        } else {
            log.warn("Space Catalog garbage SA_Token: no SA TOKENs specified. Please check your namespace.xml file.");
        }
        ReservedSpaceCatalog.clearTokenSet();
    }

    public static boolean isStorageArea(StorageSpaceData spaceData) throws IllegalArgumentException {
        if (spaceData == null) {
            log.error("Received null spaceData parameter");
            throw new IllegalArgumentException("Received null spaceData parameter");
        }
        boolean result = false;
        if (spaceData.getOwner() != null) {
            result = spaceData.getOwner().equals(storageAreaOwner);
        }
        return result;
    }
}

