/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.util.db;

import it.grid.storm.persistence.util.db.DataBaseStrategy;
import it.grid.storm.persistence.util.db.SQLBuilder;
import it.grid.storm.persistence.util.db.SQLFormat;
import java.util.Date;

public abstract class SQLHelper {
    public String dbmsVendor;
    private SQLFormat formatter;

    protected SQLHelper(String dbmsVendor) {
        this.dbmsVendor = dbmsVendor;
        this.formatter = DataBaseStrategy.getInstance(dbmsVendor).getFormatter();
    }

    public String buildSQL(SQLBuilder builder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(builder.getCommand());
        buffer.append(builder.getTable());
        buffer.append(builder.getWhat());
        buffer.append(builder.getCriteria());
        return buffer.toString();
    }

    public String format(Object value) {
        return this.formatter.format(value);
    }

    public String format(boolean value) {
        String result = null;
        Boolean boolValue = new Boolean(value);
        result = this.formatter.format(boolValue);
        return result;
    }

    public String format(int value) {
        String result = null;
        Integer intValue = null;
        try {
            intValue = new Integer(value);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        result = this.formatter.format(intValue);
        return result;
    }

    public String format(long value) {
        String result = null;
        Long longValue = null;
        try {
            longValue = new Long(value);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        result = this.formatter.format(longValue);
        return result;
    }

    public String format(Date date) {
        return this.formatter.format(date);
    }
}

