/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.util.db;

import it.grid.storm.persistence.DataSourceConnectionFactory;
import it.grid.storm.persistence.exceptions.PersistenceException;
import it.grid.storm.persistence.util.db.DataBaseStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnectionPool
implements DataSourceConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(DBConnectionPool.class);
    private DataBaseStrategy db;
    private static SharedPoolDataSource sharedDatasource;
    private static DBConnectionPool instance;
    private static long handle;

    private DBConnectionPool() {
    }

    public static DBConnectionPool getPoolInstance() {
        if (handle == -1L) {
            return null;
        }
        return instance;
    }

    public static void initPool(DataBaseStrategy db, int maxActive, int maxWait) throws PersistenceException {
        instance.init(db, maxActive, maxWait);
    }

    @Override
    public Connection borrowConnection() throws PersistenceException {
        Connection result = null;
        if (handle == -1L) {
            throw new PersistenceException("Connection Pool is not initializated!");
        }
        try {
            result = sharedDatasource.getConnection();
        }
        catch (SQLException sqle) {
            log.error("SQLException: " + sqle.getMessage() + "/n" + "SQLState: " + sqle.getSQLState() + "/n" + "VendorError: " + sqle.getErrorCode(), (Throwable)sqle);
            throw new PersistenceException("Problem retrieving connection from pool", sqle);
        }
        return result;
    }

    @Override
    public void giveBackConnection(Connection con) throws PersistenceException {
        if (con != null) {
            try {
                this.shutdown(con);
            }
            catch (SQLException sqle) {
                log.error("SQLException: " + sqle.getMessage() + "/n" + "SQLState: " + sqle.getSQLState() + "/n" + "VendorError: " + sqle.getErrorCode(), (Throwable)sqle);
                throw new PersistenceException("Closing existing connection problem", sqle);
            }
        } else {
            throw new PersistenceException("Closing NON-Existing connection");
        }
    }

    public String getPoolInfo() throws PersistenceException {
        String result = "";
        if (handle == -1L) {
            throw new PersistenceException("Connection Pool is not initializated!");
        }
        if (sharedDatasource.getValidationQuery() != null) {
            result = result + "Validation query = " + sharedDatasource.getValidationQuery() + "\n";
        }
        if (sharedDatasource.getDescription() != null) {
            result = result + "Description = " + sharedDatasource.getDescription() + "\n";
        }
        result = result + "Nr Connection Active = " + sharedDatasource.getNumActive() + "\n";
        result = result + "Nr Connection Idle = " + sharedDatasource.getNumIdle() + "\n";
        result = result + "Nr Max Active Connection = " + sharedDatasource.getMaxActive() + "\n";
        return result;
    }

    private void init(DataBaseStrategy db, int maxActive, int maxWait) {
        DBConnectionPool.instance.db = db;
        DriverAdapterCPDS connectionPoolDatasource = new DriverAdapterCPDS();
        try {
            connectionPoolDatasource.setDriver(db.getDriverName());
        }
        catch (Exception ex) {
            log.error("Exception while getting driver", (Throwable)ex);
        }
        connectionPoolDatasource.setUrl(db.getConnectionString());
        connectionPoolDatasource.setUser(db.getDbUsr());
        connectionPoolDatasource.setPassword(db.getDbPwd());
        sharedDatasource = new SharedPoolDataSource();
        sharedDatasource.setConnectionPoolDataSource((ConnectionPoolDataSource)connectionPoolDatasource);
        sharedDatasource.setMaxActive(maxActive);
        sharedDatasource.setMaxWait(maxWait);
        handle = System.currentTimeMillis();
    }

    private void shutdown(Connection conn) throws SQLException {
        conn.close();
        conn = null;
    }

    public static void printInfo(DBConnectionPool pool) {
        System.out.println("INFO ");
        try {
            System.out.println(pool.getPoolInfo());
        }
        catch (PersistenceException ex2) {
            ex2.printStackTrace();
        }
    }

    static {
        instance = new DBConnectionPool();
        handle = -1L;
    }
}

