/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.util.db;

import it.grid.storm.persistence.DataSourceConnectionFactory;
import it.grid.storm.persistence.exceptions.PersistenceException;
import it.grid.storm.persistence.util.db.DataBaseStrategy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnection
implements DataSourceConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(DBConnection.class);
    private Connection connection = null;
    private DataBaseStrategy db;

    public DBConnection(DataBaseStrategy db) throws PersistenceException {
        this.db = db;
        try {
            Class.forName(db.getDriverName()).newInstance();
        }
        catch (Exception ex) {
            log.error("Exception while getting driver", (Throwable)ex);
            throw new PersistenceException("Driver loading problem");
        }
    }

    @Override
    public Connection borrowConnection() throws PersistenceException {
        Connection result = null;
        try {
            result = this.getConnection();
        }
        catch (SQLException sqle) {
            log.error("SQLException: " + sqle.getMessage() + "/n" + "SQLState: " + sqle.getSQLState() + "/n" + "VendorError: " + sqle.getErrorCode(), (Throwable)sqle);
            throw new PersistenceException("Creating new connection problem", sqle);
        }
        return result;
    }

    @Override
    public void giveBackConnection(Connection con) throws PersistenceException {
        if (this.connection != null) {
            try {
                this.shutdown();
            }
            catch (SQLException sqle) {
                log.error("SQLException: " + sqle.getMessage() + "/n" + "SQLState: " + sqle.getSQLState() + "/n" + "VendorError: " + sqle.getErrorCode(), (Throwable)sqle);
                throw new PersistenceException("Closing existing connection problem", sqle);
            }
        } else {
            throw new PersistenceException("Closing NON-Existing connection");
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            String url = this.db.getConnectionString();
            this.connection = DriverManager.getConnection(url, this.db.getDbUsr(), this.db.getDbPwd());
        }
        return this.connection;
    }

    private void shutdown() throws SQLException {
        this.connection.close();
        this.connection = null;
    }
}

