/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.model;

import it.grid.storm.common.types.VO;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.space.StorageSpaceData;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageSpaceTO
implements Serializable,
Comparable<StorageSpaceTO> {
    private static final long serialVersionUID = -87317982494792808L;
    private static final Logger log = LoggerFactory.getLogger(StorageSpaceTO.class);
    private Long storageSpaceId = null;
    private String ownerName = null;
    private String voName = null;
    private String spaceType = null;
    private String alias = null;
    private String spaceToken = null;
    private String spaceFile = null;
    private long lifetime = -1L;
    private String storageInfo = null;
    private Date created = new Date();
    private long totalSize = 0L;
    private long guaranteedSize = 0L;
    private long freeSize = 0L;
    private long usedSize = -1L;
    private long busySize = -1L;
    private long unavailableSize = -1L;
    private long availableSize = -1L;
    private long reservedSize = -1L;
    private Date updateTime = null;

    public StorageSpaceTO() {
    }

    public StorageSpaceTO(StorageSpaceData spaceData) {
        if (spaceData != null) {
            log.debug("Building StorageSpaceTO with " + spaceData);
            if (spaceData.getOwner() != null) {
                this.ownerName = spaceData.getOwner().getDn();
                this.voName = this.getVOName(spaceData.getOwner());
            }
            if (spaceData.getSpaceType() != null) {
                this.spaceType = spaceData.getSpaceType().getValue();
            }
            this.alias = spaceData.getSpaceTokenAlias();
            if (spaceData.getSpaceToken() != null) {
                this.spaceToken = spaceData.getSpaceToken().getValue();
            }
            this.spaceFile = spaceData.getSpaceFileNameString();
            if (spaceData.getTotalSpaceSize() != null) {
                this.totalSize = spaceData.getTotalSpaceSize().value();
            }
            if (spaceData.getTotalGuaranteedSize() != null) {
                this.guaranteedSize = spaceData.getTotalGuaranteedSize().value();
            }
            if (spaceData.getAvailableSpaceSize() != null) {
                this.availableSize = spaceData.getAvailableSpaceSize().value();
            }
            if (spaceData.getUsedSpaceSize() != null) {
                this.usedSize = spaceData.getUsedSpaceSize().value();
            }
            if (spaceData.getFreeSpaceSize() != null) {
                this.freeSize = spaceData.getFreeSpaceSize().value();
            }
            if (spaceData.getUnavailableSpaceSize() != null) {
                this.unavailableSize = spaceData.getUnavailableSpaceSize().value();
            }
            if (spaceData.getBusySpaceSize() != null) {
                this.busySize = spaceData.getBusySpaceSize().value();
            }
            if (spaceData.getReservedSpaceSize() != null) {
                this.reservedSize = spaceData.getReservedSpaceSize().value();
            }
            if (spaceData.getLifeTime() != null) {
                this.lifetime = spaceData.getLifeTime().value();
            }
            if (spaceData.getStorageInfo() != null) {
                this.storageInfo = spaceData.getStorageInfo().getValue();
            }
            if (spaceData.getCreationDate() != null) {
                this.created = spaceData.getCreationDate();
            }
        }
    }

    private String getVOName(GridUserInterface maker) {
        String voStr = VO.makeNoVo().getValue();
        if (maker instanceof AbstractGridUser) {
            voStr = ((AbstractGridUser)maker).getVO().getValue();
        }
        return voStr;
    }

    public Long getStorageSpaceId() {
        return this.storageSpaceId;
    }

    public void setStorageSpaceId(Long id) {
        this.storageSpaceId = id;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getVoName() {
        return this.voName;
    }

    public void setVoName(String voName) {
        this.voName = voName;
    }

    public String getSpaceType() {
        return this.spaceType;
    }

    public void setSpaceType(String spaceType) {
        this.spaceType = spaceType;
    }

    public long getGuaranteedSize() {
        return this.guaranteedSize;
    }

    public void setGuaranteedSize(long guaranteedSize) {
        this.guaranteedSize = guaranteedSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public void setSpaceToken(String spaceToken) {
        this.spaceToken = spaceToken;
    }

    public String getSpaceToken() {
        return this.spaceToken;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setSpaceFile(String spaceFile) {
        this.spaceFile = spaceFile;
    }

    public String getSpaceFile() {
        return this.spaceFile;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public String getStorageInfo() {
        return this.storageInfo;
    }

    public void setStorageInfo(String storageInfo) {
        this.storageInfo = storageInfo;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date date) {
        this.created = date;
    }

    public final long getFreeSize() {
        return this.freeSize;
    }

    public final void setFreeSize(long freeSize) {
        this.freeSize = freeSize;
    }

    public final long getUsedSize() {
        return this.usedSize;
    }

    public final void setUsedSize(long usedSize) {
        this.usedSize = usedSize;
    }

    public final long getBusySize() {
        return this.busySize;
    }

    public final void setBusySize(long busySize) {
        this.busySize = busySize;
    }

    public final long getUnavailableSize() {
        return this.unavailableSize;
    }

    public final void setUnavailableSize(long unavailableSize) {
        this.unavailableSize = unavailableSize;
    }

    public final long getReservedSize() {
        return this.reservedSize;
    }

    public final void setReservedSize(long reservedSize) {
        this.reservedSize = reservedSize;
    }

    public void setAvailableSize(long availableSize) {
        this.availableSize = availableSize;
    }

    public long getAvailableSize() {
        return this.availableSize;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof StorageSpaceTO) {
            if (this == o) {
                return true;
            }
            StorageSpaceTO storageSpace = (StorageSpaceTO)o;
            if (!this.spaceToken.equals(storageSpace.getSpaceToken())) {
                return false;
            }
            return this.spaceFile.equals(storageSpace.getSpaceFile());
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.spaceToken.hashCode();
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ==== STORAGE SPACE (token=" + this.spaceToken + ") ==== \n");
        sb.append(" STORAGE SPACE ID = " + this.storageSpaceId);
        sb.append("\n");
        sb.append(" OWNER USER NAME  = " + this.ownerName);
        sb.append("\n");
        sb.append(" OWNER VO NAME    = " + this.voName);
        sb.append("\n");
        sb.append(" SPACE ALIAS NAME = " + this.alias);
        sb.append("\n");
        sb.append(" SPACE TYPE       = " + this.spaceType);
        sb.append("\n");
        sb.append(" SPACE TOKEN      = " + this.spaceToken);
        sb.append("\n");
        sb.append(" SPACE FILE       = " + this.spaceFile);
        sb.append("\n");
        sb.append(" CREATED          = " + this.created);
        sb.append("\n");
        sb.append(" TOTAL SIZE       = " + this.totalSize);
        sb.append("\n");
        sb.append(" GUARANTEED SIZE  = " + this.guaranteedSize);
        sb.append("\n");
        sb.append(" FREE SIZE        = " + this.freeSize);
        sb.append("\n");
        sb.append(" USED SIZE        = " + this.usedSize);
        sb.append("\n");
        sb.append(" BUSY SIZE        = " + this.busySize);
        sb.append("\n");
        sb.append(" AVAILABLE      = " + this.availableSize);
        sb.append("\n");
        sb.append(" RESERVED      = " + this.reservedSize);
        sb.append("\n");
        sb.append("   UNAVAILABLE    = " + this.unavailableSize);
        sb.append("\n");
        sb.append(" LIFETIME (sec)   = " + this.lifetime);
        sb.append("\n");
        sb.append(" STORAGE INFO     = " + this.storageInfo);
        sb.append("\n");
        sb.append(" UPDATE TIME     = " + this.updateTime);
        sb.append("\n");
        sb.append(" NR STOR_FILES    = <UNDEF for NOW..>");
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(StorageSpaceTO o) {
        if (o instanceof StorageSpaceTO) {
            return this.getCreated().compareTo(o.getCreated());
        }
        return 0;
    }
}

