/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.model;

import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.persistence.model.InvalidPtGChunkDataAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TStorageSystemInfo;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtGChunkTO {
    private static final Logger log = LoggerFactory.getLogger(PtGChunkTO.class);
    private TRequestToken requestToken;
    private TSURL fromSURL;
    private TStorageSystemInfo storageSystemInfo;
    private TLifeTimeInSeconds lifeTime;
    private TFileStorageType fileStorageType;
    private TSpaceToken spaceToken;
    private TDirOption dirOption;
    private TURLPrefix transferProtocols;
    private TSizeInBytes fileSize;
    private TReturnStatus status;
    private TLifeTimeInSeconds estimatedWaitTimeOnQueue;
    private TLifeTimeInSeconds estimatedProcessingTime;
    private TTURL transferURL;
    private TLifeTimeInSeconds remainingPinTime;

    public PtGChunkTO(TRequestToken requestToken, TSURL fromSURL, TStorageSystemInfo storageSystemInfo, TLifeTimeInSeconds lifeTime, TFileStorageType fileStorageType, TSpaceToken spaceToken, TDirOption dirOption, TURLPrefix transferProtocols, TSizeInBytes fileSize, TReturnStatus status, TLifeTimeInSeconds estimatedWaitTimeOnQueue, TLifeTimeInSeconds estimatedProcessingTime, TTURL transferURL, TLifeTimeInSeconds remainingPinTime) throws InvalidPtGChunkDataAttributesException {
        boolean ok;
        boolean bl = ok = requestToken != null && fromSURL != null && storageSystemInfo != null && lifeTime != null && fileStorageType != null && spaceToken != null && dirOption != null && transferProtocols != null && fileSize != null && status != null && estimatedWaitTimeOnQueue != null && estimatedProcessingTime != null && transferURL != null && remainingPinTime != null;
        if (!ok) {
            throw new InvalidPtGChunkDataAttributesException(requestToken, fromSURL, storageSystemInfo, lifeTime, fileStorageType, spaceToken, dirOption, transferProtocols, fileSize, status, estimatedWaitTimeOnQueue, estimatedProcessingTime, transferURL, remainingPinTime);
        }
        this.requestToken = requestToken;
        this.fromSURL = fromSURL;
        this.storageSystemInfo = storageSystemInfo;
        this.lifeTime = lifeTime;
        this.fileStorageType = fileStorageType;
        this.spaceToken = spaceToken;
        this.dirOption = dirOption;
        this.transferProtocols = transferProtocols;
        this.fileSize = fileSize;
        this.status = status;
        this.estimatedWaitTimeOnQueue = estimatedWaitTimeOnQueue;
        this.estimatedProcessingTime = estimatedProcessingTime;
        this.transferURL = transferURL;
    }

    public TRequestToken requestToken() {
        return this.requestToken;
    }

    public TSURL fromSURL() {
        return this.fromSURL;
    }

    public TStorageSystemInfo storageSystemInfo() {
        return this.storageSystemInfo;
    }

    public TLifeTimeInSeconds lifeTime() {
        return this.lifeTime;
    }

    public TFileStorageType fileStorageType() {
        return this.fileStorageType;
    }

    public TSpaceToken spaceToken() {
        return this.spaceToken;
    }

    public TDirOption dirOption() {
        return this.dirOption;
    }

    public TURLPrefix transferProtocols() {
        return this.transferProtocols;
    }

    public TReturnStatus status() {
        return this.status;
    }

    public TSizeInBytes fileSize() {
        return this.fileSize;
    }

    public TLifeTimeInSeconds estimatedWaitTimeOnQueue() {
        return this.estimatedWaitTimeOnQueue;
    }

    public TLifeTimeInSeconds estimatedProcessingTime() {
        return this.estimatedProcessingTime;
    }

    public TTURL transferURL() {
        return this.transferURL;
    }

    public TLifeTimeInSeconds remainingPinTime() {
        return this.remainingPinTime;
    }

    public void changeStatusSRM_REQUEST_QUEUED(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_REQUEST_QUEUED, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_REQUEST_QUEUED! " + e);
        }
    }

    public void changeStatusSRM_DONE(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_DONE, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_DONE! " + e);
        }
    }

    public void changeStatusSRM_INVALID_REQUEST(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_INVALID_REQUEST! " + e);
        }
    }

    public void changeStatusSRM_AUTHORIZATION_FAILURE(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_AUTHORIZATION_FAILURE! " + e);
        }
    }

    public void changeStatusSRM_ABORTED(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_ABORTED, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_ABORTED! " + e);
        }
    }

    public void changeStatusSRM_REQUEST_INPROGRESS(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_REQUEST_INPROGRESS, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_REQUEST_INPROGRESS! " + e);
        }
    }

    public void changeStatusSRM_INTERNAL_ERROR(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_INTERNAL_ERROR, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_INTERNAL_ERROR! " + e);
        }
    }

    public void changeStatusSRM_FATAL_INTERNAL_ERROR(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_FATAL_INTERNAL_ERROR, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_FATAL_INTERNAL_ERROR! " + e);
        }
    }

    public void changeStatusSRM_INVALID_PATH(String explanation) {
        try {
            if (explanation == null) {
                explanation = "";
            }
            this.status = new TReturnStatus(TStatusCode.SRM_INVALID_PATH, explanation);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("UNEXPECTED ERROR! Unable to set SRM request status to SRM_INVALID_PATH! " + e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PtGChunkData\n");
        sb.append("RequestToken=");
        sb.append(this.requestToken);
        sb.append("; ");
        sb.append("fromSURL=");
        sb.append(this.fromSURL);
        sb.append("; ");
        sb.append("storageSystemInfo=");
        sb.append(this.storageSystemInfo);
        sb.append("; ");
        sb.append("lifeTime=");
        sb.append(this.lifeTime);
        sb.append("; ");
        sb.append("fileStorageType=");
        sb.append(this.fileStorageType);
        sb.append("; ");
        sb.append("spaceToken");
        sb.append(this.spaceToken);
        sb.append("; ");
        sb.append("dirOption=");
        sb.append(this.dirOption);
        sb.append("; ");
        sb.append("transferProtocols=");
        sb.append(this.transferProtocols);
        sb.append("; ");
        sb.append("fileSize=");
        sb.append(this.fileSize);
        sb.append("; ");
        sb.append("status=");
        sb.append(this.status);
        sb.append("; ");
        sb.append("estimatedWaitTimeOnQueue=");
        sb.append(this.estimatedWaitTimeOnQueue);
        sb.append("; ");
        sb.append("estimatedProcessingTime=");
        sb.append(this.estimatedProcessingTime);
        sb.append("; ");
        sb.append("transferURL=");
        sb.append(this.transferURL);
        sb.append("; ");
        sb.append("remainingPinTime=");
        sb.append(this.remainingPinTime);
        sb.append(".");
        return sb.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.requestToken.hashCode();
        hash = 37 * hash + this.fromSURL.hashCode();
        hash = 37 * hash + this.storageSystemInfo.hashCode();
        hash = 37 * hash + this.lifeTime.hashCode();
        hash = 37 * hash + this.fileStorageType.hashCode();
        hash = 37 * hash + this.spaceToken.hashCode();
        hash = 37 * hash + this.dirOption.hashCode();
        hash = 37 * hash + this.transferProtocols.hashCode();
        hash = 37 * hash + this.fileSize.hashCode();
        hash = 37 * hash + this.status.hashCode();
        hash = 37 * hash + this.estimatedWaitTimeOnQueue.hashCode();
        hash = 37 * hash + this.estimatedProcessingTime.hashCode();
        hash = 37 * hash + this.transferURL.hashCode();
        hash = 37 * hash + this.remainingPinTime.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PtGChunkTO)) {
            return false;
        }
        PtGChunkTO cd = (PtGChunkTO)o;
        return this.requestToken.equals(cd.requestToken) && this.fromSURL.equals(cd.fromSURL) && this.storageSystemInfo.equals(cd.storageSystemInfo) && this.lifeTime.equals(cd.lifeTime) && this.fileStorageType.equals(cd.fileStorageType) && this.spaceToken.equals(cd.spaceToken) && this.dirOption.equals(cd.dirOption) && this.transferProtocols.equals(cd.transferProtocols) && this.fileSize.equals(cd.fileSize) && this.status.equals(cd.status) && this.estimatedWaitTimeOnQueue.equals(cd.estimatedWaitTimeOnQueue) && this.estimatedProcessingTime.equals(cd.estimatedProcessingTime) && this.transferURL.equals(cd.transferURL) && this.remainingPinTime.equals(cd.remainingPinTime);
    }

    public TSizeInBytes setFileSize(TSizeInBytes size) {
        if (size != null) {
            this.fileSize = size;
        }
        return null;
    }

    public void setEstimatedWaitTimeOnQueue(TLifeTimeInSeconds time) {
        if (time != null) {
            this.estimatedWaitTimeOnQueue = time;
        }
    }

    public void setEstimatedProcessingTime(TLifeTimeInSeconds time) {
        if (time != null) {
            this.estimatedProcessingTime = time;
        }
    }

    public void setTransferURL(TTURL turl) {
        if (turl != null) {
            this.transferURL = turl;
        }
    }

    public int getProgressCounter() {
        return 0;
    }
}

