/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.model;

import java.io.Serializable;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUID
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GUID.class);
    private byte[] guidValue = new byte[16];

    public GUID() {
        this.buildNewGUID();
    }

    public GUID(String guidString) {
        int pos = 0;
        int count = 0;
        while (pos < guidString.length()) {
            this.guidValue[count] = this.getByteValue(guidString.substring(pos, pos + 2));
            ++count;
            if ((pos += 2) == guidString.length() || guidString.charAt(pos) != '-') continue;
            ++pos;
        }
    }

    private byte getByteValue(String hex) {
        return (byte)Integer.parseInt(hex, 16);
    }

    private String getHexString(byte val) {
        String hexString = val < 0 ? Integer.toHexString(val + 256) : Integer.toHexString(val);
        if (hexString.length() < 2) {
            return "0" + hexString.toUpperCase();
        }
        return hexString.toUpperCase();
    }

    private void setByteValues(byte[] lg, int startPos, int count) {
        for (int i = 0; i < count; ++i) {
            this.guidValue[i + startPos] = lg[i];
        }
    }

    private void setByteValues(long lg, int startPos, int count) {
        for (int i = 0; i < count; ++i) {
            this.guidValue[i + startPos] = (byte)(lg & 0xFFL);
            lg /= 255L;
        }
    }

    private void buildNewGUID() {
        try {
            long lg = System.currentTimeMillis();
            this.setByteValues(lg, 0, 6);
            lg = this.hashCode();
            this.setByteValues(lg, 6, 2);
            InetAddress inet = InetAddress.getLocalHost();
            byte[] bytes = inet.getAddress();
            this.setByteValues(bytes, 8, 4);
            lg = (long)(Math.random() * 65535.0);
            this.setByteValues(lg, 12, 2);
            lg = (long)(Math.random() * 65535.0);
            this.setByteValues(lg, 14, 2);
        }
        catch (Exception e) {
            log.error("Error while generating a GUID", (Throwable)e);
        }
    }

    public byte[] getBytes() {
        return this.guidValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getHexString(this.guidValue[0]));
        buf.append(this.getHexString(this.guidValue[1]));
        buf.append(this.getHexString(this.guidValue[2]));
        buf.append(this.getHexString(this.guidValue[3]));
        buf.append('-');
        buf.append(this.getHexString(this.guidValue[4]));
        buf.append(this.getHexString(this.guidValue[5]));
        buf.append('-');
        buf.append(this.getHexString(this.guidValue[6]));
        buf.append(this.getHexString(this.guidValue[7]));
        buf.append('-');
        buf.append(this.getHexString(this.guidValue[8]));
        buf.append(this.getHexString(this.guidValue[9]));
        buf.append('-');
        buf.append(this.getHexString(this.guidValue[10]));
        buf.append(this.getHexString(this.guidValue[11]));
        buf.append(this.getHexString(this.guidValue[12]));
        buf.append(this.getHexString(this.guidValue[13]));
        buf.append(this.getHexString(this.guidValue[14]));
        buf.append(this.getHexString(this.guidValue[15]));
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println(new GUID());
        System.out.println(new GUID());
        System.out.println(new GUID());
        System.out.println(new GUID());
        System.out.println(new GUID());
        System.out.println(new GUID());
    }
}

