/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.impl.mysql;

import it.grid.storm.persistence.PersistenceDirector;
import it.grid.storm.persistence.dao.TapeRecallDAO;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.persistence.util.helper.TapeRecallMySQLHelper;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeRecallDAOMySql
extends TapeRecallDAO {
    private static final Logger log = LoggerFactory.getLogger(TapeRecallDAOMySql.class);
    private final TapeRecallMySQLHelper sqlHelper = new TapeRecallMySQLHelper(PersistenceDirector.getDataBase().getDbmsVendor());

    @Override
    public int getNumberInProgress() throws DataAccessException {
        return this.getNumberInProgress(null);
    }

    @Override
    public int getNumberInProgress(String voName) throws DataAccessException {
        String query = voName == null ? this.sqlHelper.getQueryNumberInProgress() : this.sqlHelper.getQueryNumberInProgress(voName);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        int status = 0;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            if (res.first()) {
                status = res.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return status;
    }

    @Override
    public int getNumberQueued() throws DataAccessException {
        return this.getNumberQueued(null);
    }

    @Override
    public int getNumberQueued(String voName) throws DataAccessException {
        String query = voName == null ? this.sqlHelper.getQueryNumberQueued() : this.sqlHelper.getQueryNumberQueued(voName);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        int status = 0;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            if (res.first()) {
                status = res.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return status;
    }

    @Override
    public int getReadyForTakeOver() throws DataAccessException {
        return this.getReadyForTakeOver(null);
    }

    @Override
    public int getReadyForTakeOver(String voName) throws DataAccessException {
        String query = voName == null ? this.sqlHelper.getQueryReadyForTakeOver() : this.sqlHelper.getQueryReadyForTakeOver(voName);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        int status = 0;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            if (res.first()) {
                status = res.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return status;
    }

    @Override
    public List<TapeRecallTO> getGroupTasks(UUID groupTaskId) throws DataAccessException {
        String query = this.sqlHelper.getQueryGetGroupTasks(groupTaskId);
        TapeRecallTO task = null;
        ArrayList<TapeRecallTO> taskList = new ArrayList<TapeRecallTO>();
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            if (!res.first()) {
                log.error("No tasks with GroupTaskId='" + groupTaskId + "'");
                throw new DataAccessException("No recall table row retrieved executing query: '" + query + "'");
            }
            do {
                task = new TapeRecallTO();
                this.setTaskInfo(task, res);
                taskList.add(task);
            } while (res.next());
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return taskList;
    }

    @Override
    public boolean existsGroupTask(UUID groupTaskId) throws DataAccessException {
        boolean response = false;
        String query = this.sqlHelper.getQueryGetGroupTasks(groupTaskId);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            response = res.first();
            if (!response) {
                log.info("No tasks found with GroupTaskId='" + groupTaskId + "'");
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return response;
    }

    @Override
    public TapeRecallTO getTask(UUID taskId, String requestToken) throws DataAccessException {
        TapeRecallTO task;
        String query = this.sqlHelper.getQueryGetTask(taskId, requestToken);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            if (!res.first()) {
                log.error("No task found for requestToken=" + requestToken + " " + " taskId=" + taskId.toString() + ". Query = " + query);
                throw new DataAccessException("No task found for requestToken=" + requestToken + " " + "taskId=" + taskId.toString() + ". Query = " + query);
            }
            task = new TapeRecallTO();
            this.setTaskInfo(task, res);
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return task;
    }

    @Override
    public boolean existsTask(UUID taskId, String requestToken) throws DataAccessException {
        boolean response;
        String query = this.sqlHelper.getQueryGetTask(taskId, requestToken);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        ResultSet res = null;
        try {
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            response = res.first();
            log.debug("Task for requestToken=" + requestToken + " " + " taskId=" + taskId.toString() + " does " + (response ? "" : "NOT ") + "exists");
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException("Error executing query: '" + query + "' " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return response;
    }

    @Override
    public UUID insertCloneTask(TapeRecallTO task, int[] statuses, UUID proposedGroupTaskId) throws DataAccessException {
        if (task.getTaskId() == null || task.getRequestToken() == null || task.getRequestToken().getValue().trim().equals("")) {
            log.error("received Task insert request with empty primary key field TaskId or RequestToken. TaskId = " + task.getTaskId() + " , request token = " + task.getRequestToken());
            throw new DataAccessException("Unable to create insert the task wth the provided UUID and request token using UUID-namebased algorithm. TaskId = " + task.getTaskId() + " , request token = " + task.getRequestToken());
        }
        Integer status = task.getStatusId();
        Connection dbConnection = this.getConnection();
        PreparedStatement prepStat = null;
        try {
            dbConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error("Error setting autocommit to false! " + e.getMessage());
            throw new DataAccessException("Error setting autocommit to false! " + e.getMessage(), e);
        }
        Object statment = null;
        ResultSet res = null;
        try {
            String query = null;
            query = statuses == null || statuses.length == 0 ? this.sqlHelper.getQueryGetGroupTaskIds(task.getTaskId()) : this.sqlHelper.getQueryGetGroupTaskIds(task.getTaskId(), statuses);
            log.debug("QUERY: " + query);
            statment = this.getStatement(dbConnection);
            res = statment.executeQuery(query);
            if (res.first()) {
                String uuidString = res.getString("groupTaskId");
                status = new Integer(res.getInt("status"));
                task.setStatusId(status);
                task.setGroupTaskId(UUID.fromString(uuidString));
                GregorianCalendar calendar = new GregorianCalendar();
                try {
                    task.forceStatusUpdateInstants(res.getDate("inProgressTime", (Calendar)calendar), res.getDate("finalStatusTime", (Calendar)calendar));
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to set status update timestamps on the coned task");
                }
            } else {
                log.debug("No task found for taskId=" + task.getTaskId() + " Creating a new group entry");
                task.setGroupTaskId(proposedGroupTaskId);
                task.setStatusId(status);
            }
            prepStat = this.sqlHelper.getQueryInsertTask(dbConnection, task);
            if (prepStat == null) {
                log.error("Cannot create the query because the task is null or empty.");
                throw new DataAccessException("Cannot create the query because the task is null or empty.");
            }
            try {
                log.debug("Query(insert-task)=" + prepStat.toString());
                prepStat.executeUpdate();
                this.commit(dbConnection);
            }
            catch (SQLException e) {
                this.rollback(dbConnection);
                throw new DataAccessException("Error executing query : " + prepStat.toString() + " ; " + e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            try {
                this.rollback(dbConnection);
                throw new DataAccessException("Error executing query : " + statment.toString() + " ; " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(new ResultSet[]{res}, new Statement[]{statment, prepStat}, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(new ResultSet[]{res}, new Statement[]{statment, prepStat}, dbConnection);
        return task.getGroupTaskId();
    }

    @Override
    public void purgeCompletedTasks(int numMaxToPurge) throws DataAccessException {
        String query = null;
        query = numMaxToPurge == -1 ? this.sqlHelper.getQueryDeleteCompletedTasks() : this.sqlHelper.getQueryDeleteCompletedTasks(numMaxToPurge);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        try {
            statment = this.getStatement(dbConnection);
            int count = statment.executeUpdate(query);
            if (count == 0) {
                log.trace("No entries have been purged from tape_recall table");
            } else {
                log.info(count + " entries have been purged from tape_recall table");
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing query: " + query, e);
        }
        finally {
            this.releaseConnection(null, statment, dbConnection);
        }
    }

    @Override
    public void setGroupTaskRetryValue(UUID groupTaskId, int value) throws DataAccessException {
        String query = this.sqlHelper.getQuerySetGroupTaskRetryValue(groupTaskId, value);
        Connection dbConnection = this.getConnection();
        Statement statment = null;
        try {
            statment = this.getStatement(dbConnection);
            statment.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing query: " + query, e);
        }
        finally {
            this.releaseConnection(null, statment, dbConnection);
        }
    }

    @Override
    public TapeRecallTO takeoverTask() throws DataAccessException {
        return this.takeoverTask(null);
    }

    @Override
    public TapeRecallTO takeoverTask(String voName) throws DataAccessException {
        List<TapeRecallTO> taskList = this.takeoverTasksWithDoubles(1, voName);
        if (taskList.isEmpty()) {
            return null;
        }
        return taskList.get(0);
    }

    @Override
    public List<TapeRecallTO> takeoverTasksWithDoubles(int numberOfTaks) throws DataAccessException {
        return this.takeoverTasksWithDoubles(numberOfTaks, null);
    }

    @Override
    public List<TapeRecallTO> takeoverTasksWithDoubles(int numberOfTaks, String voName) throws DataAccessException {
        ResultSet res;
        TapeRecallTO task;
        LinkedList<TapeRecallTO> taskList;
        Statement statment;
        Connection dbConnection;
        String query;
        block11: {
            query = voName == null ? this.sqlHelper.getQueryGetTakeoverTasksWithDoubles(numberOfTaks) : this.sqlHelper.getQueryGetTakeoverTasksWithDoubles(numberOfTaks, voName);
            dbConnection = this.getConnection();
            statment = null;
            taskList = new LinkedList<TapeRecallTO>();
            task = null;
            res = null;
            try {
                dbConnection.setAutoCommit(false);
            }
            catch (SQLException e) {
                log.error("Error setting autocommit to false! " + e.getMessage());
                throw new DataAccessException("Error setting autocommit to false! " + e.getMessage(), e);
            }
            statment = this.getStatement(dbConnection);
            log.debug("QUERY: " + query);
            res = statment.executeQuery(query);
            if (res.first()) break block11;
            log.info("No tape recall rows ready for takeover");
            LinkedList<TapeRecallTO> e = taskList;
            this.releaseConnection(res, statment, dbConnection);
            return e;
        }
        try {
            do {
                task = new TapeRecallTO();
                this.setTaskInfo(task, res);
                task.setStatus(TapeRecallStatus.IN_PROGRESS);
                taskList.add(task);
            } while (res.next());
            if (!taskList.isEmpty()) {
                try {
                    query = this.sqlHelper.getQueryUpdateTasksStatus(taskList, TapeRecallStatus.IN_PROGRESS.getStatusId(), "inProgressTime", new Date());
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to obtain the query to update task status and set status transition timestamp. IllegalArgumentException: " + e.getMessage());
                    throw new DataAccessException("Unable to obtain the query to update task status and set status transition timestamp");
                }
                statment.executeUpdate(query);
            }
            this.commit(dbConnection);
        }
        catch (SQLException e) {
            try {
                this.rollback(dbConnection);
                throw new DataAccessException("Error executing query: " + query, e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return taskList;
    }

    private void setTaskInfo(TapeRecallTO task, ResultSet res) throws DataAccessException {
        block13: {
            Timestamp insertionInstant;
            if (res == null) {
                throw new DataAccessException("Unable to build Task from NULL ResultSet");
            }
            String requestTokenStr = null;
            try {
                requestTokenStr = res.getString("requestToken");
                insertionInstant = res.getTimestamp("timeStamp");
            }
            catch (SQLException e) {
                throw new DataAccessException("Unable to retrieve RequestToken String from ResultSet. " + e);
            }
            try {
                task.setRequestToken(new TRequestToken(requestTokenStr, insertionInstant));
            }
            catch (InvalidTRequestTokenAttributesException e) {
                throw new DataAccessException("Unable to build TRequestToken from token='" + requestTokenStr + "'. " + e);
            }
            UUID groupTaskId = null;
            String groupTaskIdStr = null;
            try {
                groupTaskIdStr = res.getString("groupTaskId");
                if (groupTaskIdStr == null) break block13;
                try {
                    groupTaskId = UUID.fromString(groupTaskIdStr);
                    task.setGroupTaskId(groupTaskId);
                }
                catch (IllegalArgumentException iae) {
                    throw new DataAccessException("Unable to build UUID from GroupTaskId='" + groupTaskId + "'. " + iae);
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Unable to retrieve GroupTaskId String from ResultSet. " + e);
            }
        }
        try {
            task.setRequestType(res.getString("requestType"));
            task.setFileName(res.getString("fileName"));
            task.setPinLifetime(res.getInt("pinLifetime"));
            task.setStatusId(res.getInt("status"));
            task.setVoName(res.getString("voName"));
            task.setUserID(res.getString("userID"));
            task.setRetryAttempt(res.getInt("retryAttempt"));
            GregorianCalendar calendar = new GregorianCalendar();
            task.setDeferredRecallInstant(res.getDate("deferredStartTime", (Calendar)calendar));
            task.setInsertionInstant(res.getDate("timeStamp", (Calendar)calendar));
            try {
                task.forceStatusUpdateInstants(res.getDate("inProgressTime", (Calendar)calendar), res.getDate("finalStatusTime", (Calendar)calendar));
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to set status update timestamps on the coned task");
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Unable to getting info from ResultSet. " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setGroupTaskStatus(UUID groupTaskId, int newStatusId, Date timestamp) throws DataAccessException {
        boolean ret;
        ResultSet res;
        Statement statment;
        Connection dbConnection;
        block23: {
            String query = this.sqlHelper.getQueryGetGroupTasks(groupTaskId);
            dbConnection = this.getConnection();
            try {
                dbConnection.setAutoCommit(false);
            }
            catch (SQLException e) {
                log.error("Error setting autocommit to false! " + e.getMessage());
                throw new DataAccessException("Error setting autocommit to false! " + e.getMessage(), e);
            }
            statment = null;
            res = null;
            ret = false;
            int oldStatusId = -1;
            try {
                try {
                    log.debug("QUERY: " + query);
                    statment = this.getStatement(dbConnection);
                    res = statment.executeQuery(query);
                    if (!res.first()) {
                        log.error("No tasks with GroupTaskId='" + groupTaskId + "'");
                        throw new DataAccessException("No recall table row retrieved executing query: '" + query + "'");
                    }
                    oldStatusId = res.getInt("status");
                    do {
                        int currentStatusId;
                        if ((currentStatusId = res.getInt("status")) != oldStatusId) {
                            log.warn("The tasks with groupTaskId " + groupTaskId + " have different statuses: " + currentStatusId + " from task " + res.getString("taskId") + " differs from expected " + oldStatusId);
                            break;
                        }
                        oldStatusId = currentStatusId;
                    } while (res.next());
                }
                catch (SQLException e) {
                    log.error("Unable to retrieve groupTaskId related tasks. SQLException: " + e);
                    throw new DataAccessException("Unable to retrieve groupTaskId related tasks. ");
                }
                if (oldStatusId != newStatusId) {
                    if (!TapeRecallStatus.getRecallTaskStatus(oldStatusId).precedes(newStatusId)) {
                        log.warn("Requested the update of the status of a recall task group to status " + newStatusId + " that is precedent to the recorded status " + oldStatusId + " performing the request the same...");
                    }
                    String timestampColumn = null;
                    if (TapeRecallStatus.isFinalStatus(newStatusId)) {
                        timestampColumn = "finalStatusTime";
                    } else if (TapeRecallStatus.IN_PROGRESS.equals((Object)TapeRecallStatus.getRecallTaskStatus(newStatusId))) {
                        timestampColumn = "inProgressTime";
                    } else {
                        log.warn("unable to determine the status update timestamp column to use given the new statusId '" + newStatusId + "'");
                    }
                    if (timestampColumn != null) {
                        try {
                            query = this.sqlHelper.getQueryUpdateGroupTaskStatus(groupTaskId, newStatusId, timestampColumn, timestamp);
                        }
                        catch (IllegalArgumentException e) {
                            log.error("Unable to obtain the query to update task status and set status transition timestamp. IllegalArgumentException: " + e.getMessage());
                            throw new DataAccessException("Unable to obtain the query to update task status and set status transition timestamp");
                        }
                    } else {
                        query = this.sqlHelper.getQuerySetGroupTaskStatus(groupTaskId, newStatusId);
                    }
                    try {
                        statment = this.getStatement(dbConnection);
                        if (statment.executeUpdate(query) > 0) {
                            ret = true;
                        }
                        this.commit(dbConnection);
                        break block23;
                    }
                    catch (SQLException e) {
                        throw new DataAccessException("Error executing query: " + query, e);
                    }
                }
                log.warn("Skipping the status upadate operation, the status already stored is equal to the new one provided");
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, statment, dbConnection);
                throw throwable;
            }
        }
        this.releaseConnection(res, statment, dbConnection);
        return ret;
    }
}

