/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.dao;

import it.grid.storm.persistence.DataSourceConnectionFactory;
import it.grid.storm.persistence.PersistenceDirector;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.exceptions.PersistenceException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDAO {
    private static final Logger log = LoggerFactory.getLogger(AbstractDAO.class);
    private DataSourceConnectionFactory connFactory = PersistenceDirector.getConnectionFactory();

    protected void commit(Connection conn) {
        try {
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            log.error("Cannot commit transaction", (Throwable)e);
        }
    }

    protected Connection getConnection() throws DataAccessException {
        Connection conn = null;
        try {
            conn = this.connFactory.borrowConnection();
        }
        catch (PersistenceException ex) {
            throw new DataAccessException(ex);
        }
        return conn;
    }

    protected Statement getStatement(Connection conn) throws DataAccessException {
        Statement stat = null;
        if (conn == null) {
            throw new DataAccessException("No Connection available to create a Statement");
        }
        try {
            stat = conn.createStatement();
        }
        catch (SQLException ex1) {
            log.error("Error while creating the statement");
            throw new DataAccessException(ex1);
        }
        return stat;
    }

    protected void releaseConnection(ResultSet resultSet, Statement statement, Connection connection) throws DataAccessException {
        this.closeResultSet(resultSet);
        this.closeStatement(statement);
        this.closeConnection(connection);
    }

    protected void releaseConnection(ResultSet[] resultSets, Statement[] statements, Connection connection) throws DataAccessException {
        if (resultSets != null) {
            for (AutoCloseable autoCloseable : resultSets) {
                this.closeResultSet((ResultSet)autoCloseable);
            }
        }
        if (statements != null) {
            for (AutoCloseable autoCloseable : statements) {
                this.closeStatement((Statement)autoCloseable);
            }
        }
        this.closeConnection(connection);
    }

    private void closeResultSet(ResultSet resultSet) throws DataAccessException {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex1) {
                log.error("Error while releasing the result set");
                throw new DataAccessException(ex1);
            }
        }
    }

    private void closeStatement(Statement statement) throws DataAccessException {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex2) {
                log.error("Error while releasing the statement");
                throw new DataAccessException(ex2);
            }
        }
    }

    private void closeConnection(Connection connection) throws DataAccessException {
        if (connection != null) {
            try {
                this.connFactory.giveBackConnection(connection);
            }
            catch (PersistenceException ex3) {
                log.error("Error while releasing the connection");
                throw new DataAccessException(ex3);
            }
        }
    }

    protected void rollback(Connection conn) {
        try {
            conn.rollback();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            log.error("Cannot rollback transaction", (Throwable)e);
        }
    }
}

