/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence;

import it.grid.storm.config.Configuration;
import it.grid.storm.persistence.DAOFactory;
import it.grid.storm.persistence.DataSourceConnectionFactory;
import it.grid.storm.persistence.MemoryDAOFactory;
import it.grid.storm.persistence.MockDAOFactory;
import it.grid.storm.persistence.MySqlDAOFactory;
import it.grid.storm.persistence.exceptions.PersistenceException;
import it.grid.storm.persistence.util.db.DBConnection;
import it.grid.storm.persistence.util.db.DBConnectionPool;
import it.grid.storm.persistence.util.db.DataBaseStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceDirector {
    private static final Logger log = LoggerFactory.getLogger((String)"persistence");
    private static Configuration config = Configuration.getInstance();
    private static String dbVendor;
    private static DataBaseStrategy dbMan;
    private static DAOFactory daoFactory;
    private static DataSourceConnectionFactory connFactory;

    private static DataBaseStrategy initializeDataBase() {
        dbVendor = config.getBEPersistenceDBVendor();
        log.debug("DBMS Vendor =  " + dbVendor);
        log.debug("DBMS URL    =  " + config.getBEPersistenceDBMSUrl());
        return DataBaseStrategy.getInstance(dbVendor);
    }

    private static DAOFactory initializeFactory() {
        if (dbVendor.equalsIgnoreCase("MySql")) {
            return MySqlDAOFactory.getInstance();
        }
        if (dbVendor.equalsIgnoreCase("memory")) {
            return new MemoryDAOFactory();
        }
        if (dbVendor.equalsIgnoreCase("mock")) {
            return new MockDAOFactory();
        }
        log.error("Persistence Data Source was setted in a BAD way..");
        throw new IllegalArgumentException("Unknown datastore identifier.");
    }

    private static DataSourceConnectionFactory connectToDateSource() {
        DataSourceConnectionFactory result = null;
        StringBuffer sf = new StringBuffer();
        sf.append("Connecting to Data Source...\n");
        sf.append("  Connection String = " + dbMan.getConnectionString() + "\n");
        boolean poolMode = config.getBEPersistencePoolDB();
        int maxActive = config.getBEPersistencePoolDBMaxActive();
        int maxWait = config.getBEPersistencePoolDBMaxWait();
        sf.append("  Pool Mode = " + poolMode + "\n");
        if (poolMode) {
            sf.append("    pool Max Active = " + maxActive + "\n");
            sf.append("    pool Max Wait =  " + maxWait + "\n");
        }
        log.debug(sf.toString());
        if (poolMode) {
            log.debug("Setup Connection Pool");
            try {
                DBConnectionPool.initPool(dbMan, maxActive, maxWait);
                result = DBConnectionPool.getPoolInstance();
            }
            catch (PersistenceException ex1) {
                log.error("Connection In Pool Mode to Data Source FAIL ", (Throwable)ex1);
            }
        } else {
            log.debug("Setup Shared Connection");
            try {
                result = new DBConnection(dbMan);
            }
            catch (PersistenceException ex) {
                log.error("Connection to Data Source FAIL", (Throwable)ex);
            }
        }
        return result;
    }

    public static DAOFactory getDAOFactory() {
        return daoFactory;
    }

    public static DataBaseStrategy getDataBase() {
        return dbMan;
    }

    public static DataSourceConnectionFactory getConnectionFactory() {
        return connFactory;
    }

    public static Logger getLogger() {
        return log;
    }

    static {
        log.debug("Inizializating Persistence Director...");
        dbMan = PersistenceDirector.initializeDataBase();
        daoFactory = PersistenceDirector.initializeFactory();
        connFactory = PersistenceDirector.connectToDateSource();
    }
}

