/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.util.userinfo;

import it.grid.storm.namespace.util.userinfo.UserInfoException;
import it.grid.storm.namespace.util.userinfo.UserInfoParameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInfoCommand {
    private static final String COMMAND_ID = "id";
    private static final String COMMAND_GETENT = "getent";
    private static final Logger log = LoggerFactory.getLogger(UserInfoCommand.class);

    public static String getCommandId() {
        return COMMAND_ID;
    }

    public static String getCommandGetENT() {
        return COMMAND_GETENT;
    }

    public int retrieveGroupID(UserInfoParameters parameters) throws UserInfoException {
        int groupId = -1;
        String[] command = UserInfoCommand.buildCommandString(parameters);
        StringBuffer commandOutput = new StringBuffer();
        for (String element : command) {
            commandOutput.append(element).append(" ");
            log.debug("UserInfo Command INPUT String : " + commandOutput.toString());
        }
        String output = this.getOutput(command);
        if (output != null && output.length() > 0) {
            try {
                Long groupLong = new Long(Long.parseLong(output));
                if ((long)groupLong.intValue() == groupLong) {
                    groupId = groupLong.intValue();
                }
                log.warn("Group named '" + parameters + "' has a 32 bit GID " + groupLong + " . Long GID are not managed by LCMAPS. Ignoring the group");
            }
            catch (NumberFormatException nfe) {
                log.error("Group named '" + parameters + "' return a result different from a long. NumberFormatException : " + nfe);
                throw new UserInfoException("Group named '" + parameters + "' return a result different from a long. NumberFormatException : " + nfe);
            }
        } else {
            throw new UserInfoException("Group named '" + parameters + "' return a result different from a integer");
        }
        return groupId;
    }

    public HashMap<String, Integer> retrieveGroupDb() {
        HashMap<String, Integer> groupsDb = new HashMap<String, Integer>();
        UserInfoParameters param = new UserInfoParameters(Arrays.asList("group"));
        String[] command = UserInfoCommand.buildCommandString(param);
        String output = this.getOutput(command);
        if (output != null && output.length() > 0) {
            String[] lines = output.split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                int gid = this.getGroupId(lines[i]);
                String groupName = this.getGroupName(lines[i]);
                if (gid > -1) {
                    groupsDb.put(groupName, gid);
                    continue;
                }
                log.warn("Error while parsing the line '" + lines[i] + "' in group DB");
            }
        } else {
            throw new UserInfoException("Unable to digest group database.");
        }
        return groupsDb;
    }

    private static String[] buildCommandString(UserInfoParameters parameters) {
        String[] command = null;
        List<String> param = null;
        if (parameters != null) {
            param = parameters.getParameters();
            command = new String[1 + param.size()];
            command[0] = UserInfoCommand.getCommandGetENT();
            int cont = 1;
            Iterator<String> i$ = param.iterator();
            while (i$.hasNext()) {
                String element;
                String p = element = i$.next();
                command[cont++] = p;
            }
        } else {
            command = new String[]{UserInfoCommand.getCommandGetENT()};
        }
        return command;
    }

    private String getOutput(String[] command) throws UserInfoException {
        String result = "";
        try {
            Process child = Runtime.getRuntime().exec(command);
            log.debug("Command executed: " + ArrayUtils.toString((Object)command));
            BufferedReader stdInput = null;
            BufferedReader stdError = null;
            if (child != null) {
                stdInput = new BufferedReader(new InputStreamReader(child.getInputStream()));
                stdError = new BufferedReader(new InputStreamReader(child.getErrorStream()));
            }
            if (stdInput != null) {
                String errLine;
                String line;
                int row = 0;
                log.trace("UserInfo Command Output :");
                while ((line = stdInput.readLine()) != null) {
                    log.trace(row + ": " + line);
                    boolean lineOk = this.processOutput(row, line);
                    if (lineOk) {
                        result = result + line + "\n";
                    }
                    ++row;
                }
                if (stdError != null && (errLine = stdError.readLine()) != null) {
                    log.warn("User Info Command Output contains an ERROR message " + errLine);
                    throw new UserInfoException(errLine);
                }
            }
        }
        catch (IOException ex) {
            log.error("getUserInfo (id) I/O Exception: " + ex);
            throw new UserInfoException(ex);
        }
        return result;
    }

    private boolean processOutput(int row, String line) {
        boolean result = false;
        if (row >= 0) {
            result = true;
        }
        return result;
    }

    private String getGroupName(String line) {
        String groupName = null;
        String[] fields = this.getElements(line);
        if (fields != null && fields.length > 1 && fields[0] != null) {
            log.trace("field[0], GroupName ='" + fields[0] + "'");
            groupName = fields[0];
        }
        return groupName;
    }

    private int getGroupId(String line) throws UserInfoException {
        int gidInt = -1;
        String[] fields = this.getElements(line);
        if (fields != null && fields.length > 2 && fields[2] != null) {
            log.trace("field[2], GID ='" + fields[2] + "'");
            try {
                Long groupLong = new Long(Long.parseLong(fields[2]));
                if ((long)groupLong.intValue() == groupLong) {
                    gidInt = groupLong.intValue();
                } else {
                    log.warn("Group named '" + fields[2] + "' has a 32 bit GID " + groupLong + " . Long GID are not managed by LCMAPS. Ignoring the group");
                }
            }
            catch (NumberFormatException nfe) {
                log.error("Group named '" + fields[2] + "' return a result different from a long. NumberFormatException : " + nfe);
                throw new UserInfoException("Group named '" + fields[2] + "' return a result different from a long. NumberFormatException : " + nfe);
            }
        }
        return gidInt;
    }

    private String[] getElements(String line) {
        String patternStr = ":";
        String[] fields = null;
        if (line != null) {
            log.trace("LINE = " + line);
            fields = line.split(patternStr);
        }
        return fields;
    }
}

