/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.util.userinfo;

import it.grid.storm.namespace.util.userinfo.UserInfoExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalGroups {
    private static final Logger log = LoggerFactory.getLogger(LocalGroups.class);
    private static final String UNKNOWN_GROUP = "unknown";
    private ConcurrentHashMap<String, Integer> nameIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, String> idNameMap = new ConcurrentHashMap();
    private static final LocalGroups instance = new LocalGroups();
    private long parsingInstant = 0L;
    private static final long minimumLifetime = 300000L;

    private LocalGroups() {
        this.init();
    }

    private synchronized void init() {
        this.nameIdMap.clear();
        this.idNameMap.clear();
        this.nameIdMap.putAll(UserInfoExecutor.digestGroupDatabase());
        for (Map.Entry<String, Integer> nameIdEntry : this.nameIdMap.entrySet()) {
            this.idNameMap.put(nameIdEntry.getValue(), nameIdEntry.getKey());
        }
        this.parsingInstant = System.currentTimeMillis();
    }

    public static synchronized LocalGroups getInstance() {
        if (instance.computeParsedAge() > 300000L) {
            instance.init();
        }
        return instance;
    }

    private long computeParsedAge() {
        return System.currentTimeMillis() - this.parsingInstant;
    }

    public boolean isGroupDefined(String groupName) {
        boolean result = this.nameIdMap.keySet().contains(groupName);
        if (!result) {
            try {
                Integer grupId = Integer.valueOf(groupName);
                if (grupId != null) {
                    result = this.idNameMap.containsKey(grupId);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getGroupId(String groupName) {
        int result = -1;
        if (this.isGroupDefined(groupName)) {
            result = this.nameIdMap.get(groupName);
        }
        return result;
    }

    public String getGroupName(int groupId) {
        String result = UNKNOWN_GROUP;
        if (this.idNameMap.containsKey(groupId)) {
            result = this.idNameMap.get(groupId);
        } else {
            log.warn("Unable to find a group with GID='" + groupId + "'");
        }
        return result;
    }
}

