/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.remote.resource;

import com.sun.jersey.server.impl.ResponseBuilderImpl;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.MappingRule;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/configuration/1.0")
public class VirtualFSResourceCompat_1_0 {
    private static final Logger log = LoggerFactory.getLogger(VirtualFSResourceCompat_1_0.class);

    @GET
    @Path(value="/StorageAreaList")
    @Produces(value={"text/plain"})
    public String listVFS() throws WebApplicationException {
        log.info("Serving VFS resource listing");
        String vfsListString = "";
        Collection<VirtualFSInterface> vfsCollection = null;
        try {
            vfsCollection = NamespaceDirector.getNamespace().getAllDefinedVFS();
        }
        catch (NamespaceException e) {
            log.error("Unable to retrieve virtual file system list. NamespaceException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.INTERNAL_SERVER_ERROR);
            responseBuilder.entity((Object)"Unable to retrieve virtual file systems");
            throw new WebApplicationException(responseBuilder.build());
        }
        for (VirtualFSInterface vfs : vfsCollection) {
            if (!vfsListString.equals("")) {
                vfsListString = vfsListString + ':';
            }
            try {
                vfsListString = vfsListString + this.encodeVFS(vfs);
            }
            catch (NamespaceException e) {
                log.error("Unable to encode the virtual file system. NamespaceException : " + e.getMessage());
                ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
                responseBuilder.status(Response.Status.INTERNAL_SERVER_ERROR);
                responseBuilder.entity((Object)"Unable to encode the virtual file system");
                throw new WebApplicationException(responseBuilder.build());
            }
        }
        return vfsListString;
    }

    private String encodeVFS(VirtualFSInterface vfs) throws NamespaceException {
        String vfsEncoded = "name=" + vfs.getAliasName();
        vfsEncoded = vfsEncoded + '&';
        vfsEncoded = vfsEncoded + "root=" + vfs.getRootPath();
        vfsEncoded = vfsEncoded + '&';
        List<MappingRule> mappingRules = vfs.getMappingRules();
        vfsEncoded = vfsEncoded + "stfnRoot=";
        for (int i = 0; i < mappingRules.size(); ++i) {
            MappingRule mappingRule = mappingRules.get(i);
            if (i > 0) {
                vfsEncoded = vfsEncoded + ';';
            }
            vfsEncoded = vfsEncoded + mappingRule.getStFNRoot();
        }
        return vfsEncoded;
    }
}

