/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.naming;

import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.naming.NamingConst;
import it.grid.storm.namespace.naming.SRMURL;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;

public class SURL
extends SRMURL {
    private static Logger log = NamespaceDirector.getLogger();
    private static ArrayList<String> schemes = new ArrayList();
    public final boolean directory;

    private SURL(String hostName, int port, String serviceEndpoint, String queryString) {
        super(Protocol.SRM, hostName, port, serviceEndpoint, queryString);
        this.directory = this.checkDirectory(queryString);
    }

    private SURL(String hostName, int port, String stfn) {
        super(Protocol.SRM, hostName, port, stfn);
        this.directory = this.checkDirectory(stfn);
    }

    public SURL(String stfn) {
        super(Protocol.SRM, NamingConst.getServiceDefaultHost(), NamingConst.getServicePort(), stfn);
        this.directory = this.checkDirectory(stfn);
    }

    public static SURL makeSURLfromString(String surlString) throws NamespaceException {
        SURL result = null;
        URI uri = null;
        try {
            uri = URI.create(surlString);
            uri = uri.normalize();
        }
        catch (IllegalArgumentException uriEx) {
            throw new NamespaceException("SURL_String :'" + surlString + "' is INVALID. Reason: URI Except: " + uriEx.getMessage());
        }
        catch (NullPointerException npe) {
            throw new NamespaceException("SURL_String :'" + surlString + "' is INVALID. Reason: URI Except (null SURL): " + npe.getMessage());
        }
        String scheme = uri.getScheme();
        if (!schemes.contains(scheme)) {
            throw new NamespaceException("SURL_String :'" + surlString + "' is INVALID. Reason: unknown scheme '" + scheme + "'");
        }
        String host = uri.getHost();
        if (host == null) {
            throw new NamespaceException("SURL_String :'" + surlString + "' is INVALID. Reason: malformed host!");
        }
        int port = uri.getPort();
        String query = uri.getQuery();
        if (query == null || query.trim().equals("")) {
            String stfn = uri.getPath();
            result = new SURL(host, port, stfn);
        } else {
            log.debug(" !! SURL ('" + surlString + "') in a query form (query:'" + query + "') !!");
            String service = uri.getPath();
            log.debug(" Service endpoint : " + service);
            if (SURL.checkQuery(query)) {
                log.debug(" Query is in a valid form.");
                String stfn = SURL.extractStFNfromQuery(query);
                result = new SURL(host, port, service, stfn);
            } else {
                log.warn("SURL_String :'" + surlString + "' is not VALID! (query is in invalid form)");
                throw new NamespaceException("SURL_String :'" + surlString + "' is not VALID within the Query!");
            }
        }
        return result;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    private boolean checkDirectory(String path) {
        return path != null && path.endsWith("/");
    }

    private static boolean checkQuery(String query) {
        if (query == null) {
            log.error("Received a null query to check!");
            return false;
        }
        return query.startsWith(NamingConst.getServiceSFNQueryPrefix() + "=");
    }

    private static String extractStFNfromQuery(String query) {
        String stfn = "";
        if (query == null) {
            return stfn;
        }
        int len = query.length();
        if (len < 4) {
            return stfn;
        }
        stfn = query.substring(4);
        return stfn;
    }

    public String getPathQuery() {
        StringBuffer sb = new StringBuffer(250);
        sb.append(this.getPath());
        if (this.isQueriedFormSURL()) {
            sb.append("?");
            sb.append(NamingConst.getServiceSFNQueryPrefix());
            sb.append("=");
            sb.append(this.getQueryString());
        }
        return sb.toString();
    }

    public String getSURLAsURIString() {
        String uriString = this.transfProtocol.getProtocol().getSchema() + "://" + this.transfProtocol.getAuthority().getServiceHostname();
        if (this.transfProtocol.getAuthority().getServicePort() >= 0) {
            uriString = uriString + ":" + this.transfProtocol.getAuthority().getServicePort();
        }
        uriString = this.isNormalFormSURL() ? uriString + this.path : uriString + this.path + this.getPathQuery() + this.queryString;
        return uriString;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.transfProtocol.toString());
        buffer.append(this.getPathQuery());
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += 37 * schemes.hashCode() + 63 * (this.directory ? 1 : 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SURL)) {
            return false;
        }
        SURL other = (SURL)obj;
        return this.directory == other.directory;
    }

    static {
        schemes.add("srm");
    }
}

