/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.naming;

import it.grid.storm.namespace.model.Authority;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.model.TransportProtocol;
import it.grid.storm.namespace.naming.NamingConst;

public abstract class SRMURL {
    protected TransportProtocol transfProtocol;
    protected SRMURLType surlType = null;
    protected String path;
    protected String queryString = null;
    protected int local = -1;
    protected boolean localSURL = false;

    public SRMURL(Protocol protocol, String hostname, int port, String servicePath, String queryString) {
        Authority authority = new Authority(hostname, port);
        this.transfProtocol = new TransportProtocol(protocol, authority);
        this.path = this.makeInAbsoluteForm(servicePath);
        if (queryString != null) {
            this.queryString = this.makeInAbsoluteForm(queryString);
        }
    }

    public SRMURL(Protocol protocol, String hostname, int port, String stfn) {
        Authority autority = new Authority(hostname, port);
        this.transfProtocol = new TransportProtocol(protocol, autority);
        this.path = this.makeInAbsoluteForm(stfn);
    }

    private String makeInAbsoluteForm(String path) {
        StringBuffer absolutePath = new StringBuffer();
        if (path == null || path.length() == 0) {
            absolutePath.append("/");
        } else {
            if (path.charAt(0) != '/') {
                absolutePath.insert(0, "/");
            }
            absolutePath.append(path);
        }
        return absolutePath.toString();
    }

    public void setServiceHostName(String hostname) {
        this.transfProtocol.setAuthority(new Authority(hostname));
    }

    public String getServiceHostname() {
        return this.transfProtocol.getAuthority().getServiceHostname();
    }

    public void setServiceHostPort(int port) {
        this.transfProtocol.getAuthority().setServicePort(port);
    }

    public int getServiceHostPort() {
        return this.transfProtocol.getAuthority().getServicePort();
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getTransportPrefix() {
        return this.transfProtocol.toString();
    }

    public String getSURLType() {
        if (this.surlType == null) {
            this.surlType = this.computeType();
        }
        return this.surlType.toString();
    }

    public boolean isLocal() {
        if (this.local == -1) {
            this.localSURL = this.getServiceHostname().equals(NamingConst.getServiceDefaultHost());
            this.local = 1;
        }
        return this.localSURL;
    }

    public boolean isQueriedFormSURL() {
        if (this.surlType == null) {
            this.surlType = this.computeType();
        }
        return this.surlType.equals(SRMURLType.QUERIED);
    }

    public boolean isNormalFormSURL() {
        return !this.isQueriedFormSURL();
    }

    private SRMURLType computeType() {
        if (this.getQueryString() != null) {
            return SRMURLType.QUERIED;
        }
        return SRMURLType.SIMPLE;
    }

    public String getServiceEndPoint() {
        if (this.isQueriedFormSURL()) {
            return this.getPath();
        }
        return "";
    }

    public String getStFN() {
        if (this.isQueriedFormSURL()) {
            return this.getQueryString();
        }
        return this.getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.local;
        result = 31 * result + (this.localSURL ? 1231 : 1237);
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.queryString == null ? 0 : this.queryString.hashCode());
        result = 31 * result + (this.surlType == null ? 0 : this.surlType.hashCode());
        result = 31 * result + (this.transfProtocol == null ? 0 : this.transfProtocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SRMURL)) {
            return false;
        }
        SRMURL other = (SRMURL)obj;
        if (this.local != other.local) {
            return false;
        }
        if (this.localSURL != other.localSURL) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.queryString == null ? other.queryString != null : !this.queryString.equals(other.queryString)) {
            return false;
        }
        if (this.surlType == null ? other.surlType != null : !this.surlType.equals(other.surlType)) {
            return false;
        }
        return !(this.transfProtocol == null ? other.transfProtocol != null : !this.transfProtocol.equals(other.transfProtocol));
    }

    protected static class SRMURLType {
        private String type;
        public static final SRMURLType QUERIED = new SRMURLType("query_form");
        public static final SRMURLType SIMPLE = new SRMURLType("simple_form");

        private SRMURLType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SRMURLType)) {
                return false;
            }
            SRMURLType other = (SRMURLType)obj;
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public int hashCode() {
            int prime = 31;
            int result = 17;
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

