/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.naming;

import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceUtil {
    private static final Logger log = LoggerFactory.getLogger(NamespaceUtil.class);

    private NamespaceUtil() {
    }

    public static int computeDistanceFromPath(String path1, String path2) {
        return new Path(path1).distance(new Path(path2));
    }

    public static Collection<String> getPathElement(String path) {
        return new Path(path).getPathElements();
    }

    public static String getFileName(String stfn) {
        if (stfn != null) {
            if (stfn.endsWith("/")) {
                return "";
            }
            Path path = new Path(stfn);
            int length = path.getLength();
            if (length > 0) {
                PathElement elem = path.getElementAt(length - 1);
                return elem.toString();
            }
            return "";
        }
        return "";
    }

    public static Collection<VirtualFSInterface> getResidentVFS(String mountPointPath) {
        Collection<Object> vfsSet = Collections.emptySet();
        try {
            vfsSet = NamespaceDirector.getNamespace().getAllDefinedVFS();
        }
        catch (NamespaceException e) {
            log.error("Unable to add NamespaceFSAssociationCheck, a NamespaceException occurred during vfsSet retriving : " + e.getMessage());
            return vfsSet;
        }
        for (VirtualFSInterface virtualFSInterface : vfsSet) {
            try {
                String vfsRootPath = virtualFSInterface.getRootPath();
                boolean enclosed = NamespaceUtil.isEnclosed(mountPointPath, vfsRootPath);
                if (enclosed) continue;
                vfsSet.remove(virtualFSInterface);
            }
            catch (NamespaceException e) {
                log.debug("Skipped vfs while retrieving resident VFS");
            }
        }
        return vfsSet;
    }

    public static String consumeFileName(String file) {
        if (file != null) {
            if (file.endsWith("/")) {
                return file;
            }
            Path path = new Path(file);
            int length = path.getLength();
            if (length > 1) {
                return path.getSubPath(length - 1).getPath() + "/";
            }
            return Path.PATH_SEPARATOR;
        }
        return Path.PATH_SEPARATOR;
    }

    public static String getStFNPath(String stfn) {
        return NamespaceUtil.consumeFileName(stfn);
    }

    public static String consumeElement(String stfnPath) {
        Path path = new Path(stfnPath);
        int length = path.getLength();
        if (length > 1) {
            return path.getSubPath(length - 1).getPath() + "/";
        }
        return "";
    }

    public static String extractRelativePath(String root, String absolute) {
        if (absolute.startsWith(root)) {
            Path rootPath = new Path(root);
            int rootLength = rootPath.getLength();
            Path absPath = new Path(absolute);
            ArrayList<PathElement> elem = new ArrayList<PathElement>();
            for (int i = 0; i < absPath.getLength(); ++i) {
                if (i < rootLength) continue;
                elem.add(absPath.getElementAt(i));
            }
            Path result = new Path(elem, false);
            return result.getPath();
        }
        return absolute;
    }

    public static boolean isEnclosed(String root, String wrapperCandidate) {
        boolean result = false;
        Path rootPath = new Path(root);
        Path wrapperPath = new Path(wrapperCandidate);
        result = rootPath.isEnclosed(wrapperPath);
        return result;
    }

    private static class Path {
        private ArrayList<PathElement> path;
        private static String PATH_SEPARATOR = "/";
        public static final String[] EMPTY_STRING_ARRAY = new String[0];
        public boolean directory;
        public boolean absolutePath;

        public Path() {
            this.path = new ArrayList();
            this.directory = false;
            this.absolutePath = true;
        }

        public Path(ArrayList<PathElement> path, boolean absolutePath) {
            this.path = path;
            this.directory = false;
            this.absolutePath = absolutePath;
        }

        public Path(String path) {
            this.absolutePath = path.startsWith(PATH_SEPARATOR);
            this.directory = path.endsWith(PATH_SEPARATOR);
            String[] pathElements = this.factorizePath(path);
            if (pathElements != null) {
                this.path = new ArrayList(pathElements.length);
                for (String pathElement : pathElements) {
                    this.addPathElement(new PathElement(pathElement));
                }
            }
        }

        public String[] factorizePath(String path) {
            return this.toStringArray(path, PATH_SEPARATOR);
        }

        public Collection<String> getPathElements() {
            ArrayList<String> result = new ArrayList<String>(this.getLength());
            for (PathElement p : this.path) {
                result.add(p.toString());
            }
            return result;
        }

        private String[] toStringArray(String value, String delim) {
            if (value != null) {
                return this.split(delim, value);
            }
            return EMPTY_STRING_ARRAY;
        }

        private String[] split(String seperators, String list) {
            return this.split(seperators, list, false);
        }

        private String[] split(String seperators, String list, boolean include) {
            StringTokenizer tokens = new StringTokenizer(list, seperators, include);
            String[] result = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                result[i++] = tokens.nextToken();
            }
            return result;
        }

        public String getPath() {
            StringBuffer buf = new StringBuffer();
            if (this.absolutePath) {
                buf.append(PATH_SEPARATOR);
            }
            Iterator<PathElement> iter = this.path.iterator();
            while (iter.hasNext()) {
                PathElement item = iter.next();
                buf.append(item.getPathChunk());
                if (!iter.hasNext()) continue;
                buf.append(PATH_SEPARATOR);
            }
            if (this.directory) {
                buf.append(PATH_SEPARATOR);
            }
            return buf.toString();
        }

        public int getLength() {
            if (this.path != null) {
                return this.path.size();
            }
            return 0;
        }

        public PathElement getElementAt(int position) {
            if (position < this.getLength()) {
                return this.path.get(position);
            }
            return null;
        }

        public boolean equals(Object obj) {
            boolean result = true;
            if (!(obj instanceof Path)) {
                result = false;
            } else {
                Path other = (Path)obj;
                if (other.getLength() != this.getLength()) {
                    result = false;
                } else {
                    int size = this.getLength();
                    for (int i = 0; i < size; ++i) {
                        if (this.getElementAt(i).equals(other.getElementAt(i))) continue;
                        result = false;
                        break;
                    }
                }
            }
            return result;
        }

        public void addPathElement(PathElement pathChunk) {
            this.path.add(pathChunk);
        }

        public Path getSubPath(int elements) {
            Path result = new Path();
            for (int i = 0; i < elements; ++i) {
                result.addPathElement(this.getElementAt(i));
            }
            return result;
        }

        public boolean isEnclosed(Path wrapperCandidate) {
            boolean result = false;
            if (this.getLength() > wrapperCandidate.getLength()) {
                result = false;
            } else {
                Path other = wrapperCandidate.getSubPath(this.getLength());
                result = other.equals(this);
            }
            return result;
        }

        public int distance(Path other) {
            Path b;
            Path a;
            int result = -1;
            if (this.getLength() > other.getLength()) {
                a = this;
                b = other;
            } else {
                a = other;
                b = this;
            }
            result = b.isEnclosed(a) ? a.getLength() - b.getLength() : a.getLength() + b.getLength();
            return result;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            for (int i = 0; i < this.getLength(); ++i) {
                buf.append(" ");
                buf.append(this.getElementAt(i).getPathChunk());
            }
            buf.append(" ]");
            return buf.toString();
        }
    }

    static class PathElement {
        private final String pathChunk;

        public PathElement(String path) {
            this.pathChunk = path;
        }

        public String getPathChunk() {
            return this.pathChunk;
        }

        public int hashCode() {
            return this.pathChunk.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result = true;
            if (!(obj instanceof PathElement)) {
                result = false;
            } else {
                PathElement other = (PathElement)obj;
                result = this.getPathChunk().equals(other.getPathChunk());
            }
            return result;
        }

        public String toString() {
            return this.pathChunk;
        }
    }
}

