/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.balancer.BalancingStrategy;
import it.grid.storm.balancer.Node;
import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.GUID;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.Filesystem;
import it.grid.storm.filesystem.GPFSSpaceSystem;
import it.grid.storm.filesystem.InvalidSpaceAttributesException;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.MockSpaceSystem;
import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.filesystem.Space;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.filesystem.swig.genericfs;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.DefaultValuesInterface;
import it.grid.storm.namespace.ExpiredSpaceTokenException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.PropertyInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.StoRIImpl;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.ApproachableRule;
import it.grid.storm.namespace.model.MappingRule;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.model.SAAuthzType;
import it.grid.storm.namespace.model.StoRIType;
import it.grid.storm.namespace.model.StorageClassType;
import it.grid.storm.namespace.naming.NamespaceUtil;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TSpaceType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;

public class VirtualFS
implements VirtualFSInterface {
    private final Logger log = NamespaceDirector.getLogger();
    String aliasName = null;
    String type = null;
    StoRI storiRoot = null;
    String spaceTokenDescription = null;
    String rootPath = null;
    Class fsDriver = null;
    Class spaceSystemDriver = null;
    DefaultValuesInterface defValue = null;
    CapabilityInterface capabilities = null;
    PropertyInterface properties = null;
    Hashtable protocols = null;
    genericfs genericFS = null;
    SpaceSystem spaceSystem = null;
    Filesystem fsWrapper = null;
    List<MappingRule> mappingRules = new ArrayList<MappingRule>();
    List<ApproachableRule> approachableRules = new ArrayList<ApproachableRule>();
    Configuration config;
    StorageClassType storageClass = null;
    TSpaceToken spaceToken;
    SAAuthzType saAuthzType = SAAuthzType.UNKNOWN;
    String saAuthzSourceName = null;
    public long creationTime = System.currentTimeMillis();
    public boolean testingMode = false;

    public VirtualFS(boolean testingMode) {
        this.testingMode = testingMode;
    }

    public VirtualFS(String aliasName, String type, String rootPath, String spaceTokenDescription, StorageClassType storageClass, Class fsDriver, Class spaceDriver, PropertyInterface properties, DefaultValuesInterface defaultValue, CapabilityInterface capabilities) throws NamespaceException {
        this.aliasName = aliasName;
        this.type = type;
        this.rootPath = this.buildRootPath(rootPath);
        this.spaceTokenDescription = spaceTokenDescription;
        this.storageClass = storageClass;
        this.fsDriver = fsDriver;
        this.spaceSystemDriver = spaceDriver;
        this.defValue = defaultValue;
        this.capabilities = capabilities;
        this.properties = properties;
        this.buildStoRIRoot(rootPath);
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public void setFSType(String type) {
        this.type = type;
    }

    public void setFSDriver(Class fsDriver) throws NamespaceException {
        this.fsDriver = fsDriver;
        this.genericFS = this.testingMode ? null : this.makeFSInstance();
        this.fsWrapper = new Filesystem(this.getFSDriverInstance());
    }

    public void setSpaceTokenDescription(String spaceTokenDescription) {
        this.spaceTokenDescription = spaceTokenDescription;
    }

    public void setStorageClassType(StorageClassType storageClass) {
        this.storageClass = storageClass;
    }

    public void setProperties(PropertyInterface prop) {
        this.properties = prop;
    }

    public void setSpaceSystemDriver(Class spaceDriver) {
        this.spaceSystemDriver = spaceDriver;
    }

    public void setDefaultValues(DefaultValuesInterface defValue) {
        this.defValue = defValue;
    }

    public void setCapabilities(CapabilityInterface cap) {
        this.capabilities = cap;
    }

    public void setRoot(String rootPath) throws NamespaceException {
        this.rootPath = this.buildRootPath(rootPath);
        this.buildStoRIRoot(rootPath);
    }

    public void addMappingRule(MappingRule mappingRule) {
        this.mappingRules.add(mappingRule);
    }

    public void addApproachableRule(ApproachableRule rule) {
        this.approachableRules.add(rule);
    }

    public void setSpaceToken(TSpaceToken spaceToken) {
        this.spaceToken = spaceToken;
    }

    public void setSAAuthzType(SAAuthzType saAuthzType) {
        this.saAuthzType = saAuthzType;
    }

    public void setSAAuthzSource(String authzSourceName) {
        this.saAuthzSourceName = authzSourceName;
    }

    private String buildRootPath(String rootPath) throws NamespaceException {
        URI rootPathUri;
        try {
            rootPathUri = new URI(rootPath);
        }
        catch (URISyntaxException e) {
            throw new NamespaceException("Unable to set rootPath. Invalid string. URISyntaxException: " + e.getMessage());
        }
        return rootPathUri.normalize().toString();
    }

    private void buildStoRIRoot(String rootPath) throws NamespaceException {
    }

    @Override
    public String getFSType() throws NamespaceException {
        return this.type;
    }

    @Override
    public String getSpaceTokenDescription() throws NamespaceException {
        return this.spaceTokenDescription;
    }

    @Override
    public StorageClassType getStorageClassType() {
        return this.storageClass;
    }

    @Override
    public PropertyInterface getProperties() {
        return this.properties;
    }

    @Override
    public TSizeInBytes getUsedOnlineSpace() throws NamespaceException {
        TSizeInBytes result = TSizeInBytes.makeEmpty();
        return result;
    }

    @Override
    public TSizeInBytes getAvailableOnlineSpace() throws NamespaceException {
        TSizeInBytes result = TSizeInBytes.makeEmpty();
        return result;
    }

    @Override
    public TSizeInBytes getUsedNearlineSpace() throws NamespaceException {
        TSizeInBytes result = TSizeInBytes.makeEmpty();
        return result;
    }

    @Override
    public TSizeInBytes getAvailableNearlineSpace() throws NamespaceException {
        return this.properties.getTotalNearlineSize();
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public boolean isHttpWorldReadable() {
        for (ApproachableRule rule : this.approachableRules) {
            if (!rule.getAnonymousHttpReadAccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class getFSDriver() throws NamespaceException {
        return this.fsDriver;
    }

    @Override
    public genericfs getFSDriverInstance() throws NamespaceException {
        if (this.genericFS == null && !this.testingMode) {
            this.genericFS = this.makeFSInstance();
        }
        return this.genericFS;
    }

    @Override
    public List<MappingRule> getMappingRules() throws NamespaceException {
        if (this.mappingRules.isEmpty()) {
            throw new NamespaceException("No one MAPPING RULES bound with this VFS (" + this.aliasName + "). ");
        }
        return this.mappingRules;
    }

    @Override
    public List<ApproachableRule> getApproachableRules() throws NamespaceException {
        if (this.approachableRules.isEmpty()) {
            throw new NamespaceException("No one APPROACHABLE RULES bound with this VFS (" + this.aliasName + "). ");
        }
        return this.approachableRules;
    }

    private genericfs makeFSInstance() throws NamespaceException {
        genericfs fs = null;
        if (this.fsDriver == null) {
            throw new NamespaceException("Cannot build FS Driver istance without a valid Driver Class!");
        }
        Class[] fsArgumentsClass = new Class[]{String.class};
        Object[] fsArguments = new Object[]{this.rootPath};
        Constructor fsConstructor = null;
        try {
            fsConstructor = this.fsDriver.getConstructor(fsArgumentsClass);
        }
        catch (SecurityException ex) {
            this.log.error("Unable to retrieve the FS Driver Constructor. Security problem.", (Throwable)ex);
            throw new NamespaceException("Unable to retrieve the FS Driver Constructor. Security problem.", ex);
        }
        catch (NoSuchMethodException ex) {
            this.log.error("Unable to retrieve the FS Driver Constructor. Security problem.", (Throwable)ex);
            throw new NamespaceException("Unable to retrieve the FS Driver Constructor. No such constructor.", ex);
        }
        try {
            fs = (genericfs)fsConstructor.newInstance(fsArguments);
        }
        catch (InvocationTargetException ex1) {
            this.log.error("Unable to instantiate the FS Driver. Wrong target.", (Throwable)ex1);
            this.log.debug("VFS: Ex message: " + ex1.getMessage());
            this.log.debug("VFS Ex Stack: ");
            ex1.printStackTrace();
            throw new NamespaceException("Unable to instantiate the FS Driver. ", ex1);
        }
        catch (IllegalArgumentException ex1) {
            this.log.error("Unable to instantiate the FS Driver. Using wrong argument.", (Throwable)ex1);
            throw new NamespaceException("Unable to instantiate the FS Driver. Using wrong argument.", ex1);
        }
        catch (IllegalAccessException ex1) {
            this.log.error("Unable to instantiate the FS Driver. Illegal Access.", (Throwable)ex1);
            throw new NamespaceException("Unable to instantiate the FS Driver. Illegal Access.", ex1);
        }
        catch (InstantiationException ex1) {
            this.log.error("Unable to instantiate the FS Driver. Generic problem..", (Throwable)ex1);
            throw new NamespaceException("Unable to instantiate the FS Driver. Generic problem..", ex1);
        }
        return fs;
    }

    @Override
    public Filesystem getFilesystem() throws NamespaceException {
        if (this.fsWrapper == null) {
            this.fsWrapper = new Filesystem(this.getFSDriverInstance());
        }
        return this.fsWrapper;
    }

    @Override
    public Class getSpaceSystemDriver() throws NamespaceException {
        return this.spaceSystemDriver;
    }

    @Override
    public SpaceSystem getSpaceSystemDriverInstance() throws NamespaceException {
        if (this.spaceSystem == null && !this.testingMode) {
            this.spaceSystem = this.makeSpaceSystemInstance();
        }
        return this.spaceSystem;
    }

    private SpaceSystem makeSpaceSystemInstance() throws NamespaceException {
        SpaceSystem ss = null;
        if (this.spaceSystemDriver == null) {
            throw new NamespaceException("Cannot build Space Driver istance without a valid Driver Class!");
        }
        if (this.spaceSystemDriver.getName().equals(GPFSSpaceSystem.class.getName()) || this.spaceSystemDriver.getName().equals(MockSpaceSystem.class.getName())) {
            Class[] ssArgumentsClass = new Class[]{String.class};
            Object[] ssArguments = new Object[]{this.rootPath};
            Constructor ssConstructor = null;
            try {
                ssConstructor = this.spaceSystemDriver.getConstructor(ssArgumentsClass);
            }
            catch (SecurityException ex) {
                this.log.error("Unable to retrieve the FS Driver Constructor. Security problem.", (Throwable)ex);
                throw new NamespaceException("Unable to retrieve the FS Driver Constructor. Security problem.", ex);
            }
            catch (NoSuchMethodException ex) {
                this.log.error("Unable to retrieve the FS Driver Constructor. Security problem.", (Throwable)ex);
                throw new NamespaceException("Unable to retrieve the FS Driver Constructor. No such constructor.", ex);
            }
            try {
                ss = (SpaceSystem)ssConstructor.newInstance(ssArguments);
            }
            catch (InvocationTargetException ex1) {
                this.log.error("Unable to instantiate the SpaceSystem Driver. Wrong target.", (Throwable)ex1);
                throw new NamespaceException("Unable to instantiate the FS Driver. ", ex1);
            }
            catch (IllegalArgumentException ex1) {
                this.log.error("Unable to instantiate the SpaceSystem Driver. Using wrong argument.", (Throwable)ex1);
                throw new NamespaceException("Unable to instantiate the FS Driver. Using wrong argument.", ex1);
            }
            catch (IllegalAccessException ex1) {
                this.log.error("Unable to instantiate the SpaceSystem Driver. Illegal Access.", (Throwable)ex1);
                throw new NamespaceException("Unable to instantiate the FS Driver. Illegal Access.", ex1);
            }
            catch (InstantiationException ex1) {
                this.log.error("Unable to instantiate the SpaceSystem Driver. Generic problem..", (Throwable)ex1);
                throw new NamespaceException("Unable to instantiate the FS Driver. Generic problem..", ex1);
            }
        }
        this.log.error("None Space System Driver built");
        ss = null;
        return ss;
    }

    @Override
    public DefaultValuesInterface getDefaultValues() {
        return this.defValue;
    }

    @Override
    public CapabilityInterface getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String getRootPath() throws NamespaceException {
        return this.rootPath;
    }

    @Override
    public StoRI getRoot() throws NamespaceException {
        return this.storiRoot;
    }

    @Override
    public boolean isApproachableByUser(GridUserInterface user) {
        for (ApproachableRule approachableRule : this.approachableRules) {
            if (!approachableRule.match(user)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isApproachableByAnonymous() {
        for (ApproachableRule approachableRule : this.approachableRules) {
            if (!approachableRule.isAdmitAll()) continue;
            return true;
        }
        return false;
    }

    @Override
    public StoRI createFile(String relativePath) throws NamespaceException {
        StoRIType type = StoRIType.UNKNOWN;
        StoRIImpl stori = new StoRIImpl((VirtualFSInterface)this, this.mappingRules.get(0), relativePath, type);
        return stori;
    }

    @Override
    public StoRI createFile(String relativePath, StoRIType type) {
        this.log.debug("VFS Class - Relative Path : " + relativePath);
        StoRIImpl stori = new StoRIImpl((VirtualFSInterface)this, this.mappingRules.get(0), relativePath, type);
        return stori;
    }

    private Boolean isVOSAToken(TSpaceToken token) throws NamespaceException {
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        StorageSpaceData ssd = null;
        try {
            ssd = catalog.getStorageSpace(token);
        }
        catch (TransferObjectDecodingException e) {
            this.log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            throw new NamespaceException("Error retrieving Storage Area space information. TransferObjectDecodingException : " + e.getMessage());
        }
        catch (DataAccessException e) {
            this.log.error("Unable to get StorageSpaceTO from the DB. DataAccessException: " + e.getMessage());
            throw new NamespaceException("Error retrieving Storage Area space information. DataAccessException : " + e.getMessage());
        }
        if (ssd != null && ssd.getSpaceType().equals(TSpaceType.VOSPACE)) {
            return true;
        }
        return false;
    }

    @Override
    public void makeSilhouetteForFile(StoRI stori, TSizeInBytes presumedSize) throws NamespaceException {
        if (!stori.getStoRIType().equals(StoRIType.FILE)) {
            this.log.error("Unable to associate a Space to the StoRI with type: " + stori.getStoRIType());
            throw new NamespaceException("Unable to associate a Space to the StoRI with type: " + stori.getStoRIType());
        }
        SpaceSystem spaceSystem = this.getSpaceSystemDriverInstance();
        LocalFile localFile = stori.getLocalFile();
        TSizeInBytes guarSize = this.defValue.getDefaultGuaranteedSpaceSize();
        Space space = this.createSpace(presumedSize, presumedSize, localFile, spaceSystem);
        stori.setSpace(space);
    }

    @Override
    public synchronized void useSpaceForFile(TSpaceToken token, StoRI file, TSizeInBytes sizePresumed) throws NamespaceException, ExpiredSpaceTokenException {
        if (!file.getStoRIType().equals(StoRIType.FILE)) {
            this.log.error("Unable to associate a Space to the StoRI with type: " + file.getStoRIType());
            throw new NamespaceException("Unable to associate a Space to the StoRI with type: " + file.getStoRIType());
        }
        TSizeInBytes defaultFileSize = null;
        try {
            defaultFileSize = TSizeInBytes.make(Configuration.getInstance().getFileDefaultSize(), SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            this.log.debug("Invalid size created.");
        }
        Boolean found = this.isVOSAToken(token);
        if (found.booleanValue()) {
            try {
                file.allotSpaceForFile(sizePresumed);
            }
            catch (ReservationException e) {
                e.printStackTrace();
            }
            return;
        }
        StorageSpaceData spaceData = null;
        try {
            spaceData = new ReservedSpaceCatalog().getStorageSpace(token);
        }
        catch (TransferObjectDecodingException e) {
            this.log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            throw new NamespaceException("Error retrieving Storage Area information from Token. TransferObjectDecodingException : " + e.getMessage());
        }
        catch (DataAccessException e) {
            this.log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
            throw new NamespaceException("Error retrieving Storage Area information from Token. DataAccessException : " + e.getMessage());
        }
        if (spaceData == null) {
            throw new NamespaceException("No Storage Space stored with this token :" + token);
        }
        if (spaceData.isExpired()) {
            throw new ExpiredSpaceTokenException("Space Token Expired :" + token);
        }
        TSizeInBytes totalSpaceSize = spaceData.getTotalSpaceSize();
        this.log.debug("Total Space : " + totalSpaceSize);
        TSizeInBytes guarSpaceSize = spaceData.getReservedSpaceSize();
        this.log.debug("Guaranteed Space : " + guarSpaceSize);
        TSizeInBytes usedSpaceSize = spaceData.getUsedSpaceSize();
        this.log.debug("Used Space : " + usedSpaceSize);
        TSizeInBytes availableSpaceSize = spaceData.getAvailableSpaceSize();
        this.log.debug("Available Space : " + availableSpaceSize);
        if (availableSpaceSize == null) {
            availableSpaceSize = TSizeInBytes.makeEmpty();
        }
        if (usedSpaceSize == null) {
            usedSpaceSize = TSizeInBytes.makeEmpty();
        }
        if (!sizePresumed.isEmpty()) {
            this.log.debug("Presumed file size : " + sizePresumed);
            long consumeSize = -1L;
            consumeSize = sizePresumed.value() > availableSpaceSize.value() ? availableSpaceSize.value() : sizePresumed.value();
            long remainingSize = availableSpaceSize.value() - consumeSize;
            PFN pfn = spaceData.getSpaceFileName();
            long totalSize = spaceData.getTotalSpaceSize().value();
            this.log.debug("VFS: PFN name " + pfn);
            StoRI spaceFile = this.retrieveSpaceFileByPFN(pfn, totalSize);
            if (!spaceFile.getLocalFile().exists() || spaceFile.getLocalFile().isDirectory()) {
                this.log.error("Unable to get  the correct space file!spaceFile does not exsists or it is a directory.");
                return;
            }
            TSizeInBytes returnedSize = this.splitSpace(spaceFile, file, sizePresumed.value());
            spaceFile.setStoRIType(StoRIType.SPACE_BOUND);
            file.setSpace(spaceFile.getSpace());
            TSizeInBytes newUsedSpaceSize = TSizeInBytes.makeEmpty();
            TSizeInBytes newAvailableSpaceSize = TSizeInBytes.makeEmpty();
            try {
                newUsedSpaceSize = TSizeInBytes.make(totalSpaceSize.value() - remainingSize, SizeUnit.BYTES);
                newAvailableSpaceSize = TSizeInBytes.make(remainingSize, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex) {
                this.log.error("Unable to create Used Space Size, so use EMPTY size ", (Throwable)ex);
            }
            spaceData.setUsedSpaceSize(newUsedSpaceSize);
            spaceData.setUsedSpaceSize(newAvailableSpaceSize);
            this.storeSpaceByToken(spaceData);
        } else {
            this.log.warn(" --- Here there is a call with a empty presumed size!--- ");
            this.useAllSpaceForFile(token, file);
        }
    }

    @Override
    public synchronized void useAllSpaceForFile(TSpaceToken token, StoRI file) throws NamespaceException, ExpiredSpaceTokenException {
        if (!file.getStoRIType().equals(StoRIType.FILE)) {
            this.log.error("Unable to associate a Space to the StoRI with type: " + file.getStoRIType());
            throw new NamespaceException("Unable to associate a Space to the StoRI with type: " + file.getStoRIType());
        }
        TSizeInBytes defaultFileSize = null;
        try {
            defaultFileSize = TSizeInBytes.make(Configuration.getInstance().getFileDefaultSize(), SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            this.log.debug("Invalid size created.");
        }
        StorageSpaceData spaceData = null;
        try {
            spaceData = new ReservedSpaceCatalog().getStorageSpace(token);
        }
        catch (TransferObjectDecodingException e) {
            this.log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            throw new NamespaceException("Error retrieving Storage Area information from Token. TransferObjectDecodingException : " + e.getMessage());
        }
        catch (DataAccessException e) {
            this.log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
            throw new NamespaceException("Error retrieving Storage Area information from Token. DataAccessException : " + e.getMessage());
        }
        if (spaceData == null) {
            throw new NamespaceException("No Storage Space stored with this token :" + token);
        }
        if (spaceData.isExpired()) {
            throw new ExpiredSpaceTokenException("Space Token Expired :" + token);
        }
        if (this.isVOSAToken(token).booleanValue()) {
            Boolean found = this.isVOSAToken(token);
            if (found.booleanValue()) {
                try {
                    file.allotSpaceForFile(defaultFileSize);
                }
                catch (ReservationException e) {
                    e.printStackTrace();
                }
                return;
            }
        } else {
            if (spaceData.isExpired()) {
                throw new ExpiredSpaceTokenException("Space Token Expired :" + token);
            }
            TSizeInBytes totalSpaceSize = spaceData.getTotalSpaceSize();
            this.log.debug("Total Space : " + totalSpaceSize);
            TSizeInBytes guarSpaceSize = spaceData.getReservedSpaceSize();
            this.log.debug("Guaranteed Space : " + guarSpaceSize);
            TSizeInBytes usedSpaceSize = spaceData.getUsedSpaceSize();
            this.log.debug("Used Space : " + usedSpaceSize);
            TSizeInBytes availableSpaceSize = spaceData.getAvailableSpaceSize();
            this.log.debug("Available Space : " + availableSpaceSize);
            if (defaultFileSize.value() <= availableSpaceSize.value() / 2L) {
                this.log.debug("UseAllSpaceForFile size:" + defaultFileSize);
                this.useSpaceForFile(token, file, defaultFileSize);
            } else {
                TSizeInBytes fileSizeToUse = null;
                try {
                    fileSizeToUse = TSizeInBytes.make(availableSpaceSize.value() / 2L, SizeUnit.BYTES);
                }
                catch (InvalidTSizeAttributesException e) {
                    this.log.debug("Invalid size created.");
                }
                this.log.debug("UseAllSpaceForFile size:" + fileSizeToUse);
                this.useSpaceForFile(token, file, fileSizeToUse);
            }
        }
    }

    @Override
    public StoRI createSpace(String relativePath, long guaranteedSize, long totalSize) throws NamespaceException {
        StoRIType type = StoRIType.SPACE;
        StoRIImpl stori = new StoRIImpl((VirtualFSInterface)this, this.mappingRules.get(0), relativePath, type);
        SpaceSystem spaceSystem = this.getSpaceSystemDriverInstance();
        TSizeInBytes guarSize = TSizeInBytes.makeEmpty();
        try {
            guarSize = TSizeInBytes.make(guaranteedSize, SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException ex1) {
            this.log.error("Unable to create Guaranteed Size, so use EMPTY size ", (Throwable)ex1);
        }
        TSizeInBytes totSize = TSizeInBytes.makeEmpty();
        try {
            totSize = TSizeInBytes.make(totalSize, SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException ex2) {
            this.log.error("Unable to create Total Size, so use EMPTY size", (Throwable)ex2);
        }
        Space space = this.createSpace(guarSize, totSize, stori.getLocalFile(), spaceSystem);
        stori.setSpace(space);
        return stori;
    }

    @Override
    public StoRI createSpace(String relativePath, long totalsize) throws NamespaceException {
        StoRI stori = this.createSpace(relativePath, totalsize, totalsize);
        return stori;
    }

    @Override
    public TSizeInBytes splitSpace(StoRI spaceOrig, StoRI file, long sizePresumed) throws NamespaceException {
        TSizeInBytes newSize = TSizeInBytes.makeEmpty();
        String spacePFN = spaceOrig.getAbsolutePath();
        this.log.debug("VFS Split: spaceFileName:" + spacePFN);
        String relativeSpacePFN = NamespaceUtil.extractRelativePath(this.getRootPath(), spacePFN);
        this.log.debug("Looking for root:" + this.getRootPath());
        int index = spacePFN.indexOf(this.getRootPath());
        boolean failure = false;
        if (index != -1) {
            relativeSpacePFN = spacePFN.substring(index);
        } else {
            failure = true;
            this.log.debug("Root NotFound!");
        }
        this.log.debug("VFS Split: relativeSpacePFN:" + relativeSpacePFN);
        if (failure) {
            this.log.warn("SpacePFN does not refer to this VFS root! Something goes wrong in app-rule?");
            try {
                newSize = TSizeInBytes.make(sizePresumed, SizeUnit.BYTES);
                file = this.createSpace(NamespaceUtil.extractRelativePath(this.getRootPath(), file.getAbsolutePath()), sizePresumed);
                file.getSpace().allot();
            }
            catch (InvalidTSizeAttributesException ex) {
                this.log.error("Unable to create UNUsed Space Size, so use EMPTY size ", (Throwable)ex);
            }
            catch (ReservationException e2) {
                this.log.error("Unable to create space into File System");
            }
        } else {
            long realSize = spaceOrig.getLocalFile().getSize();
            if (sizePresumed <= realSize / 2L) {
                this.log.debug("SplitSpace Case (1)");
                this.log.debug("SplitSpace: " + spaceOrig.getAbsolutePath() + " truncating file to size:" + (realSize - sizePresumed));
                spaceOrig.getSpace().getSpaceFile().truncateFile(realSize - sizePresumed);
                try {
                    newSize = TSizeInBytes.make(sizePresumed, SizeUnit.BYTES);
                    file = this.createSpace(NamespaceUtil.extractRelativePath(this.getRootPath(), file.getAbsolutePath()), sizePresumed);
                    file.getSpace().allot();
                }
                catch (InvalidTSizeAttributesException ex) {
                    this.log.error("Unable to create UNUsed Space Size, so use EMPTY size ", (Throwable)ex);
                }
                catch (ReservationException e2) {
                    this.log.error("Unable to create space into File System");
                }
            } else {
                this.log.debug("SplitSpace Case (2)");
                spaceOrig.getSpace().getSpaceFile().truncateFile(sizePresumed);
                spaceOrig.getLocalFile().renameTo(file.getAbsolutePath());
                this.log.debug("VFS  : fileabspath:" + file.getAbsolutePath());
                long remainingSize = realSize - sizePresumed;
                try {
                    newSize = TSizeInBytes.make(remainingSize, SizeUnit.BYTES);
                    spaceOrig = this.createSpace(NamespaceUtil.extractRelativePath(this.getRootPath(), spacePFN), newSize.value());
                    spaceOrig.getSpace().allot();
                }
                catch (InvalidTSizeAttributesException ex) {
                    this.log.error("Unable to create UNUsed Space Size, so use EMPTY size ", (Throwable)ex);
                }
                catch (ReservationException e2) {
                    this.log.error("Unable to create space into File System");
                }
            }
        }
        return newSize;
    }

    @Override
    public StoRI createSpace(long guarSize, long totalSize) throws NamespaceException {
        String relativePath = this.makeSpaceFilePath();
        StoRI stori = this.createSpace(relativePath, guarSize, totalSize);
        return stori;
    }

    @Override
    public StoRI createSpace(long totalSize) throws NamespaceException {
        String relativePath = this.makeSpaceFilePath();
        TSizeInBytes guarSize = this.defValue.getDefaultGuaranteedSpaceSize();
        StoRI stori = this.createSpace(relativePath, guarSize.value(), totalSize);
        return stori;
    }

    @Override
    public StoRI createSpace() throws NamespaceException {
        String relativePath = this.makeSpaceFilePath();
        TSizeInBytes guarSize = this.defValue.getDefaultGuaranteedSpaceSize();
        TSizeInBytes totalSize = this.defValue.getDefaultTotalSpaceSize();
        StoRI stori = this.createSpace(relativePath, guarSize.value(), totalSize.value());
        return stori;
    }

    @Override
    public StoRI createDefaultStoRI() throws NamespaceException {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        sb.append(sep + "++++++++++++++++++++++++++++++++" + sep);
        sb.append(" VFS Name         : '" + this.aliasName + "'" + sep);
        sb.append(" VFS root         : '" + this.rootPath + "'" + sep);
        sb.append(" VFS FS driver    : '" + this.fsDriver.getName() + "'" + sep);
        sb.append(" VFS Space driver : '" + this.spaceSystemDriver.getName() + "'" + sep);
        sb.append(" -- DEFAULT VALUES --" + sep);
        sb.append(this.defValue);
        sb.append(" -- CAPABILITY --" + sep);
        sb.append(this.capabilities + "" + sep);
        sb.append("++++++++++++++++++++++++++++++++" + sep);
        return sb.toString();
    }

    private String makeSpaceFilePath() throws NamespaceException {
        String result = "";
        String spacePath = "/";
        GUID guid = new GUID();
        String spaceFileName = "vfs" + this.getAliasName() + "_" + guid + ".space";
        result = spacePath + "/" + spaceFileName;
        return result;
    }

    private Space createSpace(TSizeInBytes guarSize, TSizeInBytes totalSize, LocalFile file, SpaceSystem spaceSystem) throws NamespaceException {
        Space space = null;
        try {
            space = new Space(guarSize, totalSize, file, spaceSystem);
        }
        catch (InvalidSpaceAttributesException ex3) {
            this.log.error("Error while retrieving Space System Driver for VFS ", (Throwable)ex3);
            throw new NamespaceException("Error while retrieving Space System Driver for VFS ", ex3);
        }
        return space;
    }

    @Override
    public StorageSpaceData getSpaceByAlias(String desc) throws NamespaceException {
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        StorageSpaceData spaceData = catalog.getStorageSpaceByAlias(desc);
        return spaceData;
    }

    @Override
    public void storeSpaceByToken(StorageSpaceData spaceData) throws NamespaceException {
        ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
        catalog.updateStorageSpace(spaceData);
    }

    public StoRI retrieveSpaceFileByPFN(PFN pfn, long totalSize) throws NamespaceException {
        NamespaceInterface namespace = NamespaceDirector.getNamespace();
        StoRI stori = namespace.resolveStoRIbyPFN(pfn);
        stori.setStoRIType(StoRIType.SPACE);
        this.log.debug("VFS: retrieveSpace, relative " + stori.getRelativePath() + "-" + stori.toString());
        StoRI space = this.createSpace(stori.getRelativeStFN(), totalSize);
        stori.setSpace(space.getSpace());
        return stori;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public TSpaceToken getSpaceToken() throws NamespaceException {
        return this.spaceToken;
    }

    @Override
    public BalancingStrategy<? extends Node> getProtocolBalancingStrategy(Protocol protocol) {
        return this.capabilities.getBalancingStrategyByScheme(protocol);
    }

    @Override
    public boolean isPoolDefined(Protocol protocol) throws NamespaceException {
        return this.capabilities.isPooledProtocol(protocol);
    }

    @Override
    public SAAuthzType getStorageAreaAuthzType() throws NamespaceException {
        return this.saAuthzType;
    }

    @Override
    public String getStorageAreaAuthzDB() throws NamespaceException {
        if (this.getStorageAreaAuthzType().equals(SAAuthzType.AUTHZDB)) {
            return this.saAuthzSourceName;
        }
        throw new NamespaceException("Required AUTHZ-DB, but it is UNDEFINED.");
    }

    @Override
    public String getStorageAreaAuthzFixed() throws NamespaceException {
        if (this.getStorageAreaAuthzType().equals(SAAuthzType.FIXED)) {
            return this.saAuthzSourceName;
        }
        throw new NamespaceException("Required FIXED-AUTHZ, but it is UNDEFINED.");
    }
}

