/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

public class QuotaType {
    private final int ordinalNumber;
    private final String quotaType;
    private final String stringSchema;
    private String value;
    public static final QuotaType FILESET = new QuotaType("FILESET", "filesetName", 0);
    public static final QuotaType USR = new QuotaType("USR", "userName", 1);
    public static final QuotaType GRP = new QuotaType("GRP", "groupName", 2);
    public static final QuotaType UNKNOWN = new QuotaType("UNKNOWN", "Quota Type UNKNOWN!", -1);

    private QuotaType(String quotaType, String stringSchema, int ord) {
        this.quotaType = quotaType;
        this.stringSchema = stringSchema;
        this.ordinalNumber = ord;
    }

    public static QuotaType buildQuotaType(QuotaType quotaType) {
        String schema = quotaType.stringSchema;
        int ord = quotaType.getOrdinalNumber();
        String type = quotaType.quotaType;
        return new QuotaType(type, schema, ord);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getQuotaType() {
        return this.quotaType;
    }

    public static String string(int ord) {
        return QuotaType.getQuotaType(ord).toString();
    }

    public int getOrdinalNumber() {
        return this.ordinalNumber;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("QuotaType:").append(this.quotaType).append("=<").append(this.value).append(">");
        return sb.toString();
    }

    public static QuotaType getQuotaType(String quotaType) {
        if (quotaType.equals(FILESET.toString())) {
            return FILESET;
        }
        if (quotaType.equals(USR.toString())) {
            return USR;
        }
        if (quotaType.equals(GRP.toString())) {
            return GRP;
        }
        return UNKNOWN;
    }

    public static QuotaType getQuotaType(int quotaOrd) {
        if (quotaOrd == 0) {
            return FILESET;
        }
        if (quotaOrd == 1) {
            return USR;
        }
        if (quotaOrd == 2) {
            return GRP;
        }
        return UNKNOWN;
    }

    public int hashCode() {
        return this.ordinalNumber;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof QuotaType) {
            QuotaType qt = (QuotaType)other;
            if (qt.ordinalNumber == this.ordinalNumber) {
                result = true;
            }
        }
        return result;
    }
}

