/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.balancer.BalancingStrategyType;
import it.grid.storm.namespace.model.PoolMember;
import it.grid.storm.namespace.model.Protocol;
import java.util.ArrayList;
import java.util.List;

public class ProtocolPool {
    private final Protocol poolType;
    private final BalancingStrategyType balanceStrategy;
    private final List<PoolMember> poolMembers = new ArrayList<PoolMember>();

    public ProtocolPool(Protocol protocol, BalancingStrategyType strategy, List<PoolMember> members) {
        this.poolType = protocol;
        this.balanceStrategy = strategy;
        this.poolMembers.addAll(members);
    }

    public ProtocolPool(BalancingStrategyType strategy, List<PoolMember> members) {
        this(members.get(0).getMemberProtocol().getProtocol(), strategy, members);
    }

    public BalancingStrategyType getBalanceStrategy() {
        return this.balanceStrategy;
    }

    public Protocol getPoolType() {
        return this.poolType;
    }

    public List<PoolMember> getPoolMembers() {
        return this.poolMembers;
    }

    public void addPoolMember(PoolMember member) {
        this.poolMembers.add(member);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProtocolPool [poolType=");
        builder.append(this.poolType);
        builder.append(", balanceStrategy=");
        builder.append((Object)this.balanceStrategy);
        builder.append(", poolMembers=");
        builder.append(this.poolMembers);
        builder.append("]");
        return builder.toString();
    }
}

