/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.balancer.BalancingStrategy;
import it.grid.storm.balancer.BalancingStrategyFactory;
import it.grid.storm.balancer.Node;
import it.grid.storm.balancer.ftp.FTPNode;
import it.grid.storm.balancer.http.HTTPNode;
import it.grid.storm.balancer.http.HTTPSNode;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.model.ACLEntry;
import it.grid.storm.namespace.model.DefaultACL;
import it.grid.storm.namespace.model.PoolMember;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.model.ProtocolPool;
import it.grid.storm.namespace.model.Quota;
import it.grid.storm.namespace.model.TransportProtocol;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class Capability
implements CapabilityInterface {
    private Logger log = NamespaceDirector.getLogger();
    private ACLMode aclMode = ACLMode.UNDEF;
    private Quota quota = null;
    private Map<Protocol, TransportProtocol> transpProtocolsByScheme = new Hashtable<Protocol, TransportProtocol>();
    private Map<Integer, TransportProtocol> transpProtocolsByID = new Hashtable<Integer, TransportProtocol>();
    private List<TransportProtocol> transpProtocolsList = new ArrayList<TransportProtocol>();
    private Map<Protocol, ProtocolPool> protocolPoolsByScheme = new Hashtable<Protocol, ProtocolPool>();
    private Map<Protocol, BalancingStrategy<? extends Node>> balancerByScheme = new Hashtable<Protocol, BalancingStrategy<? extends Node>>();
    private DefaultACL defaultACL = new DefaultACL();

    public Capability(String aclMode) throws NamespaceException {
        this.setACLMode(aclMode);
    }

    public Capability() throws NamespaceException {
    }

    public void setACLMode(String aclMode) throws NamespaceException {
        this.aclMode = ACLMode.makeFromString(aclMode);
    }

    public void addTransportProtocolByScheme(Protocol protocol, TransportProtocol trasfProt) {
        this.transpProtocolsByScheme.put(protocol, trasfProt);
    }

    public void addTransportProtocolByID(int protocolIndex, TransportProtocol trasfProt) {
        this.transpProtocolsByID.put(new Integer(protocolIndex), trasfProt);
    }

    public void addTransportProtocol(TransportProtocol trasfProt) {
        this.transpProtocolsList.add(trasfProt);
    }

    public void addACLEntry(ACLEntry aclEntry) {
        if (this.defaultACL == null) {
            this.defaultACL = new DefaultACL();
        }
        this.defaultACL.addACLEntry(aclEntry);
    }

    public void setQuota(Quota quota) {
        this.quota = quota;
    }

    public void addProtocolPoolBySchema(Protocol protocol, ProtocolPool protPool) throws NamespaceException {
        this.protocolPoolsByScheme.put(protocol, protPool);
        if (protocol.equals(Protocol.GSIFTP) || protocol.equals(Protocol.HTTP) || protocol.equals(Protocol.HTTPS)) {
            BalancingStrategy balancingStrategy = null;
            LinkedList<Node> nodeList = new LinkedList<Node>();
            Node node = null;
            boolean weighedPool = protPool.getBalanceStrategy().requireWeight();
            for (PoolMember member : protPool.getPoolMembers()) {
                String hostname = member.getMemberProtocol().getAuthority().getServiceHostname();
                int port = member.getMemberProtocol().getAuthority().getServicePort();
                if (weighedPool) {
                    try {
                        node = this.buildNode(protocol, hostname, port, member.getMemberWeight());
                    }
                    catch (Exception e) {
                        this.log.error("Unable to build a node for protocol " + protocol);
                        throw new NamespaceException("Unable to build pool for protocol " + protocol);
                    }
                }
                try {
                    node = this.buildNode(protocol, hostname, port);
                }
                catch (Exception e) {
                    this.log.error("Unable to build a node for protocol " + protocol);
                    throw new NamespaceException("Unable to build pool for protocol " + protocol);
                }
                nodeList.add(node);
            }
            try {
                balancingStrategy = BalancingStrategyFactory.getBalancingStrategy(protPool.getBalanceStrategy(), nodeList);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Unable to get " + protPool.getBalanceStrategy().toString() + " balacing strategy for nodes " + nodeList.toString());
                throw new NamespaceException("Unable to create a balancing schema from the protocol pool");
            }
            this.balancerByScheme.put(protocol, balancingStrategy);
        } else {
            this.log.error("The current version manage only GSIFTP and HTTP/HTTPS POOL.");
        }
    }

    private Node buildNode(Protocol protocol, String hostname, int port) throws Exception {
        if (Protocol.GSIFTP == protocol) {
            return new FTPNode(hostname, port);
        }
        if (Protocol.HTTP == protocol) {
            return new HTTPNode(hostname, port);
        }
        if (Protocol.HTTPS == protocol) {
            return new HTTPSNode(hostname, port);
        }
        throw new Exception("Unsupported protocol, no node type available: " + protocol);
    }

    private Node buildNode(Protocol protocol, String hostname, int port, int memberWeight) throws Exception {
        if (Protocol.GSIFTP == protocol) {
            return new FTPNode(hostname, port, memberWeight);
        }
        if (Protocol.HTTP == protocol) {
            return new HTTPNode(hostname, port, memberWeight);
        }
        if (Protocol.HTTPS == protocol) {
            return new HTTPSNode(hostname, port, memberWeight);
        }
        throw new Exception("Unsupported protocol, no node type available: " + protocol);
    }

    @Override
    public ACLMode getACLMode() {
        return this.aclMode;
    }

    @Override
    public Quota getQuota() {
        return this.quota;
    }

    @Override
    public DefaultACL getDefaultACL() {
        return this.defaultACL;
    }

    @Override
    public boolean isAllowedProtocol(String protocolScheme) {
        boolean result = false;
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        sb.append(sep + "  Cap.aclMode : '" + this.aclMode + "'" + sep);
        sb.append("  Cap.Protocol : " + sep);
        int count = 0;
        for (Map.Entry<Protocol, TransportProtocol> entry : this.transpProtocolsByScheme.entrySet()) {
            sb.append("[TP(" + ++count + ")] " + entry.getKey() + ": " + entry.getValue());
        }
        count = 0;
        for (Map.Entry<Protocol, Object> entry : this.protocolPoolsByScheme.entrySet()) {
            sb.append("[TP(" + ++count + ")] " + entry.getKey() + ": " + entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public ProtocolPool getPoolByScheme(Protocol protocol) {
        ProtocolPool poll = null;
        boolean isPresent = this.protocolPoolsByScheme.containsKey(protocol);
        if (isPresent) {
            poll = this.protocolPoolsByScheme.get(protocol);
        }
        return poll;
    }

    @Override
    public BalancingStrategy<? extends Node> getBalancingStrategyByScheme(Protocol protocol) {
        BalancingStrategy<? extends Node> balancer = null;
        boolean isPresent = this.balancerByScheme.containsKey(protocol);
        if (isPresent) {
            balancer = this.balancerByScheme.get(protocol);
        }
        return balancer;
    }

    @Override
    public List<TransportProtocol> getManagedProtocolByScheme(Protocol protocol) {
        ArrayList<TransportProtocol> result = new ArrayList<TransportProtocol>();
        for (TransportProtocol tp : this.transpProtocolsList) {
            if (!tp.getProtocol().equals(protocol)) continue;
            result.add(tp);
        }
        return result;
    }

    @Override
    public List<Protocol> getAllManagedProtocols() {
        ArrayList<Protocol> result = new ArrayList<Protocol>();
        result.addAll(this.transpProtocolsByScheme.keySet());
        return result;
    }

    @Override
    public boolean isPooledProtocol(Protocol protocol) {
        boolean result = false;
        result = this.protocolPoolsByScheme.containsKey(protocol);
        return result;
    }

    @Override
    public TransportProtocol getProtocolByID(int id) {
        TransportProtocol tProt = null;
        boolean isPresent = this.transpProtocolsByID.containsKey(id);
        if (isPresent) {
            tProt = this.transpProtocolsByID.get(id);
        }
        return tProt;
    }

    public static class ACLMode {
        public static final ACLMode JUST_IN_TIME = new ACLMode("JiT");
        public static final ACLMode AHEAD_OF_TIME = new ACLMode("AoT");
        public static final ACLMode UNDEF = new ACLMode("UNDEF");
        private String aclMode;

        private ACLMode(String mode) {
            this.aclMode = mode;
        }

        private static ACLMode makeFromString(String aclMode) throws NamespaceException {
            ACLMode result = UNDEF;
            if (aclMode.toLowerCase().equals(AHEAD_OF_TIME.toString().toLowerCase())) {
                result = AHEAD_OF_TIME;
            } else if (aclMode.toLowerCase().equals(JUST_IN_TIME.toString().toLowerCase())) {
                result = JUST_IN_TIME;
            } else {
                throw new NamespaceException("ACL Mode is not recognized!");
            }
            return result;
        }

        public String toString() {
            return this.aclMode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ACLMode) {
                ACLMode aclMode = (ACLMode)obj;
                return aclMode.toString().toLowerCase().equals(this.toString().toLowerCase());
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.aclMode != null ? this.aclMode.hashCode() : 0);
            return result;
        }
    }
}

