/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.config.xml;

import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.config.xml.XMLConst;
import it.grid.storm.namespace.model.SAAuthzType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLParserUtil
implements XMLConst {
    private final HierarchicalConfiguration configuration;
    private final Logger log = LoggerFactory.getLogger(XMLParserUtil.class);

    public XMLParserUtil(Configuration config) {
        this.configuration = (HierarchicalConfiguration)config;
    }

    public boolean validateXML() {
        return true;
    }

    public boolean areThereSustitutionCharInside(String element) {
        boolean result = false;
        result = element.indexOf(167) != -1 || element.indexOf(176) != -1 || element.indexOf(94) != -1 || element.indexOf(231) != -1 || element.indexOf(126) != -1;
        return result;
    }

    public char whicSubstitutionChar(String element) {
        if (element.indexOf(167) != -1) {
            return '\u00a7';
        }
        if (element.indexOf(176) != -1) {
            return '\u00b0';
        }
        if (element.indexOf(94) != -1) {
            return '^';
        }
        if (element.indexOf(231) != -1) {
            return '\u00e7';
        }
        if (element.indexOf(126) != -1) {
            return '~';
        }
        if (element.indexOf(42) != -1) {
            return '*';
        }
        return ' ';
    }

    @Override
    public String getNamespaceVersion() throws NamespaceException {
        String result = null;
        result = this.getStringProperty("[@version]");
        return result;
    }

    @Override
    public String getFSSpaceTokenDescription(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).space-token-description"));
        return result;
    }

    @Override
    public String getRetentionPolicyType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.RetentionPolicy"));
        return result;
    }

    @Override
    public String getAccessLatencyType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.AccessLatency"));
        return result;
    }

    @Override
    public String getExpirationModeType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.ExpirationMode"));
        return result;
    }

    @Override
    public String getOnlineSpaceUnitType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = null;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalOnlineSize[@unit]"))) {
            result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalOnlineSize[@unit]"));
        } else {
            result = "TB";
            this.log.debug("Online Space Unit type for VFS(+'" + nameOfFS + "') is absent. Default value ('" + result + "') will be used");
        }
        return result;
    }

    @Override
    public long getOnlineSpaceSize(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        long result = this.getLongProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalOnlineSize"));
        return result;
    }

    @Override
    public String getNearlineSpaceUnitType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = null;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalNearlineSize[@unit]"))) {
            result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalNearlineSize[@unit]"));
        } else {
            result = "TB";
            this.log.debug("Online Space Unit type for VFS(+'" + nameOfFS + "') is absent. Default value ('" + result + "') will be used");
        }
        return result;
    }

    @Override
    public long getNearlineSpaceSize(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        long result = this.getLongProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalNearlineSize"));
        return result;
    }

    @Override
    public int getNumberOfFS() throws NamespaceException {
        return this.getPropertyNumber("filesystems.filesystem.root");
    }

    @Override
    public String getFSName(int numOfFS) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0)[@name]"));
    }

    @Override
    public int getFSNumber(String nameOfFS) throws NamespaceException {
        return this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
    }

    @Override
    public String getFSType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0)[@fs_type]"));
    }

    @Override
    public String getFSRoot(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).root"));
        return result;
    }

    @Override
    public String getFSDriver(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).filesystem-driver"));
    }

    @Override
    public String getSpaceDriver(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).spacesystem-driver"));
    }

    public boolean isDefaultElementPresent(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        result = this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values"));
        return result;
    }

    @Override
    public String getDefaultSpaceType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values.space[@type]"));
    }

    @Override
    public long getDefaultSpaceLifeTime(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getLongProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values.space[@lifetime]"));
    }

    @Override
    public long getDefaultSpaceGuarSize(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getLongProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values.space[@guarsize]"));
    }

    @Override
    public long getDefaultSpaceTotSize(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getLongProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values.space[@totalsize]"));
    }

    @Override
    public String getDefaultFileType(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values.file[@type]"));
    }

    @Override
    public long getDefaultFileLifeTime(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getLongProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).defaults-values.file[@lifetime]"));
    }

    @Override
    public String getACLMode(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.aclMode"));
    }

    @Override
    public int getNumberOfProt(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (numOfFS == -1) {
            throw new NamespaceException("FS named '" + nameOfFS + "' does not exist in config");
        }
        String protCount = this.substitutionNumber("filesystems.filesystem(\u00b0).capabilities.trans-prot.prot.schema", '\u00b0', numOfFS);
        return this.getPropertyNumber(protCount);
    }

    @Override
    public String getProtName(String nameOfFS, int numOfProt) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInProtocolElement(nameOfFS, numOfProt, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot(\u00a7)[@name]"));
    }

    public int getProtNumberByName(String nameOfFS, String nameOfProt) throws NamespaceException {
        int numFS = this.getFSNumber(nameOfFS);
        String collElem = this.substituteNumberInFSElement(numFS, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot[@name]");
        return this.retrieveNumberByName(nameOfProt, collElem);
    }

    @Override
    public String getProtSchema(String nameOfFS, int numOfProt) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInProtocolElement(nameOfFS, numOfProt, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot(\u00a7).schema"));
    }

    @Override
    public String getProtHost(String nameOfFS, int numOfProt) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInProtocolElement(nameOfFS, numOfProt, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot(\u00a7).host"));
    }

    @Override
    public String getProtPort(String nameOfFS, int numOfProt) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInProtocolElement(nameOfFS, numOfProt, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot(\u00a7).port"));
    }

    @Override
    public int getNumberOfMappingRule() throws NamespaceException {
        return this.getPropertyNumber("mapping-rules.map-rule.stfn-root");
    }

    @Override
    public String getMapRuleName(int numOfMapRule) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInMAPElement(numOfMapRule, "mapping-rules.map-rule(\u00e7)[@name]"));
    }

    @Override
    public String getMapRule_StFNRoot(String nameOfMapRule) throws NamespaceException {
        int numOfMapRule = this.retrieveNumberByName(nameOfMapRule, "mapping-rules.map-rule[@name]");
        return this.getStringProperty(this.substituteNumberInMAPElement(numOfMapRule, "mapping-rules.map-rule(\u00e7).stfn-root"));
    }

    @Override
    public String getMapRule_mappedFS(String nameOfMapRule) throws NamespaceException {
        int numOfMapRule = this.retrieveNumberByName(nameOfMapRule, "mapping-rules.map-rule[@name]");
        return this.getStringProperty(this.substituteNumberInMAPElement(numOfMapRule, "mapping-rules.map-rule(\u00e7).mapped-fs"));
    }

    @Override
    public int getNumberOfApproachRule() throws NamespaceException {
        return this.getPropertyNumber("approachable-rules.app-rule[@name]");
    }

    @Override
    public String getApproachRuleName(int numOfAppRule) throws NamespaceException {
        return this.getStringProperty(this.substituteNumberInAPPElement(numOfAppRule, "approachable-rules.app-rule(^)[@name]"));
    }

    @Override
    public String getAppRule_SubjectDN(String nameOfAppRule) throws NamespaceException {
        int numOfAppRule = this.retrieveNumberByName(nameOfAppRule, "approachable-rules.app-rule[@name]");
        return this.getStringProperty(this.substituteNumberInAPPElement(numOfAppRule, "approachable-rules.app-rule(^).subjects.dn"));
    }

    @Override
    public String getAppRule_SubjectVO(String nameOfAppRule) throws NamespaceException {
        int numOfAppRule = this.retrieveNumberByName(nameOfAppRule, "approachable-rules.app-rule[@name]");
        return this.getStringProperty(this.substituteNumberInAPPElement(numOfAppRule, "approachable-rules.app-rule(^).subjects.vo-name"));
    }

    @Override
    public List getAppRule_AppFS(String nameOfAppRule) throws NamespaceException {
        int numOfAppRule = this.retrieveNumberByName(nameOfAppRule, "approachable-rules.app-rule[@name]");
        return this.getListValue(this.substituteNumberInAPPElement(numOfAppRule, "approachable-rules.app-rule(^).approachable-fs"));
    }

    @Override
    public String getAppRule_RelativePath(String nameOfAppRule) throws NamespaceException {
        int numOfAppRule = this.retrieveNumberByName(nameOfAppRule, "approachable-rules.app-rule[@name]");
        return this.getStringProperty(this.substituteNumberInAPPElement(numOfAppRule, "approachable-rules.app-rule(^).space-rel-path"));
    }

    public String getAppRule_AnonymousHttpRead(String nameOfAppRule) throws NamespaceException {
        int numOfAppRule = this.retrieveNumberByName(nameOfAppRule, "approachable-rules.app-rule[@name]");
        return this.getStringProperty(this.substituteNumberInAPPElement(numOfAppRule, "approachable-rules.app-rule(^).anonymous-http-read"));
    }

    @Override
    public boolean getQuotaDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota[@enabled]"))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean getQuotaEnabled(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        result = this.getBooleanProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota[@enabled]"));
        return result;
    }

    @Override
    public boolean getQuotaDeviceDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.device"))) {
            result = true;
        }
        return result;
    }

    @Override
    public String getQuotaDevice(String nameOfFS) throws NamespaceException {
        String result = null;
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (!this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.device"))) {
            throw new NamespaceException("Unable to find the element 'filesystems.filesystem(\u00b0).capabilities.quota.device' for the VFS:'" + nameOfFS + "'");
        }
        result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.device"));
        return result;
    }

    @Override
    public boolean getQuotaFilesetDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.filesetName"))) {
            result = true;
        }
        return result;
    }

    @Override
    public String getQuotaFileset(String nameOfFS) throws NamespaceException {
        String result = null;
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (!this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.filesetName"))) {
            throw new NamespaceException("Unable to find the element 'filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.filesetName' for the VFS:'" + nameOfFS + "'");
        }
        result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.filesetName"));
        return result;
    }

    @Override
    public boolean getQuotaGroupIDDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.groupName"))) {
            result = true;
        }
        return result;
    }

    @Override
    public String getQuotaGroupID(String nameOfFS) throws NamespaceException {
        String result = null;
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (!this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.groupName"))) {
            throw new NamespaceException("Unable to find the element 'filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.groupName' for the VFS:'" + nameOfFS + "'");
        }
        result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.groupName"));
        return result;
    }

    @Override
    public boolean getQuotaUserIDDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.userName"))) {
            result = true;
        }
        return result;
    }

    @Override
    public String getQuotaUserID(String nameOfFS) throws NamespaceException {
        String result = null;
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (!this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.userName"))) {
            throw new NamespaceException("Unable to find the element 'filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.userName' for the VFS:'" + nameOfFS + "'");
        }
        result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.quota.quotaElement.userName"));
        return result;
    }

    public String getStorageClass(String nameOfFS) throws NamespaceException {
        String result = "T0D1";
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).storage-class"))) {
            result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).storage-class"));
        } else {
            this.log.debug("Storage Class for VFS(+'" + nameOfFS + "') is absent. Default value ('" + result + "') will be used.");
        }
        return result;
    }

    private String substitutionNumber(String xpath, char patternChar, int number) {
        int startIndex = 0;
        int pos = 0;
        StringBuffer result = new StringBuffer();
        pos = xpath.indexOf(patternChar, startIndex);
        String numStr = Integer.toString(number);
        result.append(xpath.substring(startIndex, pos));
        result.append(numStr);
        result.append(xpath.substring(pos + 1));
        return result.toString();
    }

    private String substituteNumberInFSElement(int numberOfFS, String element) throws NamespaceException {
        int numFS = this.getNumberOfFS();
        if (numberOfFS > numFS) {
            throw new NamespaceException("Invalid pointing of Virtual File system");
        }
        String new_element = this.substitutionNumber(element, '\u00b0', numberOfFS);
        return new_element;
    }

    private String substituteNumberInACLEntryElement(String nameOfFS, int numberOfACLEntry, String element) throws NamespaceException {
        int numFS = this.getFSNumber(nameOfFS);
        if (numFS == -1) {
            throw new NamespaceException("Virtual File system (" + nameOfFS + ") does not exists");
        }
        int numACL = this.getNumberOfACL(nameOfFS);
        if (numberOfACLEntry > numACL) {
            throw new NamespaceException("Invalid pointing of ACL Entry within VFS");
        }
        String new_element = this.substitutionNumber(element, '\u00b0', numFS);
        new_element = this.substitutionNumber(new_element, '~', numberOfACLEntry);
        return new_element;
    }

    private String substituteNumberInProtocolElement(String nameOfFS, int numberOfProtocol, String element) throws NamespaceException {
        int numFS = this.getFSNumber(nameOfFS);
        if (numFS == -1) {
            throw new NamespaceException("Virtual File system (" + nameOfFS + ") does not exists");
        }
        int numProt = this.getNumberOfProt(nameOfFS);
        if (numberOfProtocol > numProt) {
            throw new NamespaceException("Invalid pointing of Protocol within VFS");
        }
        String new_element = this.substitutionNumber(element, '\u00b0', numFS);
        new_element = this.substitutionNumber(new_element, '\u00a7', numberOfProtocol);
        return new_element;
    }

    private String substituteNumberInPoolElement(String nameOfFS, int numberOfPool, String element) throws NamespaceException {
        int numFS = this.getFSNumber(nameOfFS);
        if (numFS == -1) {
            throw new NamespaceException("Virtual File system (" + nameOfFS + ") does not exists");
        }
        int numPool = this.getNumberOfPool(nameOfFS);
        if (numberOfPool > numPool) {
            throw new NamespaceException("Invalid pointing of Pool within VFS");
        }
        String new_element = this.substitutionNumber(element, '\u00b0', numFS);
        new_element = this.substitutionNumber(new_element, '\u00a3', numberOfPool);
        return new_element;
    }

    private String substituteNumberInMembersElement(String nameOfFS, int numOfPool, int numberOfMember, String element) throws NamespaceException {
        int numFS = this.getFSNumber(nameOfFS);
        if (numFS == -1) {
            throw new NamespaceException("Virtual File system (" + nameOfFS + ") does not exists");
        }
        int numMembers = this.getNumberOfPoolMembers(nameOfFS, numOfPool);
        if (numberOfMember > numMembers) {
            throw new NamespaceException("Invalid pointing of Member within VFS");
        }
        String new_element = this.substitutionNumber(element, '\u00b0', numFS);
        new_element = this.substitutionNumber(new_element, '\u00a3', numOfPool);
        new_element = this.substitutionNumber(new_element, '*', numberOfMember);
        return new_element;
    }

    private String substituteNumberInMAPElement(int numberOfMapRule, String element) throws NamespaceException {
        int numMapRule = this.getNumberOfMappingRule();
        if (numberOfMapRule > numMapRule) {
            throw new NamespaceException("Invalid pointing of Mapping Rule");
        }
        String new_element = this.substitutionNumber(element, '\u00e7', numberOfMapRule);
        return new_element;
    }

    private String substituteNumberInAPPElement(int numberOfAppRule, String element) throws NamespaceException {
        int numAppRule = this.getNumberOfApproachRule();
        if (numberOfAppRule > numAppRule) {
            throw new NamespaceException("Invalid pointing of Approachable Rule");
        }
        String new_element = this.substitutionNumber(element, '^', numberOfAppRule);
        return new_element;
    }

    private int retrieveNumberByName(String name, String collectionElement, boolean logging) {
        int result = -1;
        int size = -1;
        List prop = this.configuration.getList(collectionElement);
        if (prop != null) {
            size = prop.size();
            if (logging) {
                for (int i = 0; i < size; ++i) {
                    this.log.debug(prop.get(i).toString());
                }
            }
            result = prop.indexOf(name);
        } else {
            this.log.warn("[retrieveNumberByName_3] Element <" + collectionElement + "> does not exists in namespace configuration file");
        }
        return result;
    }

    private int retrieveNumberByName(String name, String collectionElement) {
        int result = -1;
        int size = -1;
        List prop = this.configuration.getList(collectionElement);
        if (prop != null) {
            size = prop.size();
            result = prop.indexOf(name);
        } else {
            this.log.warn("[retrieveNumberByName_2] Element <" + collectionElement + "> does not exists in namespace configuration file");
        }
        return result;
    }

    public Iterator getKeys() {
        return this.configuration.getKeys();
    }

    private int getPropertyNumber(String element) {
        int result = -1;
        Object prop = this.configuration.getProperty(element);
        if (prop != null) {
            result = 1;
            if (prop instanceof Collection) {
                result = ((Collection)prop).size();
            }
        } else {
            this.log.warn("[getPropertyNumber] Element <" + element + "> does not exists in namespace configuration file");
        }
        return result;
    }

    private boolean isPresent(String element) {
        boolean result = false;
        result = this.configuration.containsKey(element);
        return result;
    }

    private String getStringProperty(String element) throws NamespaceException {
        String prop = null;
        try {
            prop = this.configuration.getString(element);
        }
        catch (ConversionException ce) {
            this.log.warn("[getStringProperty] Element <" + element + "> does not contains a String value");
        }
        catch (NoSuchElementException note) {
            this.log.warn("[getStringProperty] Element <" + element + "> does not exists in namespace configuration file");
        }
        return prop;
    }

    private boolean getBooleanProperty(String element) throws NamespaceException {
        boolean result = false;
        try {
            result = this.configuration.getBoolean(element);
        }
        catch (ConversionException ce) {
            this.log.warn("[getLongProperty] Element <" + element + "> does not contains a String value");
        }
        catch (NoSuchElementException note) {
            this.log.warn("[getLongProperty] Element <" + element + "> does not exists in namespace configuration file");
        }
        return result;
    }

    private long getLongProperty(String element) throws NamespaceException {
        long prop = -1L;
        try {
            prop = this.configuration.getLong(element);
        }
        catch (ConversionException ce) {
            this.log.warn("[getLongProperty] Element <" + element + "> does not contains a String value");
        }
        catch (NoSuchElementException note) {
            this.log.warn("[getLongProperty] Element <" + element + "> does not exists in namespace configuration file");
        }
        return prop;
    }

    private int getIntProperty(String element) {
        int prop = -1;
        try {
            prop = this.configuration.getInt(element);
        }
        catch (ConversionException ce) {
            this.log.warn("[getIntProperty] Element <" + element + "> does not contains a String value");
        }
        catch (NoSuchElementException note) {
            this.log.warn("[getIntProperty] Element <" + element + "> does not exists in namespace configuration file");
        }
        return prop;
    }

    private String[] getListProperty(String element) throws NamespaceException {
        String prop = null;
        try {
            prop = this.configuration.getString(element);
        }
        catch (ConversionException ce) {
            this.log.warn("[getListProperty] Element <" + element + "> does not contains a String value");
        }
        catch (NoSuchElementException note) {
            this.log.warn("[getListProperty] Element <" + element + "> does not exists in namespace configuration file");
        }
        String[] result = prop.split(",");
        return result;
    }

    private List getListValue(String collectionElement) {
        List propList = this.configuration.getList(collectionElement);
        ArrayList<String> prop = new ArrayList<String>();
        Iterator i$ = propList.iterator();
        while (i$.hasNext()) {
            String element2;
            String element = element2 = (String)i$.next();
            prop.add(element.trim());
        }
        this.log.debug("LIST - prop : " + prop);
        this.log.debug("Nr. of elements : " + prop.size());
        if (prop.size() == 0) {
            this.log.warn("[retrieveNumberByName_2] Element <" + collectionElement + "> does not exists in namespace configuration file");
        }
        return prop;
    }

    @Override
    public boolean getDefaultACLDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.default-acl.acl-entry.groupName"))) {
            result = true;
        }
        return result;
    }

    @Override
    public int getNumberOfACL(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (numOfFS == -1) {
            throw new NamespaceException("FS named '" + nameOfFS + "' does not exist in config");
        }
        String aclCount = this.substitutionNumber("filesystems.filesystem(\u00b0).capabilities.default-acl.acl-entry.groupName", '\u00b0', numOfFS);
        this.log.debug("ACL Count = " + aclCount);
        return this.getPropertyNumber(aclCount);
    }

    @Override
    public String getGroupName(String nameOfFS, int aclEntryNumber) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String aclCount = this.substitutionNumber("filesystems.filesystem(\u00b0).capabilities.default-acl.acl-entry.groupName", '\u00b0', numOfFS);
        String result = null;
        Object prop = this.configuration.getProperty(aclCount);
        if (prop != null) {
            if (prop instanceof Collection) {
                ArrayList propList = new ArrayList((Collection)prop);
                if (propList.size() > aclEntryNumber) {
                    result = (String)propList.get(aclEntryNumber);
                }
            } else if (prop instanceof String) {
                result = (String)prop;
            }
        } else {
            this.log.warn("[getPropertyNumber] Element <" + aclCount + "> does not exists in namespace configuration file");
        }
        return result;
    }

    @Override
    public String getPermissionString(String nameOfFS, int aclEntryNumber) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        String aclCount = this.substitutionNumber("filesystems.filesystem(\u00b0).capabilities.default-acl.acl-entry.permissions", '\u00b0', numOfFS);
        String result = null;
        Object prop = this.configuration.getProperty(aclCount);
        if (prop != null) {
            if (prop instanceof Collection) {
                ArrayList propList = new ArrayList((Collection)prop);
                if (propList.size() > aclEntryNumber) {
                    result = (String)propList.get(aclEntryNumber);
                }
            } else if (prop instanceof String) {
                result = (String)prop;
            }
        } else {
            this.log.warn("[getPropertyNumber] Element <" + aclCount + "> does not exists in namespace configuration file");
        }
        return result;
    }

    @Override
    public String getStorageAreaAuthz(String nameOfFS, SAAuthzType type) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (type.equals(SAAuthzType.FIXED)) {
            return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).storage-area-authz.fixed"));
        }
        return this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).storage-area-authz.authz-db"));
    }

    @Override
    public SAAuthzType getStorageAreaAuthzType(String nameOfFS) throws NamespaceException {
        if (this.getStorageAreaAuthzFixedDefined(nameOfFS)) {
            return SAAuthzType.FIXED;
        }
        if (this.getStorageAreaAuthzDBDefined(nameOfFS)) {
            return SAAuthzType.AUTHZDB;
        }
        throw new NamespaceException("Unable to find the SAAuthzType in " + nameOfFS);
    }

    @Override
    public boolean getStorageAreaAuthzFixedDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).storage-area-authz.fixed"))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean getStorageAreaAuthzDBDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).storage-area-authz.authz-db"))) {
            result = true;
        }
        return result;
    }

    @Override
    public int getProtId(String nameOfFS, int numOfProt) throws NamespaceException {
        String protId = this.substituteNumberInProtocolElement(nameOfFS, numOfProt, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot(\u00a7).id");
        if (this.isPresent(protId)) {
            return this.getIntProperty(this.substituteNumberInProtocolElement(nameOfFS, numOfProt, "filesystems.filesystem(\u00b0).capabilities.trans-prot.prot(\u00a7).id"));
        }
        return -1;
    }

    @Override
    public boolean getOnlineSpaceLimitedSize(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        result = this.getBooleanProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).properties.TotalOnlineSize[@limited-size]"));
        return result;
    }

    public int getNumberOfPool(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (numOfFS == -1) {
            throw new NamespaceException("FS named '" + nameOfFS + "' does not exist in config");
        }
        if (!this.getPoolDefined(nameOfFS)) {
            return 0;
        }
        String protCount = this.substitutionNumber("filesystems.filesystem(\u00b0).capabilities.pool.balance-strategy", '\u00b0', numOfFS);
        return this.getPropertyNumber(protCount);
    }

    @Override
    public boolean getPoolDefined(String nameOfFS) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        boolean result = false;
        if (this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.pool.balance-strategy"))) {
            result = true;
        }
        return result;
    }

    @Override
    public String getBalancerStrategy(String nameOfFS) throws NamespaceException {
        String result = null;
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (!this.isPresent(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).balance-strategy"))) {
            throw new NamespaceException("Unable to find the element 'filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).balance-strategy' for the VFS:'" + nameOfFS + "'");
        }
        result = this.getStringProperty(this.substituteNumberInFSElement(numOfFS, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).balance-strategy"));
        return result;
    }

    @Override
    public int getNumberOfPoolMembers(String nameOfFS, int poolCounter) throws NamespaceException {
        int numOfFS = this.retrieveNumberByName(nameOfFS, "filesystems.filesystem[@name]");
        if (numOfFS == -1) {
            throw new NamespaceException("FS named '" + nameOfFS + "' does not exist in config");
        }
        String subTree = this.substituteNumberInPoolElement(nameOfFS, poolCounter, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3)");
        SubnodeConfiguration sub = this.configuration.configurationAt(subTree);
        Object members = sub.getProperty("members.member[@member-id]");
        int numOfMembers = -1;
        if (members != null) {
            numOfMembers = members instanceof Collection ? ((Collection)members).size() : 1;
        } else {
            this.log.error("Error during the retrieve of the number of pool member of " + nameOfFS);
        }
        return numOfMembers;
    }

    @Override
    public int getMemberID(String nameOfFS, int numOfPool, int memberNr) throws NamespaceException {
        return this.getIntProperty(this.substituteNumberInMembersElement(nameOfFS, numOfPool, memberNr, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).members.member(*)[@member-id]"));
    }

    @Override
    public int getMemberWeight(String nameOfFS, int numOfPool, int memberNr) throws NamespaceException {
        return this.getIntProperty(this.substituteNumberInMembersElement(nameOfFS, numOfPool, memberNr, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).members.member(*).weight"));
    }

    public String getBalancerStrategy(String fsName, int poolCounter) throws NamespaceException {
        String poolId = this.substituteNumberInPoolElement(fsName, poolCounter, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).balance-strategy");
        if (this.isPresent(poolId)) {
            return this.getStringProperty(this.substituteNumberInPoolElement(fsName, poolCounter, "filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).balance-strategy"));
        }
        throw new NamespaceException("Unable to find the element 'filesystems.filesystem(\u00b0).capabilities.pool(\u00a3).balance-strategy' for the VFS:'" + fsName + "'");
    }
}

