/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.config;

import it.grid.storm.config.Configuration;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.ACLEntry;
import it.grid.storm.namespace.model.ApproachableRule;
import it.grid.storm.namespace.model.DefaultACL;
import it.grid.storm.namespace.model.MappingRule;
import it.grid.storm.namespace.util.userinfo.LocalGroups;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.slf4j.Logger;

public class NamespaceCheck {
    private final Logger log = NamespaceDirector.getLogger();
    private final Hashtable<String, VirtualFSInterface> vfss;
    private final Hashtable<String, MappingRule> maprules;
    private final Hashtable<String, ApproachableRule> apprules;

    public NamespaceCheck(Hashtable<String, VirtualFSInterface> vfss, Hashtable<String, MappingRule> maprules, Hashtable<String, ApproachableRule> apprules) {
        this.vfss = vfss;
        this.maprules = maprules;
        this.apprules = apprules;
    }

    public boolean check() {
        boolean totalResult = true;
        boolean vfsCheck = this.checkVFS();
        boolean mapRulesCheck = this.checkMapRules();
        boolean appRules = this.checkAppRules();
        boolean checkGroups = this.checkGroups(vfsCheck);
        totalResult = vfsCheck && mapRulesCheck && appRules;
        return totalResult;
    }

    private boolean checkGroups(boolean vfsCheckResult) {
        this.log.info("Namespace check. Checking of the existence of the needed Local group ...");
        boolean result = true;
        if (!vfsCheckResult) {
            this.log.warn("Skip the check of the needed Local Group, because check of VFSs failed.");
        } else {
            ArrayList<VirtualFSInterface> vf = new ArrayList<VirtualFSInterface>(this.vfss.values());
            for (VirtualFSInterface vfs : vf) {
                ArrayList<ACLEntry> acl;
                DefaultACL defACL;
                CapabilityInterface cap;
                if (vfs.getStorageClassType().isTapeEnabled()) {
                    String groupRead = Configuration.getInstance().getGroupTapeReadBuffer();
                    if (!LocalGroups.getInstance().isGroupDefined(groupRead)) {
                        this.log.warn("!!!!! Local Group for READ BUFFER ('" + groupRead + "') is not defined!");
                        result = false;
                    }
                    String groupWrite = Configuration.getInstance().getGroupTapeWriteBuffer();
                    if (!LocalGroups.getInstance().isGroupDefined(groupWrite)) {
                        this.log.warn("!!!!! Local Group for WRITE BUFFER ('" + groupWrite + "') is not defined!");
                    }
                }
                if ((cap = vfs.getCapabilities()) == null || (defACL = cap.getDefaultACL()) == null || (acl = new ArrayList<ACLEntry>(defACL.getACL())).isEmpty()) continue;
                for (ACLEntry aclEntry : acl) {
                    if (LocalGroups.getInstance().isGroupDefined(aclEntry.getGroupName())) continue;
                    this.log.warn("!!!!! Local Group for ACL ('" + aclEntry + "') is not defined!");
                    result = false;
                }
            }
        }
        if (result) {
            this.log.info("All local groups are defined. ");
        } else {
            this.log.warn("Please check the local group needed to StoRM");
        }
        return result;
    }

    private boolean checkVFS() {
        this.log.info("Namespace checking VFSs ..");
        boolean result = true;
        if (this.vfss == null) {
            this.log.error("Anyone VFS is defined in namespace!");
            return false;
        }
        ArrayList<VirtualFSInterface> rules = new ArrayList<VirtualFSInterface>(this.vfss.values());
        for (VirtualFSInterface vfs : rules) {
            try {
                String aliasName = vfs.getAliasName();
                this.log.debug("VFS named '" + aliasName + "' found.");
                String root = vfs.getRootPath();
                File file = new File(root);
                boolean exists = file.exists();
                if (exists) continue;
                this.log.error("ERROR in NAMESPACE: The VFS '" + aliasName + "' does not have a valid root :'" + root + "'");
                result = false;
            }
            catch (NamespaceException ex) {
                this.log.error("Error while checking VFS.", (Throwable)ex);
                result = false;
            }
        }
        if (result) {
            this.log.info(" VFSs are well-defined.");
        }
        return result;
    }

    private boolean checkMapRules() {
        boolean result = true;
        if (this.maprules == null) {
            return false;
        }
        int nrOfMappingRules = this.maprules.size();
        this.log.debug("Number of Mapping rules = " + nrOfMappingRules);
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>(this.maprules.values());
        Iterator<MappingRule> scan = rules.iterator();
        boolean check = false;
        while (scan.hasNext()) {
            MappingRule rule = scan.next();
            String mappedVFS = rule.getMappedFS().getAliasName();
            check = this.vfss.containsKey(mappedVFS);
            if (check) continue;
            this.log.error("ERROR in NAMESPACE - MAP RULE '" + rule.getRuleName() + "' point a UNKNOWN VFS '" + mappedVFS + "'!");
            result = false;
        }
        return result;
    }

    private boolean checkAppRules() {
        boolean result = true;
        if (this.apprules == null) {
            return false;
        }
        int nrOfApproachableRules = this.apprules.size();
        this.log.debug("Number of Approachable rules = " + nrOfApproachableRules);
        ArrayList<ApproachableRule> rules = new ArrayList<ApproachableRule>(this.apprules.values());
        Iterator<ApproachableRule> scan = rules.iterator();
        boolean check = false;
        while (scan.hasNext()) {
            ApproachableRule rule = scan.next();
            ArrayList<VirtualFSInterface> approachVFSs = new ArrayList<VirtualFSInterface>(rule.getApproachableVFS());
            for (VirtualFSInterface aVfs : approachVFSs) {
                check = this.vfss.containsKey(aVfs.getAliasName());
                if (check) continue;
                this.log.error("ERROR in NAMESPACE - APP RULE '" + rule.getRuleName() + "' point a UNKNOWN VFS '" + aVfs + "'!");
                result = false;
            }
        }
        return result;
    }
}

