/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace;

import it.grid.storm.balancer.BalancingStrategy;
import it.grid.storm.balancer.Node;
import it.grid.storm.filesystem.Filesystem;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.filesystem.swig.genericfs;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.DefaultValuesInterface;
import it.grid.storm.namespace.ExpiredSpaceTokenException;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.PropertyInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.model.ApproachableRule;
import it.grid.storm.namespace.model.MappingRule;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.model.SAAuthzType;
import it.grid.storm.namespace.model.StoRIType;
import it.grid.storm.namespace.model.StorageClassType;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import java.util.List;

public interface VirtualFSInterface {
    public String getFSType() throws NamespaceException;

    public String getSpaceTokenDescription() throws NamespaceException;

    public StorageClassType getStorageClassType();

    public String getRootPath() throws NamespaceException;

    public StoRI getRoot() throws NamespaceException;

    public String getAliasName();

    public Class getFSDriver() throws NamespaceException;

    public genericfs getFSDriverInstance() throws NamespaceException;

    public Filesystem getFilesystem() throws NamespaceException;

    public Class getSpaceSystemDriver() throws NamespaceException;

    public SpaceSystem getSpaceSystemDriverInstance() throws NamespaceException;

    public boolean isApproachableByUser(GridUserInterface var1);

    public DefaultValuesInterface getDefaultValues();

    public CapabilityInterface getCapabilities();

    public PropertyInterface getProperties();

    public List<MappingRule> getMappingRules() throws NamespaceException;

    public List<ApproachableRule> getApproachableRules() throws NamespaceException;

    public TSizeInBytes getUsedNearlineSpace() throws NamespaceException;

    public TSizeInBytes getUsedOnlineSpace() throws NamespaceException;

    public TSizeInBytes getAvailableOnlineSpace() throws NamespaceException;

    public TSizeInBytes getAvailableNearlineSpace() throws NamespaceException;

    public StoRI createFile(String var1) throws NamespaceException;

    public StoRI createFile(String var1, StoRIType var2);

    public void makeSilhouetteForFile(StoRI var1, TSizeInBytes var2) throws NamespaceException;

    public void useSpaceForFile(TSpaceToken var1, StoRI var2, TSizeInBytes var3) throws ExpiredSpaceTokenException, NamespaceException;

    public void useAllSpaceForFile(TSpaceToken var1, StoRI var2) throws ExpiredSpaceTokenException, NamespaceException;

    public StoRI createSpace(String var1, long var2, long var4) throws NamespaceException;

    public StoRI createSpace(String var1, long var2) throws NamespaceException;

    public StoRI createSpace(long var1, long var3) throws NamespaceException;

    public StoRI createSpace(long var1) throws NamespaceException;

    public StoRI createSpace() throws NamespaceException;

    public TSizeInBytes splitSpace(StoRI var1, StoRI var2, long var3) throws NamespaceException;

    public StorageSpaceData getSpaceByAlias(String var1) throws NamespaceException;

    public void storeSpaceByToken(StorageSpaceData var1) throws NamespaceException;

    public StoRI createDefaultStoRI() throws NamespaceException;

    public long getCreationTime();

    public TSpaceToken getSpaceToken() throws NamespaceException;

    public SAAuthzType getStorageAreaAuthzType() throws NamespaceException;

    public String getStorageAreaAuthzDB() throws NamespaceException;

    public String getStorageAreaAuthzFixed() throws NamespaceException;

    public boolean isPoolDefined(Protocol var1) throws NamespaceException;

    public BalancingStrategy<? extends Node> getProtocolBalancingStrategy(Protocol var1);

    public boolean isApproachableByAnonymous();

    public boolean isHttpWorldReadable();
}

