/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace;

import it.grid.storm.config.Configuration;
import it.grid.storm.namespace.NamespaceDirector;
import java.io.File;
import java.io.IOException;
import org.apache.xerces.parsers.SAXParser;
import org.slf4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class NamespaceValidator {
    private static String schemaURL;
    private static String namespaceFile;
    private Logger log = NamespaceDirector.getLogger();

    public NamespaceValidator() {
        String configPath = System.getProperty("user.dir") + File.separator + "etc" + File.separator;
        schemaURL = configPath + "namespace.xsd";
        namespaceFile = configPath + Configuration.getInstance().getNamespaceConfigFilename();
    }

    public boolean validateSchema(String SchemaUrl, String XmlDocumentUrl) {
        boolean valid = false;
        SAXParser parser = new SAXParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)SchemaUrl);
            Validator handler = new Validator();
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(XmlDocumentUrl);
            if (handler.validationError) {
                this.manageErrorWithinNamespace(handler);
            } else {
                this.log.info("Namespace Document is valid with Schema");
                valid = true;
            }
        }
        catch (IOException ioe) {
            this.log.error("IOException" + ioe.getMessage());
        }
        catch (SAXException e) {
            this.log.error("SAXException" + e.getMessage());
        }
        return valid;
    }

    private void manageErrorWithinNamespace(Validator handler) {
        StringBuffer sb = new StringBuffer();
        sb.append("##############################################\n");
        System.out.println();
        sb.append("###   WARNING :  namespace.xml   INVALID   ###\n");
        sb.append("##############################################\n");
        sb.append("# Please check it. \n");
        sb.append("# The error is : " + handler.saxParseException.getMessage() + "\n");
        sb.append("#   at line : " + handler.saxParseException.getLineNumber() + ", column " + handler.saxParseException.getColumnNumber() + "\n");
        sb.append("#   in entity : " + handler.saxParseException.getSystemId() + "\n");
        sb.append("##############################################\n");
        System.out.println(sb.toString());
        this.log.error(sb.toString());
    }

    private class Validator
    extends DefaultHandler {
        public boolean validationError = false;
        public SAXParseException saxParseException = null;

        private Validator() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            NamespaceValidator.this.log.error("ERROR : " + exception.getMessage());
            NamespaceValidator.this.log.error(" at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber());
            NamespaceValidator.this.log.error(" in entity " + exception.getSystemId());
            this.validationError = true;
            this.saxParseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            NamespaceValidator.this.log.error("FATAL ERROR: " + exception.getMessage());
            NamespaceValidator.this.log.error(" at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber());
            NamespaceValidator.this.log.error(" in entity " + exception.getSystemId());
            this.validationError = true;
            this.saxParseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            NamespaceValidator.this.log.error("Warning: " + exception.getMessage());
            NamespaceValidator.this.log.error(" at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber());
            NamespaceValidator.this.log.error(" in entity " + exception.getSystemId());
        }
    }
}

