/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.logging;

import ch.qos.logback.classic.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoRMLoggers {
    private static Logger bookkeepingLogger;
    private static Logger heartbeatLogger;
    private static Logger performanceLogger;
    private static Logger stdoutLogger;
    private static Logger stderrLogger;
    private static boolean initDone;

    private static void initLoggers() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        bookkeepingLogger = loggerContext.getLogger("bookkeeping");
        heartbeatLogger = loggerContext.getLogger("health");
        performanceLogger = loggerContext.getLogger("performance");
        stdoutLogger = loggerContext.getLogger("system.out");
        stderrLogger = loggerContext.getLogger("system.err");
    }

    public static Logger getBKLogger() {
        if (!initDone) {
            StoRMLoggers.initLoggers();
        }
        return bookkeepingLogger;
    }

    public static Logger getHBLogger() {
        if (!initDone) {
            StoRMLoggers.initLoggers();
        }
        return heartbeatLogger;
    }

    public static Logger getPerfLogger() {
        if (!initDone) {
            StoRMLoggers.initLoggers();
        }
        return performanceLogger;
    }

    public static Logger getStdoutLogger() {
        if (!initDone) {
            StoRMLoggers.initLoggers();
        }
        return stdoutLogger;
    }

    public static Logger getStderrLogger() {
        if (!initDone) {
            StoRMLoggers.initLoggers();
        }
        return stderrLogger;
    }

    static {
        initDone = false;
    }
}

