/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info.remote.resources;

import com.sun.jersey.server.impl.ResponseBuilderImpl;
import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.info.SpaceInfoManager;
import it.grid.storm.info.model.SpaceStatusSummary;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.space.quota.BackgroundGPFSQuota;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/info/status")
public class SpaceStatusResource {
    private static final Logger log = LoggerFactory.getLogger(SpaceStatusResource.class);
    private static final ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{alias}")
    public String getStatusSummary(@PathParam(value="alias") String saAlias) {
        SpaceStatusSummary saSum;
        String result = "";
        log.debug("Received call getStatusSummary for SA '" + saAlias + "'");
        int quotaDefined = SpaceInfoManager.getInstance().getQuotasDefined();
        if (quotaDefined > 0) {
            BackgroundGPFSQuota.getInstance().submitGPFSQuota();
            log.info("Submitted an asynchronous GPFS Quota job");
        }
        try {
            saSum = SpaceStatusSummary.createFromDB(saAlias);
        }
        catch (IllegalArgumentException e) {
            log.info("Unable to load requested space status summary from database. IllegalArgumentException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.NOT_FOUND);
            responseBuilder.entity((Object)"Unable to load requested space status info from database");
            throw new WebApplicationException(responseBuilder.build());
        }
        result = saSum.getJsonFormat();
        return result;
    }

    @PUT
    @Path(value="/{alias}/update")
    @Consumes(value={"text/plain"})
    public void putStatusSummary(@PathParam(value="alias") String saAlias, @QueryParam(value="total") Long totalSpace, @QueryParam(value="used") Long usedSpace, @QueryParam(value="reserved") Long reservedSpace, @QueryParam(value="unavailable") Long unavailableSpace) throws WebApplicationException {
        String saAliasDecoded;
        try {
            saAliasDecoded = URLDecoder.decode(saAlias.trim(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode parameters. UnsupportedEncodingException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to decode paramethesr, unsupported encoding 'UTF-8'");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.debug("Decoded saAlias = " + saAliasDecoded);
        if (saAliasDecoded == null || saAliasDecoded.equals("") || totalSpace != null && (usedSpace == null || reservedSpace == null || unavailableSpace == null)) {
            log.error("Unable to update space alias status. Some parameters are missing : saAlias " + saAliasDecoded + " totalSpace " + totalSpace + " usedSpace " + usedSpace + " reservedSpace " + reservedSpace + " unavailableSpace " + unavailableSpace);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to evaluate permissions. Some parameters are missing");
            throw new WebApplicationException(responseBuilder.build());
        }
        if (totalSpace != null && totalSpace < 0L || usedSpace != null && usedSpace < 0L || reservedSpace != null && reservedSpace < 0L || unavailableSpace != null && unavailableSpace < 0L) {
            log.error("Unable to update space alias status. Some size parameters are lower than zero : totalSpace " + totalSpace + " usedSpace " + usedSpace + " reservedSpace " + reservedSpace + " unavailableSpace " + unavailableSpace);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to evaluate permissions. Some size parameters are lower than zero");
            throw new WebApplicationException(responseBuilder.build());
        }
        StorageSpaceData storageSpaceData = catalog.getStorageSpaceByAlias(saAliasDecoded);
        if (storageSpaceData == null) {
            log.error("The storage space with alias '" + saAliasDecoded + "' is not on StoRM Database");
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.NOT_FOUND);
            responseBuilder.entity((Object)"Unable to update space alias status. Some parameters are not well formed");
            throw new WebApplicationException(responseBuilder.build());
        }
        SpaceStatusSummary spaceStatusSummary = totalSpace != null ? new SpaceStatusSummary(saAlias, totalSpace) : new SpaceStatusSummary(saAlias, storageSpaceData.getTotalSpaceSize().value());
        if (usedSpace != null) {
            spaceStatusSummary.setUsedSpace(usedSpace);
        }
        if (reservedSpace != null) {
            spaceStatusSummary.setReservedSpace(reservedSpace);
        }
        if (unavailableSpace != null) {
            spaceStatusSummary.setUnavailableSpace(unavailableSpace);
        }
        try {
            this.updateSASummary(storageSpaceData, spaceStatusSummary, totalSpace != null);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to update storage space '" + saAliasDecoded + "' with the provided space values. IllegalArgumentException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to update space alias status. Some parameters are not valid");
            throw new WebApplicationException(responseBuilder.build());
        }
    }

    private void updateSASummary(StorageSpaceData storageSpaceData, SpaceStatusSummary spaceStatusSummary, boolean updateTotalSpace) throws IllegalArgumentException {
        try {
            if (updateTotalSpace && spaceStatusSummary.getTotalSpace() >= 0L) {
                storageSpaceData.setTotalSpaceSize(TSizeInBytes.make(spaceStatusSummary.getTotalSpace(), SizeUnit.BYTES));
            }
            if (spaceStatusSummary.getUsedSpace() >= 0L) {
                storageSpaceData.setUsedSpaceSize(TSizeInBytes.make(spaceStatusSummary.getUsedSpace(), SizeUnit.BYTES));
            }
            if (spaceStatusSummary.getReservedSpace() >= 0L) {
                storageSpaceData.setReservedSpaceSize(TSizeInBytes.make(spaceStatusSummary.getReservedSpace(), SizeUnit.BYTES));
            }
            if (spaceStatusSummary.getUnavailableSpace() >= 0L) {
                storageSpaceData.setUnavailableSpaceSize(TSizeInBytes.make(spaceStatusSummary.getUnavailableSpace(), SizeUnit.BYTES));
            }
        }
        catch (InvalidTSizeAttributesException e) {
            throw new IllegalArgumentException("Unable to produce the TSizeInBytes object for some of the SpaceStatusSummary fields:" + spaceStatusSummary.toString());
        }
        catalog.updateStorageSpace(storageSpaceData);
    }
}

