/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.concurrency.NamedThread;
import it.grid.storm.concurrency.NamedThreadFactory;
import it.grid.storm.info.SAInfoException;
import it.grid.storm.info.SpaceInfoManager;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.DUResult;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogUpdater.class);
    private final ExecutorService saver = Executors.newFixedThreadPool(1, new NamedThreadFactory("CatalogSaver"));
    private static final ReservedSpaceCatalog spaceCatalog = new ReservedSpaceCatalog();

    public Future<?> saveData(TSpaceToken token, DUResult duResult) throws SAInfoException {
        Future<?> saverFuture = null;
        try {
            saverFuture = this.saver.submit(new NamedThread(new SaveSA(token, duResult), "SaverThread"));
        }
        catch (RejectedExecutionException rej) {
            LOG.error("Unable to start Saver tasks." + rej.getMessage());
        }
        return saverFuture;
    }

    public void stopSaver() {
        try {
            this.shutdown(false, 1000L);
        }
        catch (InterruptedException ex) {
            LOG.debug("DU Info SAVER is interrupted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean interrupt, long waitMillis) throws InterruptedException {
        if (interrupt) {
            LOG.debug("Tasks killed: " + this.saver.shutdownNow().size());
        } else {
            this.saver.shutdown();
        }
        try {
            this.saver.awaitTermination(waitMillis, TimeUnit.MILLISECONDS);
        }
        finally {
            LOG.debug("Tasks killed: " + this.saver.shutdownNow().size());
        }
        LOG.debug("SAVER is terminated? : " + this.saver.isTerminated());
    }

    private class SaveSA
    implements Runnable {
        private DUResult duResult;
        private TSpaceToken sT;

        public SaveSA(TSpaceToken spaceToken, DUResult duResult) {
            this.duResult = duResult;
            this.sT = spaceToken;
        }

        @Override
        public void run() {
            LOG.debug("Saving info into DB... ");
            StorageSpaceData ssd = null;
            if (SpaceInfoManager.getInstance().testMode.get()) {
                ssd = new StorageSpaceData();
                try {
                    PFN spaceFN = PFN.make(this.duResult.getAbsRootPath());
                    ssd.setSpaceToken(this.sT);
                    ssd.setSpaceFileName(spaceFN);
                }
                catch (InvalidPFNAttributeException e) {
                    LOG.error("Unable to create PFN. " + e);
                }
            } else {
                try {
                    ssd = spaceCatalog.getStorageSpace(this.sT);
                }
                catch (TransferObjectDecodingException e) {
                    LOG.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
                }
                catch (DataAccessException e) {
                    LOG.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
                }
            }
            long usedSize = this.duResult.getSize();
            try {
                TSizeInBytes us = TSizeInBytes.make(usedSize, SizeUnit.BYTES);
                ssd.setUsedSpaceSize(us);
            }
            catch (InvalidTSizeAttributesException e) {
                LOG.error("Negative size?");
            }
            if (SpaceInfoManager.getInstance().testMode.get()) {
                LOG.debug("Saved SSD info into the DB ");
            } else {
                spaceCatalog.updateStorageSpace(ssd);
            }
            SpaceInfoManager.getInstance().savedSA(this.duResult);
            LOG.debug(String.format("DU info of %s is saved into DB.", this.duResult.getAbsRootPath()));
        }
    }
}

