/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health.external;

import it.grid.storm.health.HealthDirector;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class FSMetadataStatus {
    private String pulseNumberStr = "";
    private long lifetime = -1L;
    private String lifetimeStr = "";
    private final int benchmarkCount = -1;
    private final Hashtable<String, Long> pathName = new Hashtable();

    public FSMetadataStatus(ArrayList<String> storageAreasName) {
        this.pathName.put("Local", -1L);
        for (String element : storageAreasName) {
            this.pathName.put(element, -1L);
        }
    }

    public void setPulseNumber(long number) {
        this.pulseNumberStr = number + "";
        String prefix = "";
        for (int i = 0; i < 6 - this.pulseNumberStr.length(); ++i) {
            prefix = prefix + ".";
        }
        this.pulseNumberStr = prefix + this.pulseNumberStr;
    }

    public void calculateLifeTime() {
        long bornTime = HealthDirector.getBornInstant();
        long now = System.currentTimeMillis();
        this.lifetime = now - bornTime;
        Date date = new Date(this.lifetime);
        SimpleDateFormat formatter = new SimpleDateFormat("mm.ss");
        String minsec = formatter.format(date);
        long hours = this.lifetime / 3600000L;
        this.lifetimeStr = hours + ":" + minsec;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" [#" + this.pulseNumberStr + " lifetime=" + this.lifetimeStr + "]");
        Enumeration<String> sas = this.pathName.keys();
        while (sas.hasMoreElements()) {
            String sa = sas.nextElement();
            Long average = this.pathName.get(sa);
            result.append("SA('" + sa + "')=" + average);
        }
        return result.toString();
    }
}

