/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.OperationType;
import java.util.ArrayList;

public enum OperationTypeCategory {
    ASYNCH("ASYNCH", new ArrayList<OperationType>(){
        private static final long serialVersionUID = 3641598296676643733L;
        {
            this.add(OperationType.BOL);
            this.add(OperationType.COPY);
            this.add(OperationType.PTG);
            this.add(OperationType.PTP);
        }
    }),
    PURESYNCH("PURESYNCH", new ArrayList<OperationType>(){
        private static final long serialVersionUID = -6608417863091343037L;
        {
            this.add(OperationType.PNG);
        }
    }),
    SYNCH_DB("SYNCH_DB", new ArrayList<OperationType>(){
        private static final long serialVersionUID = 5028836664777062718L;
        {
            this.add(OperationType.EFL);
            this.add(OperationType.GST);
            this.add(OperationType.RSP);
            this.add(OperationType.SPTG);
            this.add(OperationType.SPTP);
        }
    }),
    SYNCH_FS("SYNCH_FS", new ArrayList<OperationType>(){
        private static final long serialVersionUID = -5750075706467406539L;
        {
            this.add(OperationType.MKD);
            this.add(OperationType.MV);
            this.add(OperationType.RM);
            this.add(OperationType.RMD);
        }
    }),
    SYNCH_FS_DB("SYNCH_FS_DB", new ArrayList<OperationType>(){
        private static final long serialVersionUID = 6155834878615823037L;
        {
            this.add(OperationType.AF);
            this.add(OperationType.AR);
            this.add(OperationType.GSM);
            this.add(OperationType.LS);
            this.add(OperationType.PD);
            this.add(OperationType.RF);
            this.add(OperationType.RS);
        }
    }),
    UNKNOWN("UNKNOWN", new ArrayList<OperationType>(){
        private static final long serialVersionUID = -3529992869598284560L;
        {
            this.add(OperationType.UNDEF);
        }
    });

    private ArrayList<OperationType> opTypeList;
    private String acronym;

    private OperationTypeCategory(String acronym, ArrayList<OperationType> opTypeList) {
        this.opTypeList = opTypeList;
        this.acronym = acronym;
    }

    public boolean contains(OperationType op) {
        boolean result = false;
        if (this.opTypeList.contains(op)) {
            result = true;
        }
        return result;
    }

    public OperationTypeCategory getCategory(OperationType opType) {
        if (ASYNCH.contains(opType)) {
            return ASYNCH;
        }
        if (PURESYNCH.contains(opType)) {
            return PURESYNCH;
        }
        if (SYNCH_DB.contains(opType)) {
            return SYNCH_DB;
        }
        if (SYNCH_FS.contains(opType)) {
            return SYNCH_FS;
        }
        if (SYNCH_FS_DB.contains(opType)) {
            return SYNCH_FS_DB;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.acronym;
    }
}

