/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.OperationType;
import it.grid.storm.srm.types.TSURL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class LogEvent
implements Delayed {
    private static long THOUSAND = 1000L;
    public final long birthTime;
    public final long deathTime;
    private long timeToLive = 60000L;
    private OperationType opType = null;
    private String userDN = null;
    private String surl = null;
    private long startTime = -1L;
    private String startTimeStr = null;
    private long duration = -1L;
    private String requestToken = null;
    private boolean successResult = false;

    public LogEvent(OperationType opType, String userDN, String surl, long startTime, long duration, String requestToken, boolean successResult) {
        this.opType = opType;
        this.userDN = userDN;
        this.surl = surl;
        this.startTime = startTime;
        this.duration = duration;
        this.requestToken = requestToken;
        Date date = new Date(startTime);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss,SSS");
        this.startTimeStr = formatter.format(date);
        this.successResult = successResult;
        this.timeToLive = HealthDirector.timeToLiveLogEventInSec;
        this.deathTime = System.currentTimeMillis() + (long)HealthDirector.timeToLiveLogEventInSec * THOUSAND;
        this.birthTime = System.currentTimeMillis();
    }

    public LogEvent(OperationType opType, String userDN, long startTime, long duration, boolean successResult) {
        this.opType = opType;
        this.userDN = userDN;
        this.surl = TSURL.makeEmpty().toString();
        this.startTime = startTime;
        this.duration = TimeUnit.MICROSECONDS.convert(duration, TimeUnit.NANOSECONDS);
        this.requestToken = "SYNCH";
        Date date = new Date(startTime);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss,SSS");
        this.startTimeStr = formatter.format(date);
        this.successResult = successResult;
        this.timeToLive = HealthDirector.timeToLiveLogEventInSec;
        this.deathTime = System.currentTimeMillis() + this.timeToLive * THOUSAND;
        this.birthTime = System.currentTimeMillis();
        HealthDirector.LOGGER.debug("Event TTL (milliSec): " + this.timeToLive);
    }

    public LogEvent(OperationType opType, String userDN, String surl, long startTime, long duration, boolean successResult) {
        this.opType = opType;
        this.userDN = userDN;
        this.surl = surl;
        this.startTime = startTime;
        this.duration = TimeUnit.MICROSECONDS.convert(duration, TimeUnit.NANOSECONDS);
        this.requestToken = "SYNCH";
        Date date = new Date(startTime);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss,SSS");
        this.startTimeStr = formatter.format(date);
        this.successResult = successResult;
        this.timeToLive = HealthDirector.timeToLiveLogEventInSec;
        this.deathTime = System.currentTimeMillis() + this.timeToLive * THOUSAND;
        this.birthTime = System.currentTimeMillis();
        HealthDirector.LOGGER.debug("Event TTL (milliSec): " + this.timeToLive);
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    public String getDN() {
        return this.userDN;
    }

    public String getSURL() {
        return this.surl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStartTimeString() {
        return this.startTimeStr;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getRequestToken() {
        return this.requestToken;
    }

    public boolean isSuccess() {
        return this.successResult;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int fieldSeparator = 9;
        sb.append(this.userDN).append('\t');
        sb.append(this.opType.toString()).append('\t');
        sb.append((Object)this.opType.getOperationTypeCategory()).append('\t');
        if (this.successResult) {
            sb.append("-OK-").append('\t');
        } else {
            sb.append("#ko#").append('\t');
        }
        sb.append(this.surl).append('\t');
        sb.append(this.startTimeStr).append('\t');
        sb.append(this.duration).append('\t');
        sb.append(this.requestToken).append('\t');
        return sb.toString();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long result = -1L;
        result = unit.convert(this.deathTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        HealthDirector.LOGGER.debug("Event TimeToLive : " + this.timeToLive + " ... remaining : " + result);
        return result;
    }

    @Override
    public int compareTo(Delayed other) {
        LogEvent otherEvent = (LogEvent)other;
        if (this.deathTime < otherEvent.deathTime) {
            return -1;
        }
        if (this.deathTime > otherEvent.deathTime) {
            return 1;
        }
        return 0;
    }
}

