/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.BookKeeper;
import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.Hearthbeat;
import it.grid.storm.health.PerformanceBookKeeper;
import it.grid.storm.health.PerformancePulse;
import it.grid.storm.health.SimpleBookKeeper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;

public class HealthMonitor {
    private Logger HEARTLOG = HealthDirector.HEARTLOG;
    private Logger PERFLOG = HealthDirector.getPerformanceLogger();
    private Timer healthTimer = new Timer();
    private Hashtable<String, BookKeeper> bookKeepers;
    public static int perfGlanceTimeInterval = 15;

    public HealthMonitor(int delay, int period) {
        this.heartbeat(delay * 1000, period * 1000);
        this.bookKeepers = new Hashtable();
        this.bookKeepers.put("BK", new SimpleBookKeeper());
        this.HEARTLOG.info("HEART MONITOR Initialized");
    }

    public void initializePerformanceMonitor(int logTimeInterval, int defaultGlangeTimeInterval) {
        if (defaultGlangeTimeInterval > logTimeInterval) {
            HealthDirector.getPerformanceLogger().warn("WARNING: Log Book has the time interval lower than Glance time interval!");
        }
        PerformanceBookKeeper pbk = new PerformanceBookKeeper(logTimeInterval, defaultGlangeTimeInterval);
        this.bookKeepers.put("PERF", pbk);
        long pulseTimeInterval = pbk.getGlanceWindowInMSec();
        this.healthTimer.scheduleAtFixedRate((TimerTask)new PerformancePulse(), 0L, pulseTimeInterval);
        this.PERFLOG.info("Set PERFORMANCE MONITOR in Timer Task (PERIOD:" + perfGlanceTimeInterval + ")");
        this.PERFLOG.info("--- PERFORMANCE MONITOR Initialized");
    }

    public ArrayList<BookKeeper> getBookKeepers() {
        return new ArrayList<BookKeeper>(this.bookKeepers.values());
    }

    public PerformanceBookKeeper getPerformanceBookKeeper() {
        if (this.bookKeepers.containsKey("PERF")) {
            return (PerformanceBookKeeper)this.bookKeepers.get("PERF");
        }
        return null;
    }

    public SimpleBookKeeper getSimpleBookKeeper() {
        if (this.bookKeepers.containsKey("BK")) {
            return (SimpleBookKeeper)this.bookKeepers.get("BK");
        }
        return null;
    }

    public void heartbeat(int delay, int period) {
        this.healthTimer.scheduleAtFixedRate((TimerTask)new Hearthbeat(), delay, (long)period);
        this.HEARTLOG.info("Set HEARTHBEAT in Timer Task (DELAY:" + delay + " PERIOD:" + period + ")");
    }
}

