/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.common.types.VO;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.GridUser;
import it.grid.storm.griduser.MapperInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class VomsGridUser
extends GridUser
implements Serializable {
    private static final long serialVersionUID = -117007717079470189L;
    private List<FQAN> fqans = new ArrayList<FQAN>();
    private List<String> fqansString = new ArrayList<String>();

    VomsGridUser(MapperInterface mapper, String distinguishedName, String proxy, FQAN[] fqansArray) throws IllegalArgumentException {
        super(mapper, distinguishedName, proxy);
        if (fqansArray == null || fqansArray.length == 0) {
            log.error("Unable to create VomsGridUser. Inavlid fqansArray argument: " + fqansArray);
            throw new IllegalArgumentException("Unable to create VomsGridUser. Inavlid fqansArray argument: " + fqansArray);
        }
        this.setFqans(fqansArray);
    }

    VomsGridUser(MapperInterface mapper, String distinguishedName, FQAN[] fqansArray) throws IllegalArgumentException {
        super(mapper, distinguishedName);
        if (fqansArray == null || fqansArray.length == 0) {
            log.error("Unable to create VomsGridUser. Inavlid fqansArray argument: " + fqansArray);
            throw new IllegalArgumentException("Unable to create VomsGridUser. Inavlid fqansArray argument: " + fqansArray);
        }
        this.setFqans(fqansArray);
    }

    private void setFqans(FQAN[] fqans) {
        this.fqans.clear();
        this.fqansString.clear();
        for (FQAN fqan : fqans) {
            this.fqans.add(fqan);
            this.fqansString.add(fqan.toString());
        }
    }

    public void addFqan(FQAN fqan) {
        this.fqans.add(fqan);
        this.fqansString.add(fqan.toString());
    }

    @Override
    public boolean hasVoms() {
        return true;
    }

    @Override
    public FQAN[] getFQANs() {
        FQAN[] FQANs = null;
        if (this.fqans != null) {
            FQANs = this.fqans.toArray(new FQAN[this.fqans.size()]);
        }
        return FQANs;
    }

    @Override
    public String[] getFQANsAsString() {
        String[] FQANs = null;
        if (this.fqansString != null) {
            FQANs = this.fqansString.toArray(new String[this.fqansString.size()]);
        }
        return FQANs;
    }

    @Override
    public VO getVO() {
        VO result = VO.makeNoVo();
        if (this.fqans != null && this.fqans.size() > 0) {
            FQAN firstFQAN = this.fqans.get(0);
            String voName = firstFQAN.getVo();
            result = VO.make(voName);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Grid User (VOMS) = ");
        sb.append(" DN:'" + this.getDistinguishedName().getX500DN_rfc1779() + "'");
        sb.append(" FQANS:" + this.fqans);
        return sb.toString();
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.subjectDN.hashCode();
        for (FQAN fqan : this.fqans) {
            result += 37 * fqan.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof VomsGridUser) {
            VomsGridUser other = (VomsGridUser)obj;
            if (!other.hasVoms()) {
                result = this.getDistinguishedName().equals(other.getDistinguishedName());
            } else if (this.getDistinguishedName().equals(other.getDistinguishedName())) {
                FQAN[] thisFQANs;
                FQAN[] otherFQANs = other.getFQANs();
                if (otherFQANs.length == (thisFQANs = this.getFQANs()).length) {
                    result = true;
                    for (int i = 0; i < otherFQANs.length; ++i) {
                        if (otherFQANs[i].equals(thisFQANs[i])) continue;
                        result = false;
                        break;
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

