/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.griduser.MapperInterface;
import it.grid.storm.jna.lcmaps.StormLcmapsLibrary;
import java.nio.IntBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormLcmapsJNAMapper
implements MapperInterface {
    private static final Logger log = LoggerFactory.getLogger(StormLcmapsJNAMapper.class);
    private final Object lock = new Object();
    private final String LCMAPS_DEFAULT_LOG_FILE = "/var/log/lcmaps.log";
    private final String LCMAPS_LOG_FILE_PATH_ENV_VARIABLE = "LCMAPS_LOG_FILE";
    private static final StormLcmapsJNAMapper instance = new StormLcmapsJNAMapper();

    private StormLcmapsJNAMapper() {
    }

    public static StormLcmapsJNAMapper getInstance() {
        return instance;
    }

    private String getLcmapsLogFile() {
        String lcmapsLogFile = System.getenv("LCMAPS_LOG_FILE");
        if (lcmapsLogFile == null) {
            lcmapsLogFile = "/var/log/lcmaps.log";
        }
        return lcmapsLogFile.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalUser map(String dn, String[] fqans) throws CannotMapUserException {
        int retVal;
        IntBuffer userId = IntBuffer.allocate(1);
        IntBuffer groupId = IntBuffer.allocate(1);
        Object object = this.lock;
        synchronized (object) {
            retVal = StormLcmapsLibrary.INSTANCE.map_user(this.getLcmapsLogFile(), dn, fqans, 1, userId, groupId);
        }
        if (retVal != 0) {
            StormLcmapsLibrary.Errors error2 = StormLcmapsLibrary.Errors.getError(retVal);
            if (!error2.equals((Object)StormLcmapsLibrary.Errors.UNKNOW_ERROR)) {
                log.error("Unable to call successfully native map_user() method. Return value is " + error2.toString());
            } else {
                log.error("Unable to call successfully native map_user() method. Return value is " + retVal + " . This is an unknown return value");
            }
            throw new CannotMapUserException("LCMAPS error, cannot map user credentials to local user.");
        }
        LocalUser localUser = new LocalUser(userId.get(), new int[]{groupId.get()}, 1L);
        return localUser;
    }
}

