/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.GridUserFactory;
import it.grid.storm.griduser.GridUserInterface;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridUserManager {
    static final Logger log = LoggerFactory.getLogger(GridUserManager.class);
    static Configuration config = Configuration.getInstance();
    static GridUserFactory userFactory = null;

    private GridUserManager() {
    }

    private static GridUserFactory initializeFactory() {
        return GridUserFactory.getInstance();
    }

    public static String getMapperClassName() {
        return config.getGridUserMapperClassname();
    }

    public static GridUserInterface makeVOMSGridUser(String dn, String proxy, FQAN[] fqans) throws IllegalArgumentException {
        if (proxy == null || dn == null || fqans == null || fqans.length == 0) {
            log.error("Unable to make VomsGridUser. Inavlid arguments: dn='" + dn + "' fqans='" + fqans + "' proxy='" + proxy + "'");
            throw new IllegalArgumentException("Unable to make VomsGridUser. Inavlid arguments: dn='" + dn + "' fqans='" + fqans + "' proxy='" + proxy + "'");
        }
        GridUserInterface gridUser = null;
        try {
            gridUser = userFactory.createGridUser(dn, fqans, proxy);
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
        }
        return gridUser;
    }

    public static GridUserInterface makeVOMSGridUser(String dn, String vo) throws IllegalArgumentException {
        if (vo == null || dn == null) {
            log.error("Unable to make VomsGridUser. Inavlid arguments: dn='" + dn + "' vo='" + vo + "'");
            throw new IllegalArgumentException("Unable to make VomsGridUser. Inavlid arguments: dn='" + dn + "' vo='" + vo + "'");
        }
        GridUserInterface gridUser = null;
        FQAN[] fqans = new FQAN[]{FQAN.makeVoFQAN(vo)};
        try {
            gridUser = userFactory.createGridUser(dn, fqans);
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
        }
        return gridUser;
    }

    public static GridUserInterface makeVOMSGridUser(String dn, String[] fqansString) throws IllegalArgumentException {
        if (fqansString == null || fqansString.length == 0) {
            log.error("Unable to make VomsGridUser. Invalid fqansString argument: " + fqansString);
            throw new IllegalArgumentException("Unable to make VomsGridUser. Invalid fqansString argument: " + fqansString);
        }
        FQAN[] fqans = new FQAN[fqansString.length];
        for (int i = 0; i < fqansString.length; ++i) {
            fqans[i] = new FQAN(fqansString[i]);
        }
        return userFactory.createGridUser(dn, fqans);
    }

    public static GridUserInterface makeVOMSGridUser(String dn, FQAN[] fqans) throws IllegalArgumentException {
        if (fqans == null || fqans.length == 0) {
            log.error("Unable to make VomsGridUser. Invalid fqans argument: " + fqans);
            throw new IllegalArgumentException("Unable to make VomsGridUser. Invalid fqans argument: " + fqans);
        }
        return userFactory.createGridUser(dn, fqans);
    }

    public static GridUserInterface makeGridUser(String dn) {
        return userFactory.createGridUser(dn);
    }

    public static GridUserInterface makeGridUser(String dn, String proxy) {
        return userFactory.createGridUser(dn, proxy);
    }

    public static GridUserInterface makeSAGridUser() {
        GridUserInterface result = null;
        String dn = "/DC=it/DC=infngrid/OU=Services/CN=storm";
        result = userFactory.createGridUser(dn);
        return result;
    }

    public static GridUserInterface decode(Map inputParam) {
        return userFactory.decode(inputParam);
    }

    static {
        log.debug("Inizializating Grid User Director...");
        userFactory = GridUserManager.initializeFactory();
    }
}

