/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.GridUser;
import it.grid.storm.griduser.GridUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.griduser.MapperInterface;
import it.grid.storm.griduser.VomsGridUser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class GridUserFactory {
    private static final Logger log = GridUserManager.log;
    private MapperInterface defaultMapperClass = this.makeMapperClass(GridUserManager.getMapperClassName());
    private static GridUserFactory instance = null;

    protected static Logger getLogger() {
        return log;
    }

    private GridUserFactory() throws GridUserException {
    }

    static GridUserFactory getInstance() {
        if (instance == null) {
            try {
                instance = new GridUserFactory();
            }
            catch (GridUserException ex) {
                log.error("Unable to load GridUser Mapper Driver!", (Throwable)ex);
            }
        }
        return instance;
    }

    void setUserMapper(String mapperClassName) throws GridUserException {
        this.defaultMapperClass = this.makeMapperClass(mapperClassName);
    }

    GridUserInterface createGridUser(String distinguishName) {
        GridUser user = new GridUser(this.defaultMapperClass, distinguishName);
        log.debug("Created new Grid User (NO VOMS) : " + user);
        return user;
    }

    GridUserInterface createGridUser(String distinguishName, String proxyString) {
        GridUser user = new GridUser(this.defaultMapperClass, distinguishName, proxyString);
        log.debug("Created new Grid User (NO VOMS with PROXY) : " + user);
        return user;
    }

    GridUserInterface createGridUser(String distinguishName, FQAN[] fqans) throws IllegalArgumentException {
        VomsGridUser user = null;
        try {
            user = new VomsGridUser(this.defaultMapperClass, distinguishName, fqans);
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected error on VomsGridUser creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
            throw e;
        }
        log.debug("Created new Grid User (VOMS USER) : " + user);
        return user;
    }

    GridUserInterface createGridUser(String distinguishName, FQAN[] fqans, String proxyString) throws IllegalArgumentException {
        VomsGridUser user = null;
        try {
            user = new VomsGridUser(this.defaultMapperClass, distinguishName, proxyString, fqans);
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected error on VomsGridUser creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
            throw e;
        }
        log.debug("Created new Grid User (VOMS USER with PROXY) : " + user);
        return user;
    }

    GridUserInterface decode(Map inputParam) {
        String member_DN = new String("userDN");
        String member_Fqans = new String("userFQANS");
        String dnString = (String)inputParam.get(member_DN);
        List<Object> fqansList = null;
        try {
            fqansList = Arrays.asList((Object[])inputParam.get(member_Fqans));
        }
        catch (NullPointerException e) {
            log.debug("Empty FQAN[] found." + e);
        }
        FQAN[] fqans = null;
        if (fqansList != null) {
            fqans = new FQAN[fqansList.size()];
            log.debug("fqans_vector Size: " + fqansList.size());
            for (int i = 0; i < fqansList.size(); ++i) {
                FQAN fq;
                String fqan_string = (String)fqansList.get(i);
                log.debug("FQAN[" + i + "]:" + fqan_string);
                fqans[i] = fq = new FQAN(fqan_string);
            }
        }
        if (dnString != null) {
            log.debug("DN: " + dnString);
            if (fqans != null && fqans.length > 0) {
                log.debug("VomsGU with FQAN");
                try {
                    return this.createGridUser(dnString, fqans);
                }
                catch (IllegalArgumentException e) {
                    log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
                }
            } else {
                return this.createGridUser(dnString);
            }
        }
        return null;
    }

    MapperInterface makeMapperInstance(Class mapperClass) throws CannotMapUserException {
        MapperInterface mapperInstance = null;
        if (mapperClass == null) {
            throw new CannotMapUserException("Cannot build Mapper Driver instance without a valid Mapper Driver Class!");
        }
        if (!MapperInterface.class.isAssignableFrom(mapperClass)) {
            throw new CannotMapUserException("Unable to instantiate the Mapper Driver. The provided MapperClass does not implements MapperInterface");
        }
        try {
            mapperInstance = (MapperInterface)mapperClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            log.error("Unable to instantiate the Mapper Driver. Illegal Access.", (Throwable)ex);
            throw new CannotMapUserException("Unable to instantiate the Mapper Driver. Illegal Access.", ex);
        }
        catch (InstantiationException ex) {
            log.error("Unable to instantiate the Mapper Driver. Generic problem..", (Throwable)ex);
            throw new CannotMapUserException("Unable to instantiate the Mapper Driver. Generic problem..", ex);
        }
        return mapperInstance;
    }

    private MapperInterface makeMapperClass(String mapperClassName) throws GridUserException {
        MapperInterface mapper;
        block16: {
            mapper = null;
            Class<?> mapperClass = null;
            if (mapperClassName == null) {
                throw new GridUserException("Cannot load Mapper Driver without a valid Mapper Driver Class Name!");
            }
            try {
                mapperClass = Class.forName(mapperClassName);
            }
            catch (ClassNotFoundException e) {
                throw new GridUserException("Cannot load Mapper Driver instance without a valid Mapper Driver Class Name!", e);
            }
            if (!MapperInterface.class.isAssignableFrom(mapperClass)) {
                throw new GridUserException("Cannot load Mapper Driver instance without a valid Mapper Driver Class Name!");
            }
            try {
                Constructor<?>[] constructors = mapperClass.getConstructors();
                boolean found = false;
                for (Constructor<?> constructor : constructors) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    found = true;
                    break;
                }
                if (found) {
                    mapper = (MapperInterface)mapperClass.newInstance();
                    break block16;
                }
                try {
                    Method method = mapperClass.getMethod("getInstance", null);
                    if (Modifier.isStatic(method.getModifiers())) {
                        try {
                            mapper = (MapperInterface)method.invoke((Object)this, null);
                            break block16;
                        }
                        catch (IllegalArgumentException e) {
                            log.error("makeMapperClass EXCEPTION during getInstance method invocation. " + e);
                            throw new GridUserException("Cannot instantiate Mapper Driver using getInstance for Mapper Driver named :'" + mapperClassName + "'");
                        }
                        catch (InvocationTargetException e) {
                            log.error("makeMapperClass EXCEPTION during getInstance method invocation. " + e);
                            throw new GridUserException("Cannot instantiate Mapper Driver using getInstance for Mapper Driver named :'" + mapperClassName + "'");
                        }
                    }
                    log.error("Unable to instantiate the class using eiter no args constructor niether getInstance method. getInstance exists but is not static");
                    throw new GridUserException("Cannot instantiate Mapper Driver using new or getInstance for Mapper Driver named :'" + mapperClassName + "'");
                }
                catch (SecurityException e) {
                    log.error("makeMapperClass EXCEPTION during getMethod(\"getInstance\") method invocation. " + e);
                    throw new GridUserException("Cannot instantiate Mapper Driver using getInstance for Mapper Driver named :'" + mapperClassName + "'");
                }
                catch (NoSuchMethodException e) {
                    log.error("Unable to instantiate the class using eiter no args constructor niether getInstance method. " + e);
                    throw new GridUserException("Cannot instantiate Mapper Driver using new or getInstance for Mapper Driver named :'" + mapperClassName + "'");
                }
            }
            catch (IllegalAccessException ex) {
                log.error("makeMapperClass EXCEPTION. " + ex);
                throw new GridUserException("Cannot create a new Instance of the Mapper Driver named :'" + mapperClassName + "'");
            }
            catch (InstantiationException ex) {
                log.error("makeMapperClass EXCEPTION. " + ex);
                throw new GridUserException("Cannot create a new Instance of the Mapper Driver named :'" + mapperClassName + "'");
            }
        }
        return mapper;
    }
}

