/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.griduser.DistinguishedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNMatchingRule {
    private static final Logger log = LoggerFactory.getLogger(DNMatchingRule.class);
    private static final String ADMIT_ALL = ".*";
    private String countryPatternString;
    private String organizationPatternString;
    private String organizationalUnitPatternString;
    private String localityPatternString;
    private String commonNamePatternString;
    private String domainComponentPatternString;
    private Pattern countryPattern;
    private Pattern organizationPattern;
    private Pattern organizationalUnitPattern;
    private Pattern localityPattern;
    private Pattern commonNamePattern;
    private Pattern domainComponentPattern;

    public static DNMatchingRule buildMatchAllDNMatchingRule() {
        return new DNMatchingRule(ADMIT_ALL, ADMIT_ALL, ADMIT_ALL, ADMIT_ALL, ADMIT_ALL, ADMIT_ALL);
    }

    public DNMatchingRule(String regularExpressionRule) {
        this.countryPatternString = ADMIT_ALL;
        this.organizationPatternString = ADMIT_ALL;
        this.organizationalUnitPatternString = ADMIT_ALL;
        this.localityPatternString = ADMIT_ALL;
        this.commonNamePatternString = ADMIT_ALL;
        this.domainComponentPatternString = ADMIT_ALL;
        if (regularExpressionRule != null && !regularExpressionRule.trim().equals("*") && !regularExpressionRule.trim().equals(ADMIT_ALL)) {
            block8: for (String rule : regularExpressionRule.split("/")) {
                if (!rule.contains("=")) {
                    if (rule.trim().isEmpty() || rule.equals(ADMIT_ALL)) continue;
                    log.warn("Malformed DN regex element '" + rule + "' it does not contains '=' key-value separator");
                    continue;
                }
                String[] ruleCoupple = rule.split("=");
                if (ruleCoupple.length != 2) {
                    log.warn("Malformed DN regex element '" + rule + "' it does not contains the key or contains more '=' separators");
                    continue;
                }
                switch (DNFields.fromString(ruleCoupple[0])) {
                    case COUNTRY: {
                        this.countryPatternString = ruleCoupple[1];
                        continue block8;
                    }
                    case ORGANIZATION: {
                        this.organizationPatternString = ruleCoupple[1];
                        continue block8;
                    }
                    case ORGANIZATIONALUNIT: {
                        this.organizationalUnitPatternString = ruleCoupple[1];
                        continue block8;
                    }
                    case LOCALITY: {
                        this.localityPatternString = ruleCoupple[1];
                        continue block8;
                    }
                    case COMMONNAME: {
                        this.commonNamePatternString = ruleCoupple[1];
                        continue block8;
                    }
                    case DOMAINCOMPONENT: {
                        this.domainComponentPatternString = ruleCoupple[1];
                        continue block8;
                    }
                }
            }
        }
        this.initPatterns();
    }

    private void initPatterns() {
        this.countryPattern = DNMatchingRule.isMatchAll(this.countryPatternString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.countryPatternString);
        this.organizationPattern = DNMatchingRule.isMatchAll(this.organizationPatternString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.organizationPatternString);
        this.organizationalUnitPattern = DNMatchingRule.isMatchAll(this.organizationalUnitPatternString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.organizationalUnitPatternString);
        this.localityPattern = DNMatchingRule.isMatchAll(this.localityPatternString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.localityPatternString);
        this.commonNamePattern = DNMatchingRule.isMatchAll(this.commonNamePatternString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.commonNamePatternString);
        this.domainComponentPattern = DNMatchingRule.isMatchAll(this.domainComponentPatternString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.domainComponentPatternString);
    }

    private static boolean isMatchAll(String pattern) {
        return pattern == null || pattern.trim().equals("*") || pattern.trim().equals(ADMIT_ALL);
    }

    public DNMatchingRule(String countryPatternString, String organizationPatternString, String organizationalUnitPatternString, String localityPatternString, String commonNamePatternString, String domainComponentPatternString) {
        this.countryPatternString = countryPatternString;
        this.organizationPatternString = organizationPatternString;
        this.organizationalUnitPatternString = organizationalUnitPatternString;
        this.localityPatternString = localityPatternString;
        this.commonNamePatternString = commonNamePatternString;
        this.domainComponentPatternString = domainComponentPatternString;
        this.initPatterns();
    }

    public boolean isMatchAll() {
        return DNMatchingRule.isMatchAll(this.countryPatternString) && DNMatchingRule.isMatchAll(this.organizationPatternString) && DNMatchingRule.isMatchAll(this.organizationalUnitPatternString) && DNMatchingRule.isMatchAll(this.localityPatternString) && DNMatchingRule.isMatchAll(this.commonNamePatternString) && DNMatchingRule.isMatchAll(this.domainComponentPatternString);
    }

    public boolean match(DistinguishedName principalDN) throws IllegalArgumentException {
        if (principalDN == null) {
            throw new IllegalArgumentException("Unable to perform rule matching. Received null argument: principalDN=" + principalDN);
        }
        if (this.isMatchAll()) {
            return true;
        }
        boolean result = false;
        boolean countryMatch = false;
        boolean organizationMatch = false;
        boolean localityMatch = false;
        boolean organizationalUnitMatch = false;
        boolean commonNameMatch = false;
        boolean domainComponentMatch = false;
        String countryName = principalDN.getCountryName();
        if (countryName != null) {
            CharSequence country = countryName.subSequence(0, countryName.length());
            Matcher countryMatcher = this.countryPattern.matcher(country);
            countryMatch = countryMatcher.find();
        } else {
            countryMatch = this.countryPatternString.equals(ADMIT_ALL);
        }
        if (!countryMatch) {
            return false;
        }
        String organizationName = principalDN.getOrganizationName();
        if (organizationName != null) {
            CharSequence organization = organizationName.subSequence(0, organizationName.length());
            Matcher organizationMatcher = this.organizationPattern.matcher(organization);
            organizationMatch = organizationMatcher.find();
        } else {
            organizationMatch = this.organizationPatternString.equals(ADMIT_ALL);
        }
        if (!organizationMatch) {
            return false;
        }
        String localityName = principalDN.getLocalityName();
        if (localityName != null) {
            CharSequence locality = localityName.subSequence(0, localityName.length());
            Matcher localityMatcher = this.localityPattern.matcher(locality);
            localityMatch = localityMatcher.find();
        } else {
            localityMatch = this.localityPatternString.equals(ADMIT_ALL);
        }
        if (!localityMatch) {
            return false;
        }
        ArrayList<String> organizationalUnitNames = principalDN.getOrganizationalUnitNames();
        if (organizationalUnitNames != null && !organizationalUnitNames.isEmpty()) {
            CharSequence organizationalUnit = null;
            String nameStr = null;
            Matcher organizationalUnitMatcher = null;
            Iterator<String> name = organizationalUnitNames.iterator();
            while (name.hasNext() && !(organizationalUnitMatch = (organizationalUnitMatcher = this.organizationalUnitPattern.matcher(organizationalUnit = (nameStr = name.next()).subSequence(0, nameStr.length()))).find())) {
            }
        } else {
            organizationalUnitMatch = this.organizationalUnitPatternString.equals(ADMIT_ALL);
        }
        if (!organizationalUnitMatch) {
            return false;
        }
        ArrayList<String> commonNames = principalDN.getCommonNames();
        if (commonNames != null && !commonNames.isEmpty()) {
            CharSequence commonName = null;
            String commonNameStr = null;
            Matcher commonNameMatcher = null;
            Iterator<String> scanCN = commonNames.iterator();
            while (scanCN.hasNext() && !(commonNameMatch = (commonNameMatcher = this.commonNamePattern.matcher(commonName = (commonNameStr = scanCN.next()).subSequence(0, commonNameStr.length()))).find())) {
            }
        } else {
            commonNameMatch = this.commonNamePatternString.equals(ADMIT_ALL);
        }
        if (!commonNameMatch) {
            return false;
        }
        ArrayList<String> domainComponents = principalDN.getDomainComponents();
        if (domainComponents != null && !domainComponents.isEmpty()) {
            CharSequence domainComponent = null;
            String domainComponentStr = null;
            Matcher domainComponentMatcher = null;
            Iterator<String> scanDC = domainComponents.iterator();
            while (scanDC.hasNext() && !(domainComponentMatch = (domainComponentMatcher = this.domainComponentPattern.matcher(domainComponent = (domainComponentStr = scanDC.next()).subSequence(0, domainComponentStr.length()))).find())) {
            }
        } else {
            domainComponentMatch = this.commonNamePatternString.equals(ADMIT_ALL);
        }
        if (!domainComponentMatch) {
            return false;
        }
        result = countryMatch && organizationMatch && organizationalUnitMatch && localityMatch && commonNameMatch && domainComponentMatch;
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" C=" + this.countryPatternString);
        result.append(" O=" + this.organizationPatternString);
        result.append(" OU=" + this.organizationalUnitPatternString);
        result.append(" L=" + this.localityPatternString);
        result.append(" CN=" + this.commonNamePatternString);
        return result.toString();
    }

    private static enum DNFields {
        COUNTRY("C"),
        ORGANIZATION("O"),
        ORGANIZATIONALUNIT("OU"),
        LOCALITY("L"),
        COMMONNAME("CN"),
        DOMAINCOMPONENT("DC"),
        UNKNOWN("");

        private final String code;

        private DNFields(String code) throws IllegalArgumentException {
            if (code == null) {
                throw new IllegalArgumentException("Received null code argument");
            }
            this.code = code;
        }

        public static DNFields fromString(String code) {
            for (DNFields field : DNFields.values()) {
                if (!field.code.equals(code)) continue;
                return field;
            }
            return UNKNOWN;
        }
    }
}

