/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.filesystem.InvalidSpaceAttributesException;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import java.io.File;
import java.io.IOException;

public class Space {
    private SpaceSystem ss = null;
    private TSizeInBytes guaranteedSize = TSizeInBytes.makeEmpty();
    private TSizeInBytes totalSize = TSizeInBytes.makeEmpty();
    private TSpaceToken spaceToken = TSpaceToken.makeEmpty();
    private LocalFile spaceFile = null;

    public Space(TSizeInBytes guaranteedSize, TSizeInBytes totalSize, LocalFile spaceFile, SpaceSystem ss) throws InvalidSpaceAttributesException {
        boolean ok3;
        boolean ok1 = guaranteedSize != null && totalSize != null && spaceFile != null && ss != null && !totalSize.isEmpty();
        boolean ok2 = guaranteedSize.isEmpty();
        boolean bl = ok3 = !guaranteedSize.isEmpty() && guaranteedSize.getSizeIn(SizeUnit.BYTES) <= totalSize.getSizeIn(SizeUnit.BYTES);
        if (!ok1 || !ok2 && !ok3) {
            throw new InvalidSpaceAttributesException(guaranteedSize, totalSize, spaceFile, ss);
        }
        this.guaranteedSize = guaranteedSize;
        this.totalSize = totalSize;
        this.spaceFile = spaceFile;
        this.ss = ss;
    }

    public void setSpaceToken(TSpaceToken spaceToken) {
        if (spaceToken != null) {
            this.spaceToken = spaceToken;
        }
    }

    public void allot() throws ReservationException {
        this.ss.reserveSpace(this.spaceFile.getPath(), this.guaranteedSize.value());
    }

    public void fakeAllot() throws ReservationException {
        File localFile = new File(this.spaceFile.getPath());
        try {
            localFile.createNewFile();
        }
        catch (IOException e) {
            throw new ReservationException("IO exception while creating local File named : " + this.spaceFile.getPath() + " : " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new ReservationException("Security exception while creating local File named : " + this.spaceFile.getPath() + " : " + e.getMessage());
        }
    }

    public void fakeRelease() throws ReservationException {
        File localFile = new File(this.spaceFile.getPath());
        try {
            localFile.delete();
        }
        catch (SecurityException e) {
            throw new ReservationException("Security exception while deleteing local File named : " + this.spaceFile.getPath() + " : " + e.getMessage());
        }
    }

    public long compact() throws ReservationException {
        return this.ss.compactSpace(this.spaceFile.getPath());
    }

    public TSpaceToken getSpaceToken() {
        return this.spaceToken;
    }

    public LocalFile getSpaceFile() {
        return this.spaceFile;
    }

    public TSizeInBytes getGuaranteedSpaceSize() {
        return this.guaranteedSize;
    }

    public TSizeInBytes getTotalReservedSize() {
        return this.totalSize;
    }

    public long getUnusedSpace() {
        return 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Space: guaranteedSize=");
        sb.append(this.guaranteedSize.toString());
        sb.append("; totalSize=");
        sb.append(this.totalSize.toString());
        sb.append("; spaceFile=");
        sb.append(this.spaceFile.toString());
        sb.append("; SpaceSystem=");
        sb.append(this.ss.toString());
        sb.append("; TSpaceToken=");
        sb.append(this.spaceToken.toString());
        return sb.toString();
    }
}

