/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.filesystem.SpaceSystemException;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSpaceSystem
implements SpaceSystem {
    private String mountpoint = "";
    private static Logger log = LoggerFactory.getLogger(MockSpaceSystem.class);

    public MockSpaceSystem(String mountpoint) throws SpaceSystemException {
        if (mountpoint == null) {
            throw new SpaceSystemException("Supplied mountpoint is null!");
        }
        this.mountpoint = mountpoint;
    }

    @Override
    public long reserveSpace(String pathToFile, long size) throws ReservationException {
        File localFile = new File(pathToFile);
        try {
            localFile.createNewFile();
        }
        catch (IOException ex) {
            log.error("IO exception while creating local File named : " + pathToFile, (Throwable)ex);
            throw new ReservationException("IO exception while creating local File named : " + pathToFile);
        }
        catch (SecurityException sec_ex) {
            log.error("Security exception while creating local File named : " + pathToFile, (Throwable)sec_ex);
            throw new ReservationException("Security exception while creating local File named : " + pathToFile);
        }
        return size;
    }

    @Override
    public long compactSpace(String pathToFile) throws ReservationException {
        String explanation = "Compact Space operation currently not supported!";
        log.error(explanation);
        throw new ReservationException(explanation);
    }

    @Override
    public void removeSpace(String pathToFile) throws ReservationException {
        String explanation = "Remove Space operation currently not supported!";
        log.error(explanation);
        throw new ReservationException(explanation);
    }

    @Override
    public long changeSize(String pathToFile, long newSize) throws ReservationException {
        String explanation = "Change Size operation currently not supported!";
        log.error(explanation);
        throw new ReservationException(explanation);
    }

    public String toString() {
        return "MockSpaceSystem";
    }
}

