/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.FileSystemChecker;
import it.grid.storm.filesystem.FileSystemCheckerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCheckerMtabMonolithic
implements FileSystemChecker {
    private static final Logger log = LoggerFactory.getLogger(FileSystemCheckerMtabMonolithic.class);
    private static final String GPFS_FILESYSTEM_NAME = "gpfs";
    private static final String MTAB_FILE_PATH = "/etc/mtab";
    private static FileSystemCheckerMtabMonolithic instance = new FileSystemCheckerMtabMonolithic();
    private List<String> GPFSMountPoints = null;
    private long initInstant = 0L;

    private FileSystemCheckerMtabMonolithic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystemCheckerMtabMonolithic getInstance() throws FileSystemCheckerException {
        FileSystemCheckerMtabMonolithic fileSystemCheckerMtabMonolithic = instance;
        synchronized (fileSystemCheckerMtabMonolithic) {
            if (instance.refreshNeeded()) {
                instance.init();
            }
        }
        return instance;
    }

    private synchronized void init() throws FileSystemCheckerException {
        this.initInstant = Calendar.getInstance().getTimeInMillis();
        this.GPFSMountPoints = FileSystemCheckerMtabMonolithic.listGPFSMountPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGPFS(File file) throws IllegalArgumentException, FileSystemCheckerException {
        if (file == null) {
            log.error("IsGPFS method invoked with null File parameter!");
            throw new IllegalArgumentException("Provided null File argument");
        }
        FileSystemCheckerMtabMonolithic fileSystemCheckerMtabMonolithic = instance;
        synchronized (fileSystemCheckerMtabMonolithic) {
            if (this.refreshNeeded()) {
                this.init();
            }
        }
        return this.evaluate(file.getAbsolutePath());
    }

    private synchronized boolean refreshNeeded() {
        boolean response = false;
        if (this.initInstant == 0L || this.initInstant < new File(MTAB_FILE_PATH).lastModified()) {
            response = true;
        }
        return response;
    }

    private boolean evaluate(String filePath) {
        boolean response = false;
        for (String GPFSMountPoint : this.GPFSMountPoints) {
            if (!filePath.startsWith(GPFSMountPoint)) continue;
            response = true;
            break;
        }
        return response;
    }

    private static List<String> listGPFSMountPoints() throws FileSystemCheckerException {
        BufferedReader mtab;
        LinkedList<String> mountPointList = new LinkedList<String>();
        try {
            mtab = new BufferedReader(new FileReader(MTAB_FILE_PATH));
        }
        catch (FileNotFoundException e) {
            log.error("Error while trying to create a reader for mtab file at /etc/mtab. FileNotFoundException : " + e.getMessage());
            throw new FileSystemCheckerException("Error while trying to create a reader for mtab file at /etc/mtab. FileNotFoundException : " + e.getMessage());
        }
        try {
            String line;
            while ((line = mtab.readLine()) != null) {
                LinkedList<String> elementsList;
                if (line.startsWith("#") || !line.startsWith("/dev/") || !(elementsList = FileSystemCheckerMtabMonolithic.tokenizeLine(line)).get(2).equals(GPFS_FILESYSTEM_NAME)) continue;
                mountPointList.add(elementsList.get(1));
            }
        }
        catch (IOException e) {
            log.error("Error while trying to read mtab file at /etc/mtab. IOException : " + e.getMessage());
            throw new FileSystemCheckerException("Error while trying to read mtab file at /etc/mtab. IOException : " + e.getMessage());
        }
        return mountPointList;
    }

    private static LinkedList<String> tokenizeLine(String line) {
        String[] elementsArray = line.split(" ");
        LinkedList<String> elementsList = new LinkedList<String>(Arrays.asList(elementsArray));
        while (elementsList.remove("")) {
        }
        return elementsList;
    }
}

