/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.AclLockPoolElement;
import java.util.concurrent.ConcurrentHashMap;

class AclLockPool {
    private final ConcurrentHashMap __map;

    AclLockPool(int initialCapacity, float loadFactor, int concurrencyLevel) {
        assert (initialCapacity >= 0) : "Negative initialCapacity passed to AclLockPool(int,float,int) constructor";
        assert (loadFactor >= 0.0f) : "Negative loadFactor passed to AclLockPool(int,float,int) constructor";
        assert (concurrencyLevel >= 0) : "Negative concurrencyLevel passed to AclLockPool(int,float,int) constructor";
        this.__map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    AclLockPool(int initialCapacity) {
        assert (initialCapacity >= 0) : "Negative initialCapacity passed to AclLockPool(int,float) constructor";
        this.__map = new ConcurrentHashMap(initialCapacity);
    }

    AclLockPool() {
        this.__map = new ConcurrentHashMap();
    }

    public synchronized AclLockPoolElement get(String pathname) {
        if (!this.__map.contains(pathname)) {
            this.__map.put(pathname, new AclLockPoolElement());
        }
        AclLockPoolElement lock = (AclLockPoolElement)this.__map.get(pathname);
        lock.incrementUsageCount();
        return lock;
    }

    public synchronized void remove(String pathname) {
        int count;
        AclLockPoolElement e = (AclLockPoolElement)this.__map.get(pathname);
        if (null != e && 0 >= (count = e.decrementUsageCountAndGetIt())) {
            this.__map.remove(pathname);
        }
    }

    public synchronized boolean contains(String pathname) {
        return this.__map.contains(pathname);
    }
}

