/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.ea.remote.resource;

import com.sun.jersey.server.impl.ResponseBuilderImpl;
import it.grid.storm.ea.ExtendedAttributesException;
import it.grid.storm.ea.FileNotFoundException;
import it.grid.storm.ea.NotSupportedException;
import it.grid.storm.ea.StormEA;
import it.grid.storm.ea.remote.resource.RequestParameters;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/checksum/1.0/{filePath}")
public class StormEAResource {
    private static final Logger log = LoggerFactory.getLogger(StormEAResource.class);

    @GET
    @Path(value="/Adler32")
    @Produces(value={"text/plain"})
    public String getAdler32Checksum(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        String checksum;
        RequestParameters parameters = new RequestParameters.Builder(filePath).build();
        log.info("Getting Adler32 checksum for file " + parameters.getFilePathDecoded());
        try {
            checksum = StormEA.getChecksum(parameters.getFilePathDecoded(), "Adler32");
        }
        catch (FileNotFoundException e) {
            log.error("Unable to get file checksum. FileNotFoundException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)("File " + parameters.getFilePathDecoded() + " does not exists"));
            throw new WebApplicationException(responseBuilder.build());
        }
        catch (NotSupportedException e) {
            log.error("Unable to get file checksum. NotSupportedException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.INTERNAL_SERVER_ERROR);
            responseBuilder.entity((Object)"Unable to get the checksum, operation not supported by the filesystem");
            throw new WebApplicationException(responseBuilder.build());
        }
        catch (ExtendedAttributesException e) {
            log.error("Unable to get file checksum. ExtendedAttributesException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.INTERNAL_SERVER_ERROR);
            responseBuilder.entity((Object)"Unable to get the checksum, Extended attributes management failure");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.info("Retrieved checksum is " + checksum);
        return checksum;
    }

    @PUT
    @Path(value="/Adler32")
    @Produces(value={"text/plain"})
    public void setAdler32Checksum(@PathParam(value="filePath") String filePath, @QueryParam(value="value") String checksum) throws WebApplicationException {
        RequestParameters parameters = new RequestParameters.Builder(filePath).checksum(checksum).build();
        log.info("Setting Adler32 '" + parameters.getChecksumDecoded() + "' checksum for file " + parameters.getFilePathDecoded());
        try {
            StormEA.setChecksum(parameters.getFilePathDecoded(), parameters.getChecksumDecoded(), "Adler32");
        }
        catch (FileNotFoundException e) {
            log.error("Unable to set file checksum. FileNotFoundException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)("File " + parameters.getFilePathDecoded() + " does not exists"));
            throw new WebApplicationException(responseBuilder.build());
        }
        catch (NotSupportedException e) {
            log.error("Unable to set file checksum. NotSupportedException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.INTERNAL_SERVER_ERROR);
            responseBuilder.entity((Object)"Unable to set the checksum, operation not supported by the filesystem");
            throw new WebApplicationException(responseBuilder.build());
        }
        catch (ExtendedAttributesException e) {
            log.error("Unable to set file checksum. ExtendedAttributesException: " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.INTERNAL_SERVER_ERROR);
            responseBuilder.entity((Object)"Unable to set the checksum, Extended attributes management failure");
            throw new WebApplicationException(responseBuilder.build());
        }
    }
}

