/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.config;

import it.grid.storm.config.ConfigReader;
import it.grid.storm.config.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ConfigurationKeys {
    private static final String fs = File.separator;
    private final String configFN = "src" + fs + "it" + fs + "grid" + fs + "storm" + fs + "config" + fs + "Configuration.java";

    public HashMap<String, String> getMethodsKeys() {
        HashMap<String, String> method_key = new HashMap<String, String>();
        try {
            Method[] m = Configuration.instance.getClass().getDeclaredMethods();
            for (int i = 0; i < m.length; ++i) {
                String methodName = m[i].getName();
                if (!m[i].getName().substring(0, 3).equals("get") || m[i].getName().equals("getInstance")) continue;
                String keyName = "unknown";
                method_key.put(methodName, keyName);
            }
            System.out.println("Configuration has " + method_key.size() + " methods getting key values.");
        }
        catch (SecurityException se) {
            System.out.println("Unable to list the definible keys.." + se);
        }
        int lineNr = 0;
        String configurationCodeFileName = System.getProperty("user.dir") + fs + this.configFN;
        ArrayList<String> configurationCode = new ArrayList<String>();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(configurationCodeFileName));
            while ((str = in.readLine()) != null) {
                configurationCode.add(str);
                ++lineNr;
            }
            in.close();
            System.out.println("Configuration has " + lineNr + " lines of code.");
        }
        catch (IOException e) {
            System.out.println("Some problem to read '" + configurationCodeFileName + "'");
        }
        int currentLine = 0;
        for (String line : configurationCode) {
            String[] fields;
            ++currentLine;
            if (!line.contains("public")) continue;
            for (String field : fields = line.split(" ")) {
                String method;
                if (!field.startsWith("get")) continue;
                int endIndex = field.indexOf("(");
                if (endIndex == -1) {
                    endIndex = field.length();
                }
                if (!method_key.containsKey(method = field.substring(0, endIndex))) continue;
                int line_to_end = lineNr - currentLine;
                int lineToScan = line_to_end > 5 ? 5 : line_to_end;
                for (int j = currentLine; j < currentLine + lineToScan; ++j) {
                    String keyName;
                    String lineKey;
                    int beginIndex;
                    if (!((String)configurationCode.get(j)).contains("String key") || (beginIndex = (lineKey = (String)configurationCode.get(j)).indexOf("\"")) <= 0 || (endIndex = (keyName = lineKey.substring(beginIndex)).indexOf(";")) <= 0) continue;
                    keyName = keyName.substring(1, endIndex - 1);
                    method_key.put(method, keyName);
                }
            }
        }
        return method_key;
    }

    public List<String> getKeys() {
        ArrayList<String> definedKeys = new ArrayList<String>();
        HashMap<String, String> method_key = this.getMethodsKeys();
        Set<String> methods = method_key.keySet();
        for (String meth : methods) {
            String key = method_key.get(meth);
            if (key.equals("unknown")) {
                System.out.println("#### Meth: " + meth + "  --- " + key);
            }
            definedKeys.add(method_key.get(meth));
        }
        return definedKeys;
    }

    public List<String> getTemplateKeys() {
        ArrayList<String> templateKeys = new ArrayList<String>();
        String templateFileName = System.getProperty("user.dir") + fs + "etc" + fs + "storm.properties.template";
        Properties template = new Properties();
        try {
            template.load(new FileInputStream(templateFileName));
        }
        catch (IOException e) {
            System.out.println("Error while reading the properties template");
        }
        Enumeration<Object> scan = template.keys();
        while (scan.hasMoreElements()) {
            templateKeys.add("" + scan.nextElement());
        }
        return templateKeys;
    }

    public List<String> getDuplicatedKeys() {
        ArrayList<String> duplicatedKeys = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        String templateFileName = System.getProperty("user.dir") + fs + "etc" + fs + "storm.properties.template";
        int lineNr = 0;
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(templateFileName));
            while ((str = in.readLine()) != null) {
                if (str.startsWith("#") || str.length() <= 0) continue;
                String line = str.trim();
                int index = line.indexOf("=");
                if (index < 0) {
                    System.out.println("strange line : " + line);
                    continue;
                }
                String keyName = line.substring(0, index);
                if (keys.contains(keyName)) {
                    duplicatedKeys.add(keyName);
                    continue;
                }
                keys.add(keyName);
            }
            in.close();
            System.out.println("Configuration has " + lineNr + " lines of code.");
        }
        catch (IOException e) {
            System.out.println("Some problem to read '" + templateFileName + "'");
        }
        int count = 1;
        for (String key : keys) {
            System.out.println("key (" + count + "): " + key);
            ++count;
        }
        return duplicatedKeys;
    }

    public HashMap<String, String> getKeyValue() {
        HashMap<String, String> method_keys = this.getMethodsKeys();
        HashMap<String, String> keys_values = new HashMap<String, String>();
        Method[] allMethods = Configuration.instance.getClass().getDeclaredMethods();
        Set<String> methodNames = method_keys.keySet();
        System.out.println("sizes KeySet= " + methodNames.size());
        System.out.println("sizes methods = " + allMethods.length);
        for (Method m : allMethods) {
            if (!methodNames.contains(m.getName())) continue;
            System.out.println("method invocable : " + m.getName());
            try {
                Object result = m.invoke((Object)Configuration.instance, new Object[0]);
                System.out.println("Output = '" + result.toString() + "'");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return keys_values;
    }

    public static void main(String[] args) {
        String configurationPathname = System.getProperty("user.dir") + File.separator + "etc" + File.separator + "storm.properties";
        System.out.println("config file: " + configurationPathname);
        Configuration.getInstance().setConfigReader(new ConfigReader(configurationPathname, 0));
        ConfigurationKeys instance = new ConfigurationKeys();
        List<String> keys = instance.getKeys();
        int count = 1;
        for (String key : keys) {
            System.out.println(count + " " + key);
            ++count;
        }
        System.out.println("**** keys : " + (count - 1));
        count = 1;
        List<String> tempKeys = instance.getTemplateKeys();
        for (String key : tempKeys) {
            if (keys.contains(key)) continue;
            System.out.println("UNKNOWN KEY in TEMPLATE (" + count + "):" + key);
            ++count;
        }
        for (String key : keys) {
            if (tempKeys.contains(key)) continue;
            System.out.println("Config KEY not in TEMPLATE (" + count + "):" + key);
            ++count;
        }
        for (String key : keys) {
            if (!tempKeys.contains(key)) continue;
            System.out.println("All right key (" + count + "): " + key);
            ++count;
        }
        System.out.println("### KEYS : " + (count - 1));
        System.out.println("  ================================  ");
        List<String> dupKeys = instance.getDuplicatedKeys();
        for (String key : dupKeys) {
            System.out.println("dup-key: " + key);
        }
        System.out.println(" ####################### ");
        instance.getKeyValue();
    }
}

