/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.concurrency;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingThreadPool
extends ThreadPoolExecutor {
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(TimingThreadPool.class);
    private final AtomicLong numTasks = new AtomicLong();
    private final AtomicLong totalTime = new AtomicLong();

    public TimingThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        log.debug(String.format("Thread %s: start %s", t, r));
        this.startTime.set(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        block8: {
            try {
                long endTime = System.nanoTime();
                long taskTime = endTime - this.startTime.get();
                this.numTasks.incrementAndGet();
                this.totalTime.addAndGet(taskTime);
                if (t == null && r instanceof Future) {
                    try {
                        Object result = ((Future)((Object)r)).get();
                        log.debug("Thread ended with result: " + result);
                    }
                    catch (CancellationException ce) {
                        t = ce;
                    }
                    catch (ExecutionException ee) {
                        t = ee.getCause();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    log.debug(String.format("Throwable %s: end %s, time=%dns", t, r, taskTime));
                    break block8;
                }
                log.warn("Throwable : " + t);
            }
            finally {
                super.afterExecute(r, t);
            }
        }
    }
}

