/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.namespace.model.Protocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TURLPrefix {
    private static Logger log = LoggerFactory.getLogger(TURLPrefix.class);
    public static final String PNAME_TURL_PREFIX = "turlPrefix";
    private ArrayList<Protocol> desiredProtocols;

    public TURLPrefix() {
        this.desiredProtocols = new ArrayList();
    }

    public TURLPrefix(Collection<Protocol> protocols) {
        this.desiredProtocols = new ArrayList<Protocol>(protocols);
    }

    public boolean addProtocol(Protocol protocol) {
        return this.desiredProtocols.add(protocol);
    }

    public Protocol getProtocol(int index) {
        return this.desiredProtocols.get(index);
    }

    public List<Protocol> getDesiredProtocols() {
        return this.desiredProtocols;
    }

    public int size() {
        return this.desiredProtocols.size();
    }

    public void print() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TURLPrefix: ");
        Iterator<Protocol> i = this.desiredProtocols.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            sb.append(" ");
        }
        return sb.toString();
    }

    public static TURLPrefix decode(Map inputParam, String memberName) {
        TURLPrefix decodedTurlPrefix = null;
        if (inputParam.containsKey(memberName) && inputParam.get(memberName) != null) {
            Object[] valueArray = null;
            valueArray = inputParam.get(memberName).getClass().isArray() ? (Object[])inputParam.get(memberName) : new Object[]{inputParam.get(memberName)};
            LinkedList<Protocol> protocols = new LinkedList<Protocol>();
            for (Object value : valueArray) {
                Protocol protocol = Protocol.getProtocol(value.toString());
                if (protocol.equals(Protocol.UNKNOWN)) {
                    log.warn("Unable to decode protocol " + value.toString() + " . Unknown protocol");
                    continue;
                }
                protocols.add(protocol);
            }
            if (protocols.size() > 0) {
                decodedTurlPrefix = new TURLPrefix(protocols);
            }
        }
        return decodedTurlPrefix;
    }

    public boolean allows(Protocol protocol) {
        return this.desiredProtocols.contains(protocol);
    }
}

