/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.InvalidMachineAttributeException;
import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.InvalidPortAttributeException;
import it.grid.storm.common.types.InvalidTFNAttributesException;
import it.grid.storm.common.types.Machine;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFN {
    private static Logger log = LoggerFactory.getLogger(TFN.class);
    private Machine m = null;
    private Port p = null;
    private PFN pfn = null;
    private boolean empty = true;

    private TFN(Machine m, Port p, PFN pfn, boolean empty) {
        this.m = m;
        this.p = p;
        this.pfn = pfn;
        this.empty = empty;
    }

    public static TFN makeEmpty() {
        return new TFN(Machine.makeEmpty(), Port.makeEmpty(), PFN.makeEmpty(), true);
    }

    public static TFN make(Machine m, Port p, PFN pfn) throws InvalidTFNAttributesException {
        if (m == null || p == null || pfn == null || m.isEmpty() || pfn.isEmpty()) {
            throw new InvalidTFNAttributesException(m, p, pfn);
        }
        return new TFN(m, p, pfn, false);
    }

    public static TFN makeByPFN(PFN pfn) throws InvalidTFNAttributesException {
        if (pfn == null || pfn.isEmpty()) {
            throw new InvalidTFNAttributesException(null, null, pfn);
        }
        return new TFN(Machine.makeEmpty(), Port.makeEmpty(), pfn, false);
    }

    public static TFN makeFromString(String s) throws InvalidTFNAttributesException {
        if (s == null) {
            throw new InvalidTFNAttributesException(null, null, null);
        }
        int colon = s.indexOf(":");
        int slash = s.indexOf("/");
        if (colon == -1) {
            if (slash == -1 || slash == 0) {
                throw new InvalidTFNAttributesException(null, null, null);
            }
            String mString = s.substring(0, slash);
            Machine m = null;
            try {
                m = Machine.make(mString);
            }
            catch (InvalidMachineAttributeException e) {
                log.warn("TFN: Unable to build -machine- attribute with the String '" + mString + "'." + e);
            }
            Port p = Port.makeEmpty();
            String pfnString = s.substring(slash, s.length());
            PFN pfn = null;
            try {
                pfn = PFN.make(pfnString);
            }
            catch (InvalidPFNAttributeException e) {
                log.warn("TFN: Unable to build -pfn- attribute with the String '" + pfnString + "'." + e);
            }
            return TFN.make(m, p, pfn);
        }
        if (slash != -1 && colon > slash) {
            if (slash == 0) {
                throw new InvalidTFNAttributesException(null, null, null);
            }
            String mString = s.substring(0, slash);
            Machine m = null;
            try {
                m = Machine.make(mString);
            }
            catch (InvalidMachineAttributeException e) {
                log.warn("TFN: Unable to build -machine- attribute with the String '" + mString + "'." + e);
            }
            Port p = Port.makeEmpty();
            String pfnString = s.substring(slash, s.length());
            PFN pfn = null;
            try {
                pfn = PFN.make(pfnString);
            }
            catch (InvalidPFNAttributeException e) {
                log.warn("TFN: Unable to build -pfn- attribute with the String '" + pfnString + "'." + e);
            }
            return TFN.make(m, p, pfn);
        }
        if (slash != -1 && colon < slash) {
            if (colon == 0) {
                throw new InvalidTFNAttributesException(null, null, null);
            }
            String mString = s.substring(0, colon);
            Machine m = null;
            try {
                m = Machine.make(mString);
            }
            catch (InvalidMachineAttributeException e) {
                log.warn("TFN: Unable to build -machine- attribute with the String '" + mString + "'." + e);
            }
            if (colon + 1 == slash) {
                throw new InvalidTFNAttributesException(m, null, null);
            }
            String pString = s.substring(colon + 1, slash);
            Port p = null;
            try {
                p = Port.make(Integer.parseInt(pString));
            }
            catch (InvalidPortAttributeException e) {
                log.warn("TFN: Unable to build -port- attribute with the String '" + pString + "'." + e);
            }
            catch (NumberFormatException e) {
                log.warn("TFN: Unable to build -port- attribute with the String (NFE) '" + pString + "'." + e);
            }
            String pfnString = s.substring(slash, s.length());
            PFN pfn = null;
            try {
                pfn = PFN.make(pfnString);
            }
            catch (InvalidPFNAttributeException e) {
                log.warn("TFN: Unable to build -pfn- attribute with the String '" + pfnString + "'." + e);
            }
            return TFN.make(m, p, pfn);
        }
        throw new InvalidTFNAttributesException(null, null, null);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Machine machine() {
        if (this.empty) {
            return Machine.makeEmpty();
        }
        return this.m;
    }

    public Port port() {
        if (this.empty) {
            return Port.makeEmpty();
        }
        return this.p;
    }

    public PFN pfn() {
        if (this.empty) {
            return PFN.makeEmpty();
        }
        return this.pfn;
    }

    public String toString() {
        if (this.empty) {
            return "Empty TFN";
        }
        if (this.m.isEmpty() && this.p.isEmpty()) {
            return this.pfn.toString();
        }
        if (!this.m.isEmpty() && this.p.isEmpty()) {
            return this.m.toString() + this.pfn.toString();
        }
        return this.m + ":" + this.p + this.pfn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TFN)) {
            return false;
        }
        TFN tfno = (TFN)o;
        if (this.empty && tfno.empty) {
            return true;
        }
        return !this.empty && !tfno.empty && this.m.equals(tfno.m) && this.p.equals(tfno.p) && this.pfn.equals(tfno.pfn);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        hash = 37 * hash + this.m.hashCode();
        hash = 37 * hash + this.p.hashCode();
        hash = 37 * hash + this.pfn.hashCode();
        return hash;
    }
}

