/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.EndPoint;
import it.grid.storm.common.types.InvalidEndPointAttributeException;
import it.grid.storm.common.types.InvalidMachineAttributeException;
import it.grid.storm.common.types.InvalidPortAttributeException;
import it.grid.storm.common.types.InvalidSFNAttributesException;
import it.grid.storm.common.types.InvalidStFNAttributeException;
import it.grid.storm.common.types.Machine;
import it.grid.storm.common.types.ParsingSFNAttributesException;
import it.grid.storm.common.types.Port;
import it.grid.storm.common.types.StFN;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFN {
    private static Logger log = LoggerFactory.getLogger(SFN.class);
    private Machine m = null;
    private Port p = null;
    private EndPoint ep = null;
    private StFN pn = null;
    private boolean empty = true;

    private SFN(Machine m, Port p, EndPoint ep, StFN pn, boolean empty) {
        this.m = m;
        this.p = p;
        this.ep = ep;
        this.pn = pn;
        this.empty = empty;
    }

    public static SFN makeEmpty() {
        return new SFN(Machine.makeEmpty(), Port.makeEmpty(), EndPoint.makeEmpty(), StFN.makeEmpty(), true);
    }

    public static SFN makeInSimpleForm(Machine m, Port p, StFN stfn) throws InvalidSFNAttributesException {
        if (m == null || p == null || stfn == null || m.isEmpty() || p.isEmpty() || stfn.isEmpty()) {
            throw new InvalidSFNAttributesException(m, p, stfn);
        }
        return new SFN(m, p, EndPoint.makeEmpty(), stfn, false);
    }

    public static SFN makeInQueryForm(Machine m, Port p, EndPoint ep, StFN stfn) throws InvalidSFNAttributesException {
        if (m == null || p == null || ep == null || stfn == null || m.isEmpty() || p.isEmpty() || ep.isEmpty() || stfn.isEmpty()) {
            throw new InvalidSFNAttributesException(m, p, ep, stfn);
        }
        return new SFN(m, p, ep, stfn, false);
    }

    public static SFN makeInSimpleForm(Machine m, StFN stfn) throws InvalidSFNAttributesException {
        if (m == null || stfn == null || m.isEmpty() || stfn.isEmpty()) {
            throw new InvalidSFNAttributesException(m, null, stfn);
        }
        return new SFN(m, Port.makeEmpty(), EndPoint.makeEmpty(), stfn, false);
    }

    public static SFN makeInQueryForm(Machine m, EndPoint ep, StFN stfn) throws InvalidSFNAttributesException {
        if (m == null || stfn == null || ep == null || m.isEmpty() || stfn.isEmpty() || ep.isEmpty()) {
            throw new InvalidSFNAttributesException(m, null, stfn);
        }
        return new SFN(m, Port.makeEmpty(), ep, stfn, false);
    }

    public static SFN makeFromString(String surlString) throws ParsingSFNAttributesException, InvalidSFNAttributesException {
        if (surlString == null) {
            throw new ParsingSFNAttributesException(surlString, "Supplied SFN String was null!");
        }
        int colon = surlString.indexOf(":");
        int slash = surlString.indexOf("/");
        int question = surlString.toUpperCase().indexOf("?SFN=");
        if (colon > 0) {
            if (question < 0) {
                if (slash == -1 || slash == 0) {
                    throw new ParsingSFNAttributesException(surlString, "String interpreted as omitting the optional port specification, and as referring to query form; but the first slash was either not found or right at the beginning!");
                }
                return SFN.makeFromSimpleFormNoPort(surlString, slash);
            }
            if (slash == -1 || slash == 0 || slash > question) {
                throw new ParsingSFNAttributesException(surlString, "String interpreted as omitting the optional port specification, and as referring to query form; but the first slash was either not found, or right at the beginning, or only followed the question mark!");
            }
            return SFN.makeFromQueryFormNoPort(surlString, question, slash);
        }
        if (question < 0) {
            if (colon == 0 || colon > slash) {
                throw new ParsingSFNAttributesException(surlString, "String interpreted as specifying port, and as not referring to query form; but either the colon is missing, or it follows the first slash!");
            }
            return SFN.makeFromSimpleForm(surlString, colon, slash);
        }
        if (colon == 0 || colon > slash || slash > question) {
            throw new ParsingSFNAttributesException(surlString, "String interpreted as having the optional port specification, and as referring to query form; but either colon is missing, colon follows first slash, or first slash follows question mark!");
        }
        return SFN.makeFromQueryForm(surlString, colon, slash, question);
    }

    private static SFN makeFromQueryForm(String surlString, int colon, int slash, int question) throws ParsingSFNAttributesException, InvalidSFNAttributesException {
        String machineString = surlString.substring(0, colon);
        Machine machine = null;
        try {
            machine = Machine.make(machineString);
        }
        catch (InvalidMachineAttributeException e) {
            log.warn("SFN: Unable to build -machine- attribute with the String '" + machineString + "'." + e);
        }
        if (colon + 1 == slash) {
            throw new ParsingSFNAttributesException(surlString, "String interpreted as specifying the optional port, and as referring to query form; but the port number is missing since the first slash was found right after the colon!");
        }
        String portString = surlString.substring(colon + 1, slash);
        Port port = null;
        try {
            port = Port.make(Integer.parseInt(portString));
        }
        catch (InvalidPortAttributeException e) {
            log.warn("SFN: Unable to build -port- attribute with the String '" + portString + "'." + e);
        }
        catch (NumberFormatException e) {
            log.warn("SFN: Unable to build -port- attribute with the String (NFE) '" + portString + "'." + e);
        }
        String endpointString = surlString.substring(slash, question);
        EndPoint endpoint = null;
        try {
            endpoint = EndPoint.make(endpointString);
        }
        catch (InvalidEndPointAttributeException e) {
            log.warn("SFN: Unable to build -endpoint- attribute with the String '" + endpointString + "'." + e);
        }
        if (question + 5 >= surlString.length()) {
            throw new ParsingSFNAttributesException(surlString, "String interpreted as omitting the optional port specification, and as referring to query form; but theere is nothing left after the question mark!");
        }
        String stfnString = surlString.substring(question + 5, surlString.length());
        StFN stfn = null;
        try {
            stfn = StFN.make(stfnString);
        }
        catch (InvalidStFNAttributeException e) {
            log.warn("SFN: Unable to build -stfn- attribute with the String '" + stfnString + "'." + e);
        }
        return SFN.makeInQueryForm(machine, port, endpoint, stfn);
    }

    private static SFN makeFromSimpleForm(String surlString, int colon, int slash) throws ParsingSFNAttributesException, InvalidSFNAttributesException {
        String machineString = surlString.substring(0, colon);
        Machine machine = null;
        try {
            machine = Machine.make(machineString);
        }
        catch (InvalidMachineAttributeException e) {
            log.warn("SFN: Unable to build -machine- attribute with the String '" + machineString + "'." + e);
        }
        if (colon + 1 == slash) {
            throw new ParsingSFNAttributesException(surlString, "String interpreted as specifying port, and as not referring to query form; but the actual port number is missing since the first slash is found right after the colon");
        }
        String portString = surlString.substring(colon + 1, slash);
        Port port = null;
        try {
            port = Port.make(Integer.parseInt(portString));
        }
        catch (InvalidPortAttributeException e) {
            log.warn("SFN: Unable to build -port- attribute with the String '" + portString + "'." + e);
        }
        catch (NumberFormatException e) {
            log.warn("SFN: Unable to build -port- attribute with the String (NFE) '" + portString + "'." + e);
        }
        String stfnString = surlString.substring(slash, surlString.length());
        StFN stfn = null;
        try {
            stfn = StFN.make(stfnString);
        }
        catch (InvalidStFNAttributeException e) {
            log.warn("SFN: Unable to build -stfn- attribute with the String '" + stfnString + "'." + e);
        }
        return SFN.makeInSimpleForm(machine, port, stfn);
    }

    private static SFN makeFromQueryFormNoPort(String surlString, int question, int slash) throws ParsingSFNAttributesException, InvalidSFNAttributesException {
        String machine = surlString.substring(0, slash);
        Machine machineType = null;
        try {
            machineType = Machine.make(machine);
        }
        catch (InvalidMachineAttributeException e) {
            log.warn("SFN: Unable to build -machine- attribute with the String '" + machine + "'." + e);
        }
        String endpoint = surlString.substring(slash, question);
        EndPoint endpointType = null;
        try {
            endpointType = EndPoint.make(endpoint);
        }
        catch (InvalidEndPointAttributeException e) {
            log.warn("SFN: Unable to build -endpoint- attribute with the String '" + endpoint + "'." + e);
        }
        if (question + 5 >= surlString.length()) {
            throw new ParsingSFNAttributesException(surlString, "String interpreted as omitting the optional port specification, and as referring to query form; but nothing left after the question mark!");
        }
        String stfnString = surlString.substring(question + 5, surlString.length());
        StFN stfn = null;
        try {
            stfn = StFN.make(stfnString);
        }
        catch (InvalidStFNAttributeException e) {
            log.warn("SFN: Unable to build -stfn- attribute with the String '" + stfnString + "'." + e);
        }
        return SFN.makeInQueryForm(machineType, endpointType, stfn);
    }

    private static SFN makeFromSimpleFormNoPort(String surlString, int slash) throws ParsingSFNAttributesException, InvalidSFNAttributesException {
        String machine = surlString.substring(0, slash);
        Machine machineType = null;
        try {
            machineType = Machine.make(machine);
        }
        catch (InvalidMachineAttributeException e) {
            log.warn("SFN: Unable to build -machine- attribute with the String '" + machine + "'." + e);
        }
        String stfnString = surlString.substring(slash, surlString.length());
        StFN stfn = null;
        try {
            stfn = StFN.make(stfnString);
        }
        catch (InvalidStFNAttributeException e) {
            log.warn("SFN: Unable to build -stfn- attribute with the String '" + stfnString + "'." + e);
        }
        return SFN.makeInSimpleForm(machineType, stfn);
    }

    public Collection<SFN> getParents() {
        if (this.empty) {
            return new ArrayList<SFN>();
        }
        try {
            ArrayList<SFN> aux = new ArrayList<SFN>();
            Collection<StFN> auxStFN = this.pn.getParents();
            Iterator<StFN> i = auxStFN.iterator();
            while (i.hasNext()) {
                if (this.ep.isEmpty()) {
                    aux.add(SFN.makeInSimpleForm(this.m, this.p, i.next()));
                    continue;
                }
                aux.add(SFN.makeInQueryForm(this.m, this.p, this.ep, i.next()));
            }
            return aux;
        }
        catch (InvalidSFNAttributesException e) {
            return new ArrayList<SFN>();
        }
    }

    public SFN getParent() {
        if (this.empty) {
            return SFN.makeEmpty();
        }
        try {
            if (this.ep.isEmpty()) {
                return SFN.makeInSimpleForm(this.m, this.p, this.pn.getParent());
            }
            return SFN.makeInQueryForm(this.m, this.p, this.ep, this.pn.getParent());
        }
        catch (InvalidSFNAttributesException e) {
            return SFN.makeEmpty();
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Machine machine() {
        if (this.empty) {
            return Machine.makeEmpty();
        }
        return this.m;
    }

    public Port port() {
        if (this.empty) {
            return Port.makeEmpty();
        }
        return this.p;
    }

    public EndPoint endPoint() {
        if (this.empty) {
            return EndPoint.makeEmpty();
        }
        return this.ep;
    }

    public StFN stfn() {
        if (this.empty) {
            return StFN.makeEmpty();
        }
        return this.pn;
    }

    public String toString() {
        if (this.empty) {
            return "Empty SFN";
        }
        if (this.ep.isEmpty()) {
            if (this.p.isEmpty()) {
                return this.m.toString() + this.pn;
            }
            return this.m + ":" + this.p + this.pn;
        }
        if (this.p.isEmpty()) {
            return this.m.toString() + this.ep.toString() + "?SFN=" + this.pn;
        }
        return this.m + ":" + this.p + this.ep + "?SFN=" + this.pn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SFN)) {
            return false;
        }
        SFN sfno = (SFN)o;
        if (this.empty && sfno.empty) {
            return true;
        }
        return !this.empty && !sfno.empty && this.m.equals(sfno.m) && this.p.equals(sfno.p) && this.ep.equals(sfno.ep) && this.pn.equals(sfno.pn);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        hash = 37 * hash + this.m.hashCode();
        hash = 37 * hash + this.p.hashCode();
        hash = 37 * hash + this.ep.hashCode();
        hash = 37 * hash + this.pn.hashCode();
        return hash;
    }
}

