/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.InvalidPFNAttributeException;

public class PFN {
    private String name;
    private boolean empty = true;

    private PFN(String name, boolean empty) {
        this.name = name.replaceAll(" ", "");
        this.empty = empty;
    }

    public static PFN makeEmpty() {
        return new PFN("", true);
    }

    public static PFN make(String name) throws InvalidPFNAttributeException {
        if (name == null || name.equals("")) {
            throw new InvalidPFNAttributeException(name);
        }
        return new PFN(name, false);
    }

    public String getValue() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        if (this.empty) {
            return "Empty PFN";
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PFN)) {
            return false;
        }
        PFN po = (PFN)o;
        if (po.empty && this.empty) {
            return true;
        }
        return !po.empty && !this.empty && this.name.equals(po.name);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        return hash + 37 * this.name.hashCode();
    }
}

